/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.CompositeException;
import rx.exceptions.Exceptions;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.observers.Subscribers;

public final class OnSubscribeUsing<T, Resource>
implements Observable.OnSubscribe<T> {
    private final Func0<Resource> resourceFactory;
    private final Func1<? super Resource, ? extends Observable<? extends T>> observableFactory;
    private final Action1<? super Resource> dispose;
    private final boolean disposeEagerly;

    public OnSubscribeUsing(Func0<Resource> resourceFactory, Func1<? super Resource, ? extends Observable<? extends T>> observableFactory, Action1<? super Resource> dispose, boolean disposeEagerly) {
        this.resourceFactory = resourceFactory;
        this.observableFactory = observableFactory;
        this.dispose = dispose;
        this.disposeEagerly = disposeEagerly;
    }

    @Override
    public void call(Subscriber<? super T> subscriber2) {
        block9: {
            try {
                Observable<T> source2;
                Resource resource2 = this.resourceFactory.call();
                DisposeAction<? super Resource> disposeOnceOnly = new DisposeAction<Resource>(this.dispose, resource2);
                subscriber2.add(disposeOnceOnly);
                try {
                    source2 = this.observableFactory.call(resource2);
                }
                catch (Throwable e2) {
                    Throwable disposeError = this.dispose(disposeOnceOnly);
                    Exceptions.throwIfFatal(e2);
                    Exceptions.throwIfFatal(disposeError);
                    if (disposeError != null) {
                        subscriber2.onError(new CompositeException(e2, disposeError));
                    } else {
                        subscriber2.onError(e2);
                    }
                    return;
                }
                Observable<Object> observable = this.disposeEagerly ? source2.doOnTerminate(disposeOnceOnly) : source2.doAfterTerminate(disposeOnceOnly);
                try {
                    observable.unsafeSubscribe(Subscribers.wrap(subscriber2));
                }
                catch (Throwable e3) {
                    Throwable disposeError = this.dispose(disposeOnceOnly);
                    Exceptions.throwIfFatal(e3);
                    Exceptions.throwIfFatal(disposeError);
                    if (disposeError != null) {
                        subscriber2.onError(new CompositeException(e3, disposeError));
                        break block9;
                    }
                    subscriber2.onError(e3);
                }
            }
            catch (Throwable e4) {
                Exceptions.throwOrReport(e4, subscriber2);
            }
        }
    }

    private Throwable dispose(Action0 disposeOnceOnly) {
        try {
            disposeOnceOnly.call();
            return null;
        }
        catch (Throwable e2) {
            return e2;
        }
    }

    static final class DisposeAction<Resource>
    extends AtomicBoolean
    implements Action0,
    Subscription {
        private static final long serialVersionUID = 4262875056400218316L;
        private Action1<? super Resource> dispose;
        private Resource resource;

        DisposeAction(Action1<? super Resource> dispose, Resource resource2) {
            this.dispose = dispose;
            this.resource = resource2;
            this.lazySet(false);
        }

        @Override
        public void call() {
            if (this.compareAndSet(false, true)) {
                try {
                    this.dispose.call(this.resource);
                }
                finally {
                    this.resource = null;
                    this.dispose = null;
                }
            }
        }

        @Override
        public boolean isUnsubscribed() {
            return this.get();
        }

        @Override
        public void unsubscribe() {
            this.call();
        }
    }
}

