/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.parameter.validator;

import io.mantisrx.runtime.parameter.validator.Validation;
import io.mantisrx.runtime.parameter.validator.Validator;
import java.util.EnumSet;
import rx.functions.Func1;

public class Validators {
    private Validators() {
    }

    public static <T extends Number> Validator<T> range(final Number start, final Number end) {
        Func1 func = new Func1<T, Validation>(){

            @Override
            public Validation call(Number t1) {
                if (t1.doubleValue() >= start.doubleValue() && t1.doubleValue() <= end.doubleValue()) {
                    return Validation.passed();
                }
                return Validation.failed("range must be between " + start + " and " + end);
            }
        };
        return new Validator("range >=" + start + "<=" + end, func);
    }

    public static Validator<String> notNullOrEmpty() {
        Func1<String, Validation> func = new Func1<String, Validation>(){

            @Override
            public Validation call(String t1) {
                if (t1 == null || t1.length() <= 0) {
                    return Validation.failed("string must not be null or empty");
                }
                return Validation.passed();
            }
        };
        return new Validator<String>("not null or empty", func);
    }

    public static <T> Validator<T> alwaysPass() {
        Func1 func = new Func1<T, Validation>(){

            @Override
            public Validation call(T t1) {
                return Validation.passed();
            }
        };
        return new Validator("always passes validation", func);
    }

    public static <T extends Enum<T>> Validator<EnumSet<T>> notNullOrEmptyEnumCSV() {
        Func1 func = new Func1<EnumSet<T>, Validation>(){

            @Override
            public Validation call(EnumSet<T> t1) {
                if (t1.isEmpty()) {
                    return Validation.failed("enum constant csv list must not be null or empty");
                }
                return Validation.passed();
            }
        };
        return new Validator<EnumSet<T>>("not null or empty", func);
    }
}

