/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.parameter;

import io.mantisrx.runtime.parameter.Parameter;
import io.mantisrx.runtime.parameter.ParameterDefinition;
import io.mantisrx.runtime.parameter.Parameters;
import io.mantisrx.runtime.parameter.type.BooleanParameter;
import io.mantisrx.runtime.parameter.type.IntParameter;
import io.mantisrx.runtime.parameter.type.StringParameter;
import io.mantisrx.runtime.parameter.validator.Validation;
import io.mantisrx.runtime.parameter.validator.Validators;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Func1;

public class ParameterUtils {
    public static final String JOB_MASTER_AUTOSCALE_METRIC_SYSTEM_PARAM = "mantis.jobmaster.autoscale.metric";
    public static final String JOB_MASTER_AUTOSCALE_CONFIG_SYSTEM_PARAM = "mantis.jobmaster.autoscale.adaptive.config";
    public static final String JOB_MASTER_CLUTCH_SYSTEM_PARAM = "mantis.jobmaster.clutch.config";
    public static final String JOB_MASTER_CLUTCH_EXPERIMENTAL_PARAM = "mantis.jobmaster.clutch.experimental.enabled";
    public static final String JOB_MASTER_AUTOSCALE_SOURCEJOB_METRIC_PARAM = "mantis.jobmaster.autoscale.sourcejob.metric.enabled";
    public static final String JOB_MASTER_AUTOSCALE_SOURCEJOB_TARGET_PARAM = "mantis.jobmaster.autoscale.sourcejob.target";
    public static final String JOB_MASTER_AUTOSCALE_SOURCEJOB_DROP_METRIC_PATTERNS_PARAM = "mantis.jobmaster.autoscale.sourcejob.dropMetricPatterns";
    public static final String PER_STAGE_JVM_OPTS_FORMAT = "MANTIS_WORKER_JVM_OPTS_STAGE%d";
    public static final String STAGE_CONCURRENCY = "mantis.stageConcurrency";
    public static final int MAX_NUM_STAGES_FOR_JVM_OPTS_OVERRIDE = 5;
    static final ConcurrentHashMap<String, ParameterDefinition<?>> systemParams = new ConcurrentHashMap();
    private static Logger logger = LoggerFactory.getLogger(ParameterUtils.class);

    private ParameterUtils() {
    }

    public static Parameters createContextParameters(Map<String, ParameterDefinition<?>> parameterDefinitions, Parameter ... parameters) {
        HashMap<String, Parameter> indexed = new HashMap<String, Parameter>();
        parameterDefinitions.putAll(systemParams);
        for (Parameter parameter : parameters) {
            indexed.put(parameter.getName(), parameter);
        }
        return new Parameters(ParameterUtils.checkThenCreateState(parameterDefinitions, indexed), ParameterUtils.getRequiredParameters(parameterDefinitions), ParameterUtils.getParameterDefinitions(parameterDefinitions));
    }

    public static Parameters createContextParameters(Map<String, ParameterDefinition<?>> parameterDefinitions, List<Parameter> parameters) {
        parameterDefinitions.putAll(systemParams);
        Parameter[] array2 = parameters.toArray(new Parameter[parameters.size()]);
        return ParameterUtils.createContextParameters(parameterDefinitions, array2);
    }

    private static void validationCheck(Func1 validator, Object value, String name2) throws IllegalArgumentException {
        if (validator == null) {
            throw new IllegalArgumentException("Validator for parameter definition: " + name2 + " is null");
        }
        Validation validatorOutcome = null;
        try {
            validatorOutcome = (Validation)validator.call(value);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Parameter: " + name2 + " with value: " + value + " failed validator: " + t.getMessage(), t);
        }
        if (validatorOutcome.isFailedValidation()) {
            throw new IllegalArgumentException("Parameter: " + name2 + " with value: " + value + " failed validator: " + validatorOutcome.getFailedValidationReason());
        }
    }

    public static <T> Map<String, Object> checkThenCreateState(Map<String, ParameterDefinition<?>> parameterDefinitions, Map<String, Parameter> parameters) throws IllegalArgumentException {
        HashMap<String, Object> parameterState = new HashMap<String, Object>();
        for (ParameterDefinition<?> definition : parameterDefinitions.values()) {
            if (definition.isRequired() && !parameters.containsKey(definition.getName()) && definition.getDefaultValue() == null) {
                throw new IllegalArgumentException("Missing required parameter: " + definition.getName() + ", check job parameter definitions.");
            }
            if (definition.getDefaultValue() == null) continue;
            ParameterUtils.validationCheck(definition.getValidator().getValidator(), definition.getDefaultValue(), "[default value] " + definition.getName());
            parameterState.put(definition.getName(), definition.getDefaultValue());
        }
        for (Parameter parameter : parameters.values()) {
            String name2 = parameter.getName();
            Object value = null;
            ParameterDefinition<?> definition = null;
            definition = parameterDefinitions.get(name2);
            if (definition == null) {
                if (name2.startsWith("mantis.") || name2.startsWith("MANTIS")) {
                    logger.info("mantis runtime parameter " + name2 + " used, looking up definition >>>");
                    definition = systemParams.get(name2);
                } else {
                    logger.warn("No parameter definition for parameter with name: {}, will skip parameter", (Object)name2);
                    continue;
                }
            }
            Func1<?, Validation> validator = definition.getValidator().getValidator();
            value = definition.getDecoder().decode(parameter.getValue());
            ParameterUtils.validationCheck(validator, value, name2);
            parameterState.put(name2, value);
        }
        return parameterState;
    }

    public static Set<String> getRequiredParameters(Map<String, ParameterDefinition<?>> parameterDefinitions) {
        HashSet<String> requiredParameters = new HashSet<String>();
        for (ParameterDefinition<?> definition : parameterDefinitions.values()) {
            if (!definition.isRequired()) continue;
            requiredParameters.add(definition.getName());
        }
        return requiredParameters;
    }

    public static Set<String> getParameterDefinitions(Map<String, ParameterDefinition<?>> parameterDefinitions) {
        HashSet<String> parameters = new HashSet<String>();
        for (ParameterDefinition<?> definition : parameterDefinitions.values()) {
            parameters.add(definition.getName());
        }
        return parameters;
    }

    public static Map<String, ParameterDefinition<?>> getSystemParameters() {
        return Collections.unmodifiableMap(systemParams);
    }

    static {
        ParameterDefinition<Integer> keyBuffer = new IntParameter().name("mantis.w2w.toKeyBuffer").validator(Validators.range(1, 100000)).defaultValue(50000).description("per connection buffer from Scalar To Key stage").build();
        systemParams.put(keyBuffer.getName(), keyBuffer);
        ParameterDefinition<Boolean> useSPSC4sse = new BooleanParameter().name("mantis.sse.spsc").description("Whether to use spsc or blocking queue for SSE").defaultValue(false).build();
        systemParams.put(useSPSC4sse.getName(), useSPSC4sse);
        ParameterDefinition<Boolean> useSPSC4w2w = new BooleanParameter().name("mantis.w2w.spsc").description("Whether to use spsc or blocking queue").defaultValue(false).build();
        systemParams.put(useSPSC4w2w.getName(), useSPSC4w2w);
        ParameterDefinition<Boolean> singleNettyThread = new BooleanParameter().name("mantis.netty.useSingleThread").description("use single netty thread").defaultValue(false).build();
        systemParams.put(singleNettyThread.getName(), singleNettyThread);
        ParameterDefinition<Integer> w2wtoKeyMaxChunkSize = new IntParameter().name("mantis.w2w.toKeyMaxChunkSize").validator(Validators.range(1, 100000)).defaultValue(1000).description("batch size for bytes drained from Scalar To Key stage").build();
        systemParams.put(w2wtoKeyMaxChunkSize.getName(), w2wtoKeyMaxChunkSize);
        ParameterDefinition<Integer> w2wtoKeyThreads = new IntParameter().name("mantis.w2w.toKeyThreads").validator(Validators.range(1, 8)).description("number of drainer threads on the ScalarToKey stage").defaultValue(1).build();
        systemParams.put(w2wtoKeyThreads.getName(), w2wtoKeyThreads);
        ParameterDefinition<Integer> sseBuffer = new IntParameter().name("mantis.sse.bufferCapacity").validator(Validators.range(1, 100000)).description("buffer on SSE per connection").defaultValue(25000).build();
        systemParams.put(sseBuffer.getName(), sseBuffer);
        ParameterDefinition<Integer> sseChunkSize = new IntParameter().name("mantis.sse.maxChunkSize").validator(Validators.range(1, 100000)).description("SSE chunk size").defaultValue(1000).build();
        systemParams.put(sseChunkSize.getName(), sseChunkSize);
        ParameterDefinition<Integer> sseMaxReadTime = new IntParameter().name("mantis.sse.maxReadTimeMSec").validator(Validators.range(1, 100000)).description("interval at which buffer is drained to write to SSE").defaultValue(250).build();
        systemParams.put(sseMaxReadTime.getName(), sseMaxReadTime);
        ParameterDefinition<Integer> sse_numConsumerThreads = new IntParameter().name("mantis.sse.numConsumerThreads").validator(Validators.range(1, 8)).description("number of consumer threads draining the queue to write to SSE").defaultValue(1).build();
        systemParams.put(sse_numConsumerThreads.getName(), sse_numConsumerThreads);
        ParameterDefinition<String> jobMasterAutoScaleMetric = new StringParameter().name(JOB_MASTER_AUTOSCALE_METRIC_SYSTEM_PARAM).validator(Validators.alwaysPass()).description("Custom autoscale metric for Job Master to use with UserDefined Scaling Strategy. Format: <metricGroup>::<metricName>::<algo> where metricGroup and metricName should exactly match the metric published via Mantis MetricsRegistry and algo = MAX/AVERAGE").defaultValue("").build();
        systemParams.put(jobMasterAutoScaleMetric.getName(), jobMasterAutoScaleMetric);
        ParameterDefinition<String> jobMasterAutoScaleConfig = new StringParameter().name(JOB_MASTER_CLUTCH_SYSTEM_PARAM).validator(Validators.alwaysPass()).description("Configuration for the clutch autoscaler.").defaultValue("").build();
        systemParams.put(jobMasterAutoScaleConfig.getName(), jobMasterAutoScaleConfig);
        ParameterDefinition<Boolean> clutchExperimentalEnabled = new BooleanParameter().name(JOB_MASTER_CLUTCH_EXPERIMENTAL_PARAM).validator(Validators.alwaysPass()).description("Enables the experimental version of the Clutch autoscaler. Note this is different from the Clutch used in production today.").defaultValue(false).build();
        systemParams.put(clutchExperimentalEnabled.getName(), clutchExperimentalEnabled);
        ParameterDefinition<String> jvmOptions = new StringParameter().name("MANTIS_WORKER_JVM_OPTS").validator(Validators.alwaysPass()).defaultValue("").description("command line options for the mantis worker JVM, setting this field would override the default GC settings").build();
        systemParams.put(jvmOptions.getName(), jvmOptions);
        ParameterDefinition<Integer> stageConcurrency = new IntParameter().name(STAGE_CONCURRENCY).validator(Validators.range(-1, 16)).defaultValue(-1).description("Number of cores to use for stage processing").build();
        systemParams.put(stageConcurrency.getName(), stageConcurrency);
        for (int stageNum = 0; stageNum <= 5; ++stageNum) {
            String paramName = String.format(PER_STAGE_JVM_OPTS_FORMAT, stageNum);
            systemParams.put(paramName, new StringParameter().name(paramName).validator(Validators.alwaysPass()).defaultValue("").description("command line options for stage " + stageNum + " mantis worker JVM, setting this field would override the default GC settings").build());
        }
        ParameterDefinition<Boolean> sseBinary = new BooleanParameter().name("mantis.EnableCompressedBinary").validator(Validators.alwaysPass()).defaultValue(false).description("Enables binary compression of SSE data").build();
        systemParams.put(sseBinary.getName(), sseBinary);
        ParameterDefinition<String> compressionDelimiter = new StringParameter().name("mantis.CompressionDelimiter").validator(Validators.alwaysPass()).defaultValue("$$$").description("Delimiter for separating SSE data before compression").build();
        systemParams.put(compressionDelimiter.getName(), compressionDelimiter);
        ParameterDefinition<Boolean> autoscaleSourceJobMetricEnabled = new BooleanParameter().name(JOB_MASTER_AUTOSCALE_SOURCEJOB_METRIC_PARAM).validator(Validators.alwaysPass()).defaultValue(false).description("Enable source job drop metrics to be used for autoscaling the 1st stage").build();
        systemParams.put(autoscaleSourceJobMetricEnabled.getName(), autoscaleSourceJobMetricEnabled);
        ParameterDefinition<String> autoscaleSourceJobTarget = new StringParameter().name(JOB_MASTER_AUTOSCALE_SOURCEJOB_TARGET_PARAM).validator(Validators.alwaysPass()).defaultValue("{}").description("Json config to specify source job targets for autoscale metrics. This param is not needed if the 'target' param is already present. Example: {\"targets\": [{\"sourceJobName\":<jobName>, \"clientId\":<clientId>}]}").build();
        systemParams.put(autoscaleSourceJobTarget.getName(), autoscaleSourceJobTarget);
        ParameterDefinition<String> autoscaleSourceJobDropMetricPattern = new StringParameter().name(JOB_MASTER_AUTOSCALE_SOURCEJOB_DROP_METRIC_PATTERNS_PARAM).validator(Validators.alwaysPass()).defaultValue("").description("Additional metrics pattern for source job drops. Comma separated list, supports dynamic client ID by using '_CLIENT_ID_' as a token. Each metric should be expressed in the same format as 'mantis.jobmaster.autoscale.metric'. Example: PushServerSse:clientId=_CLIENT_ID_:*::droppedCounter::MAX,ServerSentEventRequestHandler:clientId=_CLIENT_ID_:*::droppedCounter::MAX").build();
        systemParams.put(autoscaleSourceJobDropMetricPattern.getName(), autoscaleSourceJobDropMetricPattern);
    }
}

