/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.AbstractQueue;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Observer;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func0;
import rx.functions.Func2;
import rx.internal.operators.BackpressureUtils;
import rx.internal.operators.NotificationLite;
import rx.internal.util.atomic.SpscLinkedAtomicQueue;
import rx.internal.util.unsafe.SpscLinkedQueue;
import rx.internal.util.unsafe.UnsafeAccess;

public final class OperatorScan<R, T>
implements Observable.Operator<R, T> {
    private final Func0<R> initialValueFactory;
    final Func2<R, ? super T, R> accumulator;
    private static final Object NO_INITIAL_VALUE = new Object();

    public OperatorScan(final R initialValue, Func2<R, ? super T, R> accumulator) {
        this(new Func0<R>(){

            @Override
            public R call() {
                return initialValue;
            }
        }, accumulator);
    }

    public OperatorScan(Func0<R> initialValueFactory, Func2<R, ? super T, R> accumulator) {
        this.initialValueFactory = initialValueFactory;
        this.accumulator = accumulator;
    }

    public OperatorScan(Func2<R, ? super T, R> accumulator) {
        this(NO_INITIAL_VALUE, accumulator);
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super R> child) {
        final R initialValue = this.initialValueFactory.call();
        if (initialValue == NO_INITIAL_VALUE) {
            return new Subscriber<T>(child){
                boolean once;
                R value;

                @Override
                public void onNext(T t) {
                    Object v;
                    if (!this.once) {
                        this.once = true;
                        v = t;
                    } else {
                        v = this.value;
                        try {
                            v = OperatorScan.this.accumulator.call(v, t);
                        }
                        catch (Throwable e2) {
                            Exceptions.throwOrReport(e2, child, t);
                            return;
                        }
                    }
                    this.value = v;
                    child.onNext(v);
                }

                @Override
                public void onError(Throwable e2) {
                    child.onError(e2);
                }

                @Override
                public void onCompleted() {
                    child.onCompleted();
                }
            };
        }
        final InitialProducer<? super R> ip = new InitialProducer<R>(initialValue, child);
        Subscriber parent = new Subscriber<T>(){
            private R value;
            {
                this.value = initialValue;
            }

            @Override
            public void onNext(T currentValue) {
                Object v = this.value;
                try {
                    v = OperatorScan.this.accumulator.call(v, currentValue);
                }
                catch (Throwable e2) {
                    Exceptions.throwOrReport(e2, this, currentValue);
                    return;
                }
                this.value = v;
                ip.onNext(v);
            }

            @Override
            public void onError(Throwable e2) {
                ip.onError(e2);
            }

            @Override
            public void onCompleted() {
                ip.onCompleted();
            }

            @Override
            public void setProducer(Producer producer) {
                ip.setProducer(producer);
            }
        };
        child.add(parent);
        child.setProducer(ip);
        return parent;
    }

    static final class InitialProducer<R>
    implements Producer,
    Observer<R> {
        final Subscriber<? super R> child;
        final Queue<Object> queue;
        boolean emitting;
        boolean missed;
        long missedRequested;
        final AtomicLong requested;
        volatile Producer producer;
        volatile boolean done;
        Throwable error;

        public InitialProducer(R initialValue, Subscriber<? super R> child) {
            this.child = child;
            AbstractQueue q = UnsafeAccess.isUnsafeAvailable() ? new SpscLinkedQueue() : new SpscLinkedAtomicQueue();
            this.queue = q;
            q.offer(NotificationLite.next(initialValue));
            this.requested = new AtomicLong();
        }

        @Override
        public void onNext(R t) {
            this.queue.offer(NotificationLite.next(t));
            this.emit();
        }

        boolean checkTerminated(boolean d, boolean empty2, Subscriber<? super R> child) {
            if (child.isUnsubscribed()) {
                return true;
            }
            if (d) {
                Throwable err = this.error;
                if (err != null) {
                    child.onError(err);
                    return true;
                }
                if (empty2) {
                    child.onCompleted();
                    return true;
                }
            }
            return false;
        }

        @Override
        public void onError(Throwable e2) {
            this.error = e2;
            this.done = true;
            this.emit();
        }

        @Override
        public void onCompleted() {
            this.done = true;
            this.emit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void request(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("n >= required but it was " + n);
            }
            if (n != 0L) {
                BackpressureUtils.getAndAddRequest(this.requested, n);
                Producer p = this.producer;
                if (p == null) {
                    AtomicLong atomicLong = this.requested;
                    synchronized (atomicLong) {
                        p = this.producer;
                        if (p == null) {
                            long mr = this.missedRequested;
                            this.missedRequested = BackpressureUtils.addCap(mr, n);
                        }
                    }
                }
                if (p != null) {
                    p.request(n);
                }
                this.emit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setProducer(Producer p) {
            long mr;
            if (p == null) {
                throw new NullPointerException();
            }
            AtomicLong atomicLong = this.requested;
            synchronized (atomicLong) {
                if (this.producer != null) {
                    throw new IllegalStateException("Can't set more than one Producer!");
                }
                mr = this.missedRequested;
                if (mr != Long.MAX_VALUE) {
                    --mr;
                }
                this.missedRequested = 0L;
                this.producer = p;
            }
            if (mr > 0L) {
                p.request(mr);
            }
            this.emit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emit() {
            InitialProducer initialProducer = this;
            synchronized (initialProducer) {
                if (this.emitting) {
                    this.missed = true;
                    return;
                }
                this.emitting = true;
            }
            this.emitLoop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitLoop() {
            Subscriber<R> child = this.child;
            Queue<Object> queue = this.queue;
            AtomicLong requested = this.requested;
            long r = requested.get();
            boolean empty2;
            boolean d;
            while (!this.checkTerminated(d = this.done, empty2 = queue.isEmpty(), child)) {
                long e2;
                for (e2 = 0L; e2 != r; ++e2) {
                    d = this.done;
                    Object o = queue.poll();
                    boolean bl = empty2 = o == null;
                    if (this.checkTerminated(d, empty2, child)) {
                        return;
                    }
                    if (empty2) break;
                    Object v = NotificationLite.getValue(o);
                    try {
                        child.onNext(v);
                        continue;
                    }
                    catch (Throwable ex) {
                        Exceptions.throwOrReport(ex, child, v);
                        return;
                    }
                }
                if (e2 != 0L && r != Long.MAX_VALUE) {
                    r = BackpressureUtils.produced(requested, e2);
                }
                InitialProducer initialProducer = this;
                synchronized (initialProducer) {
                    if (!this.missed) {
                        this.emitting = false;
                        return;
                    }
                    this.missed = false;
                }
            }
            return;
        }
    }
}

