/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.exceptions.AssemblyStackTraceException;

public final class OnSubscribeOnAssembly<T>
implements Observable.OnSubscribe<T> {
    final Observable.OnSubscribe<T> source;
    final String stacktrace;
    public static volatile boolean fullStackTrace;

    public OnSubscribeOnAssembly(Observable.OnSubscribe<T> source2) {
        this.source = source2;
        this.stacktrace = OnSubscribeOnAssembly.createStacktrace();
    }

    static String createStacktrace() {
        StackTraceElement[] stacktraceElements = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder("Assembly trace:");
        for (StackTraceElement e2 : stacktraceElements) {
            String row = e2.toString();
            if (!fullStackTrace && (e2.getLineNumber() <= 1 || row.contains("RxJavaHooks.") || row.contains("OnSubscribeOnAssembly") || row.contains(".junit.runner") || row.contains(".junit4.runner") || row.contains(".junit.internal") || row.contains("sun.reflect") || row.contains("java.lang.Thread.") || row.contains("ThreadPoolExecutor") || row.contains("org.apache.catalina.") || row.contains("org.apache.tomcat."))) continue;
            sb.append("\n at ").append(row);
        }
        return sb.append("\nOriginal exception:").toString();
    }

    @Override
    public void call(Subscriber<? super T> t) {
        this.source.call(new OnAssemblySubscriber<T>(t, this.stacktrace));
    }

    static final class OnAssemblySubscriber<T>
    extends Subscriber<T> {
        final Subscriber<? super T> actual;
        final String stacktrace;

        public OnAssemblySubscriber(Subscriber<? super T> actual, String stacktrace2) {
            super(actual);
            this.actual = actual;
            this.stacktrace = stacktrace2;
        }

        @Override
        public void onCompleted() {
            this.actual.onCompleted();
        }

        @Override
        public void onError(Throwable e2) {
            new AssemblyStackTraceException(this.stacktrace).attachTo(e2);
            this.actual.onError(e2);
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
        }
    }
}

