/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import org.jctools.queues.BaseLinkedQueue;
import org.jctools.queues.LinkedQueueNode;
import org.jctools.queues.MessagePassingQueue;

abstract class MpscLinkedQueue<E>
extends BaseLinkedQueue<E> {
    protected MpscLinkedQueue() {
        this.consumerNode = new LinkedQueueNode();
        this.xchgProducerNode(this.consumerNode);
    }

    protected abstract LinkedQueueNode<E> xchgProducerNode(LinkedQueueNode<E> var1);

    @Override
    public final boolean offer(E e2) {
        if (null == e2) {
            throw new NullPointerException();
        }
        LinkedQueueNode<E> nextNode = new LinkedQueueNode<E>(e2);
        LinkedQueueNode<E> prevProducerNode = this.xchgProducerNode(nextNode);
        prevProducerNode.soNext(nextNode);
        return true;
    }

    @Override
    public final E poll() {
        LinkedQueueNode currConsumerNode = this.lpConsumerNode();
        LinkedQueueNode nextNode = currConsumerNode.lvNext();
        if (nextNode != null) {
            return this.getSingleConsumerNodeValue(currConsumerNode, nextNode);
        }
        if (currConsumerNode != this.lvProducerNode()) {
            while ((nextNode = currConsumerNode.lvNext()) == null) {
            }
            return this.getSingleConsumerNodeValue(currConsumerNode, nextNode);
        }
        return null;
    }

    @Override
    public final E peek() {
        LinkedQueueNode currConsumerNode = this.consumerNode;
        LinkedQueueNode nextNode = currConsumerNode.lvNext();
        if (nextNode != null) {
            return nextNode.lpValue();
        }
        if (currConsumerNode != this.lvProducerNode()) {
            while ((nextNode = currConsumerNode.lvNext()) == null) {
            }
            return nextNode.lpValue();
        }
        return null;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        long result = 0L;
        do {
            this.fill(s, 4096);
        } while ((result += 4096L) <= 0x7FFFEFFFL);
        return (int)result;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit2) {
        LinkedQueueNode<E> tail;
        if (limit2 == 0) {
            return 0;
        }
        LinkedQueueNode<E> head = tail = new LinkedQueueNode<E>(s.get());
        for (int i = 1; i < limit2; ++i) {
            LinkedQueueNode<E> temp = new LinkedQueueNode<E>(s.get());
            tail.soNext(temp);
            tail = temp;
        }
        LinkedQueueNode<E> oldPNode = this.xchgProducerNode(tail);
        oldPNode.soNext(head);
        return limit2;
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        while (exit.keepRunning()) {
            this.fill(s, 4096);
        }
    }
}

