/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;

public class NotFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = 6131563330944994230L;
    private final IOFileFilter filter;

    public NotFileFilter(IOFileFilter filter2) {
        if (filter2 == null) {
            throw new IllegalArgumentException("The filter must not be null");
        }
        this.filter = filter2;
    }

    @Override
    public boolean accept(File file2) {
        return !this.filter.accept(file2);
    }

    @Override
    public boolean accept(File file2, String name2) {
        return !this.filter.accept(file2, name2);
    }

    @Override
    public FileVisitResult accept(Path file2, BasicFileAttributes attributes) {
        return this.not(this.filter.accept(file2, attributes));
    }

    private FileVisitResult not(FileVisitResult accept) {
        return accept == FileVisitResult.CONTINUE ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }

    @Override
    public String toString() {
        return "NOT (" + this.filter.toString() + ")";
    }
}

