/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.protocol.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpResponseHeaders {
    private final HttpResponse nettyResponse;
    private final HttpHeaders nettyHeaders;

    public HttpResponseHeaders(HttpResponse nettyResponse) {
        this.nettyResponse = nettyResponse;
        this.nettyHeaders = this.nettyResponse.headers();
    }

    public HttpHeaders add(HttpHeaders headers) {
        return this.nettyHeaders.add(headers);
    }

    public HttpHeaders add(CharSequence name2, Object value) {
        return this.nettyHeaders.add(name2, value);
    }

    public HttpHeaders add(CharSequence name2, Iterable<?> values) {
        return this.nettyHeaders.add(name2, values);
    }

    public HttpHeaders add(String name2, Object value) {
        return this.nettyHeaders.add(name2, value);
    }

    public HttpHeaders add(String name2, Iterable<?> values) {
        return this.nettyHeaders.add(name2, values);
    }

    public void addDateHeader(CharSequence name2, Date value) {
        HttpHeaders.addDateHeader((HttpMessage)this.nettyResponse, name2, value);
    }

    public void addDateHeader(String name2, Date value) {
        HttpHeaders.addDateHeader((HttpMessage)this.nettyResponse, name2, value);
    }

    public void addHeader(CharSequence name2, Object value) {
        HttpHeaders.addHeader((HttpMessage)this.nettyResponse, name2, value);
    }

    public void addHeader(String name2, Object value) {
        HttpHeaders.addHeader((HttpMessage)this.nettyResponse, name2, value);
    }

    public void addIntHeader(CharSequence name2, int value) {
        HttpHeaders.addIntHeader((HttpMessage)this.nettyResponse, name2, value);
    }

    public void addIntHeader(String name2, int value) {
        HttpHeaders.addIntHeader((HttpMessage)this.nettyResponse, name2, value);
    }

    public HttpHeaders clear() {
        return this.nettyHeaders.clear();
    }

    public void clearHeaders() {
        HttpHeaders.clearHeaders(this.nettyResponse);
    }

    public boolean contains(CharSequence name2) {
        return this.nettyHeaders.contains(name2);
    }

    public boolean contains(CharSequence name2, CharSequence value, boolean ignoreCaseValue) {
        return this.nettyHeaders.contains(name2, value, ignoreCaseValue);
    }

    public boolean contains(String name2) {
        return this.nettyHeaders.contains(name2);
    }

    public boolean contains(String name2, String value, boolean ignoreCaseValue) {
        return this.nettyHeaders.contains(name2, value, ignoreCaseValue);
    }

    public void encodeAscii(CharSequence seq, ByteBuf buf) {
        HttpHeaders.encodeAscii(seq, buf);
    }

    public List<Map.Entry<String, String>> entries() {
        return this.nettyHeaders.entries();
    }

    public boolean equalsIgnoreCase(CharSequence name1, CharSequence name2) {
        return HttpHeaders.equalsIgnoreCase(name1, name2);
    }

    public String get(CharSequence name2) {
        return this.nettyHeaders.get(name2);
    }

    public String get(String name2) {
        return this.nettyHeaders.get(name2);
    }

    public List<String> getAll(CharSequence name2) {
        return this.nettyHeaders.getAll(name2);
    }

    public List<String> getAll(String name2) {
        return this.nettyHeaders.getAll(name2);
    }

    public long getContentLength() {
        return HttpHeaders.getContentLength(this.nettyResponse);
    }

    public long getContentLength(long defaultValue) {
        return HttpHeaders.getContentLength(this.nettyResponse, defaultValue);
    }

    public Date getDate() throws ParseException {
        return HttpHeaders.getDate(this.nettyResponse);
    }

    public Date getDate(Date defaultValue) {
        return HttpHeaders.getDate(this.nettyResponse, defaultValue);
    }

    public Date getDateHeader(CharSequence name2) throws ParseException {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyResponse, name2);
    }

    public Date getDateHeader(CharSequence name2, Date defaultValue) {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyResponse, name2, defaultValue);
    }

    public Date getDateHeader(String name2) throws ParseException {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyResponse, name2);
    }

    public Date getDateHeader(String name2, Date defaultValue) {
        return HttpHeaders.getDateHeader((HttpMessage)this.nettyResponse, name2, defaultValue);
    }

    public String getHeader(CharSequence name2) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyResponse, name2);
    }

    public String getHeader(CharSequence name2, String defaultValue) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyResponse, name2, defaultValue);
    }

    public String getHeader(String name2) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyResponse, name2);
    }

    public String getHeader(String name2, String defaultValue) {
        return HttpHeaders.getHeader((HttpMessage)this.nettyResponse, name2, defaultValue);
    }

    public String getHost() {
        return HttpHeaders.getHost(this.nettyResponse);
    }

    public String getHost(String defaultValue) {
        return HttpHeaders.getHost(this.nettyResponse, defaultValue);
    }

    public int getIntHeader(CharSequence name2) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyResponse, name2);
    }

    public int getIntHeader(CharSequence name2, int defaultValue) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyResponse, name2, defaultValue);
    }

    public int getIntHeader(String name2) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyResponse, name2);
    }

    public int getIntHeader(String name2, int defaultValue) {
        return HttpHeaders.getIntHeader((HttpMessage)this.nettyResponse, name2, defaultValue);
    }

    public boolean is100ContinueExpected() {
        return HttpHeaders.is100ContinueExpected(this.nettyResponse);
    }

    public boolean isContentLengthSet() {
        return HttpHeaders.isContentLengthSet(this.nettyResponse);
    }

    public boolean isEmpty() {
        return this.nettyHeaders.isEmpty();
    }

    public boolean isKeepAlive() {
        return HttpHeaders.isKeepAlive(this.nettyResponse);
    }

    public boolean isTransferEncodingChunked() {
        return HttpHeaders.isTransferEncodingChunked(this.nettyResponse);
    }

    public Set<String> names() {
        return this.nettyHeaders.names();
    }

    public CharSequence newEntity(String name2) {
        return HttpHeaders.newEntity(name2);
    }

    public HttpHeaders remove(CharSequence name2) {
        return this.nettyHeaders.remove(name2);
    }

    public HttpHeaders remove(String name2) {
        return this.nettyHeaders.remove(name2);
    }

    public void removeHeader(CharSequence name2) {
        HttpHeaders.removeHeader((HttpMessage)this.nettyResponse, name2);
    }

    public void removeHeader(String name2) {
        HttpHeaders.removeHeader((HttpMessage)this.nettyResponse, name2);
    }

    public void removeTransferEncodingChunked() {
        HttpHeaders.removeTransferEncodingChunked(this.nettyResponse);
    }

    public HttpHeaders set(HttpHeaders headers) {
        return this.nettyHeaders.set(headers);
    }

    public HttpHeaders set(CharSequence name2, Object value) {
        return this.nettyHeaders.set(name2, value);
    }

    public HttpHeaders set(CharSequence name2, Iterable<?> values) {
        return this.nettyHeaders.set(name2, values);
    }

    public HttpHeaders set(String name2, Object value) {
        return this.nettyHeaders.set(name2, value);
    }

    public HttpHeaders set(String name2, Iterable<?> values) {
        return this.nettyHeaders.set(name2, values);
    }

    public void set100ContinueExpected() {
        HttpHeaders.set100ContinueExpected(this.nettyResponse);
    }

    public void set100ContinueExpected(boolean set2) {
        HttpHeaders.set100ContinueExpected(this.nettyResponse, set2);
    }

    public void setContentLength(long length) {
        HttpHeaders.setContentLength(this.nettyResponse, length);
    }

    public void setDate(Date value) {
        HttpHeaders.setDate(this.nettyResponse, value);
    }

    public void setDateHeader(CharSequence name2, Date value) {
        HttpHeaders.setDateHeader((HttpMessage)this.nettyResponse, name2, value);
    }

    public void setDateHeader(CharSequence name2, Iterable<Date> values) {
        HttpHeaders.setDateHeader((HttpMessage)this.nettyResponse, name2, values);
    }

    public void setDateHeader(String name2, Date value) {
        HttpHeaders.setDateHeader((HttpMessage)this.nettyResponse, name2, value);
    }

    public void setDateHeader(String name2, Iterable<Date> values) {
        HttpHeaders.setDateHeader((HttpMessage)this.nettyResponse, name2, values);
    }

    public void setHeader(CharSequence name2, Object value) {
        HttpHeaders.setHeader((HttpMessage)this.nettyResponse, name2, value);
    }

    public void setHeader(CharSequence name2, Iterable<?> values) {
        HttpHeaders.setHeader((HttpMessage)this.nettyResponse, name2, values);
    }

    public void setHeader(String name2, Object value) {
        HttpHeaders.setHeader((HttpMessage)this.nettyResponse, name2, value);
    }

    public void setHeader(String name2, Iterable<?> values) {
        HttpHeaders.setHeader((HttpMessage)this.nettyResponse, name2, values);
    }

    public void setHost(CharSequence value) {
        HttpHeaders.setHost((HttpMessage)this.nettyResponse, value);
    }

    public void setHost(String value) {
        HttpHeaders.setHost((HttpMessage)this.nettyResponse, value);
    }

    public void setIntHeader(CharSequence name2, int value) {
        HttpHeaders.setIntHeader((HttpMessage)this.nettyResponse, name2, value);
    }

    public void setIntHeader(CharSequence name2, Iterable<Integer> values) {
        HttpHeaders.setIntHeader((HttpMessage)this.nettyResponse, name2, values);
    }

    public void setIntHeader(String name2, int value) {
        HttpHeaders.setIntHeader((HttpMessage)this.nettyResponse, name2, value);
    }

    public void setIntHeader(String name2, Iterable<Integer> values) {
        HttpHeaders.setIntHeader((HttpMessage)this.nettyResponse, name2, values);
    }

    public void setKeepAlive(boolean keepAlive) {
        HttpHeaders.setKeepAlive(this.nettyResponse, keepAlive);
    }

    public void setTransferEncodingChunked() {
        HttpHeaders.setTransferEncodingChunked(this.nettyResponse);
    }
}

