/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.protocol.http;

import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.internal.operators.BufferUntilSubscriber;
import rx.observers.Subscribers;
import rx.schedulers.Schedulers;
import rx.subjects.Subject;
import rx.subscriptions.Subscriptions;

public final class UnicastContentSubject<T>
extends Subject<T, T> {
    private final State<T> state;
    private volatile Observable<Long> timeoutScheduler;

    private UnicastContentSubject(State<T> state) {
        super(new OnSubscribeAction<T>(state));
        this.state = state;
        this.timeoutScheduler = Observable.empty();
    }

    private UnicastContentSubject(State<T> state, long noSubscriptionTimeout, TimeUnit timeUnit, Scheduler scheduler) {
        super(new OnSubscribeAction<T>(state));
        this.state = state;
        this.timeoutScheduler = Observable.interval(noSubscriptionTimeout, timeUnit, scheduler).take(1);
    }

    public static <T> UnicastContentSubject<T> createWithoutNoSubscriptionTimeout(Action0 onUnsubscribe) {
        State state = new State(onUnsubscribe, null);
        return new UnicastContentSubject(state);
    }

    public static <T> UnicastContentSubject<T> createWithoutNoSubscriptionTimeout() {
        return UnicastContentSubject.createWithoutNoSubscriptionTimeout(null);
    }

    public static <T> UnicastContentSubject<T> create(long noSubscriptionTimeout, TimeUnit timeUnit) {
        return UnicastContentSubject.create(noSubscriptionTimeout, timeUnit, (Action0)null);
    }

    public static <T> UnicastContentSubject<T> create(long noSubscriptionTimeout, TimeUnit timeUnit, Action0 onUnsubscribe) {
        return UnicastContentSubject.create(noSubscriptionTimeout, timeUnit, Schedulers.computation(), onUnsubscribe);
    }

    public static <T> UnicastContentSubject<T> create(long noSubscriptionTimeout, TimeUnit timeUnit, Scheduler timeoutScheduler) {
        return UnicastContentSubject.create(noSubscriptionTimeout, timeUnit, timeoutScheduler, null);
    }

    public static <T> UnicastContentSubject<T> create(long noSubscriptionTimeout, TimeUnit timeUnit, Scheduler timeoutScheduler, Action0 onUnsubscribe) {
        return UnicastContentSubject.create(noSubscriptionTimeout, timeUnit, timeoutScheduler, onUnsubscribe, null);
    }

    public static <T> UnicastContentSubject<T> create(long noSubscriptionTimeout, TimeUnit timeUnit, Scheduler timeoutScheduler, Action0 onUnsubscribe, Action1<T> onDispose) {
        State state = new State(onUnsubscribe, onDispose);
        return new UnicastContentSubject(state, noSubscriptionTimeout, timeUnit, timeoutScheduler);
    }

    public boolean disposeIfNotSubscribed() {
        if (this.state.casState(State.STATES.UNSUBSCRIBED, State.STATES.DISPOSED)) {
            Subscriber sub = null == ((State)this.state).onDispose ? Subscribers.empty() : Subscribers.create(((State)this.state).onDispose);
            ((State)this.state).bufferedObservable.subscribe(sub);
            return true;
        }
        return false;
    }

    public void updateTimeoutIfNotScheduled(long noSubscriptionTimeout, TimeUnit timeUnit) {
        if (0 == ((State)this.state).timeoutScheduled) {
            this.timeoutScheduler = Observable.interval(noSubscriptionTimeout, timeUnit).take(1);
        }
    }

    @Override
    public void onCompleted() {
        ((State)this.state).bufferedObserver.onCompleted();
    }

    @Override
    public void onError(Throwable e2) {
        ((State)this.state).bufferedObserver.onError(e2);
    }

    @Override
    public void onNext(T t) {
        ReferenceCountUtil.retain(t);
        ((State)this.state).bufferedObserver.onNext(t);
        if (this.state.casTimeoutScheduled() && ((State)this.state).state == State.STATES.UNSUBSCRIBED.ordinal()) {
            this.state.setReleaseSubscription(this.timeoutScheduler.subscribe(new Action1<Long>(){

                @Override
                public void call(Long aLong) {
                    UnicastContentSubject.this.disposeIfNotSubscribed();
                }
            }));
        }
    }

    @Override
    public boolean hasObservers() {
        return ((State)this.state).state == State.STATES.SUBSCRIBED.ordinal();
    }

    private static class AutoReleaseByteBufOperator<I>
    implements Observable.Operator<I, I> {
        private AutoReleaseByteBufOperator() {
        }

        @Override
        public Subscriber<? super I> call(final Subscriber<? super I> subscriber2) {
            return new Subscriber<I>(){

                @Override
                public void onCompleted() {
                    subscriber2.onCompleted();
                }

                @Override
                public void onError(Throwable e2) {
                    subscriber2.onError(e2);
                }

                @Override
                public void onNext(I t) {
                    try {
                        subscriber2.onNext(t);
                    }
                    finally {
                        ReferenceCountUtil.release(t);
                    }
                }
            };
        }
    }

    private static final class OnSubscribeAction<T>
    implements Observable.OnSubscribe<T> {
        private final State<T> state;

        public OnSubscribeAction(State<T> state) {
            this.state = state;
        }

        @Override
        public void call(Subscriber<? super T> subscriber2) {
            if (this.state.casState(State.STATES.UNSUBSCRIBED, State.STATES.SUBSCRIBED)) {
                subscriber2.add(Subscriptions.create(new Action0(){

                    @Override
                    public void call() {
                        if (null != OnSubscribeAction.this.state.onUnsubscribe) {
                            OnSubscribeAction.this.state.onUnsubscribe.call();
                        }
                    }
                }));
                ((State)this.state).bufferedObservable.unsafeSubscribe(subscriber2);
                this.state.unsubscribeReleaseSubscription();
            } else if (State.STATES.SUBSCRIBED.ordinal() == ((State)this.state).state) {
                subscriber2.onError(new IllegalStateException("Content can only have one subscription. Use Observable.publish() if you want to multicast."));
            } else if (State.STATES.DISPOSED.ordinal() == ((State)this.state).state) {
                subscriber2.onError(new IllegalStateException("Content stream is already disposed."));
            }
        }
    }

    private static final class State<T> {
        private final Action0 onUnsubscribe;
        private final Action1<T> onDispose;
        private volatile Subscription releaseSubscription;
        private volatile int state = STATES.UNSUBSCRIBED.ordinal();
        private final Observer<T> bufferedObserver;
        private final Observable<T> bufferedObservable;
        private volatile int timeoutScheduled;
        private static final AtomicIntegerFieldUpdater<State> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(State.class, "state");
        private static final AtomicIntegerFieldUpdater<State> TIMEOUT_SCHEDULED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(State.class, "timeoutScheduled");

        private State(Action0 onUnsubscribe, Action1<T> onDispose) {
            this.onUnsubscribe = onUnsubscribe;
            this.onDispose = onDispose;
            BufferUntilSubscriber bufferedSubject = BufferUntilSubscriber.create();
            this.bufferedObservable = bufferedSubject.lift(new AutoReleaseByteBufOperator());
            this.bufferedObserver = bufferedSubject;
        }

        public boolean casState(STATES expected, STATES next2) {
            return STATE_UPDATER.compareAndSet(this, expected.ordinal(), next2.ordinal());
        }

        public boolean casTimeoutScheduled() {
            return TIMEOUT_SCHEDULED_UPDATER.compareAndSet(this, 0, 1);
        }

        public void setReleaseSubscription(Subscription releaseSubscription) {
            this.releaseSubscription = releaseSubscription;
        }

        public void unsubscribeReleaseSubscription() {
            if (this.releaseSubscription != null) {
                this.releaseSubscription.unsubscribe();
            }
        }

        private static enum STATES {
            UNSUBSCRIBED,
            SUBSCRIBED,
            DISPOSED;

        }
    }
}

