/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.pipeline;

import io.netty.channel.ChannelPipeline;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurator;

public class PipelineConfiguratorComposite<I, O>
implements PipelineConfigurator<I, O> {
    private static final PipelineConfigurator[] EMPTY_CONFIGURATORS = new PipelineConfigurator[0];
    private final PipelineConfigurator[] configurators;

    public PipelineConfiguratorComposite(PipelineConfigurator ... configurators) {
        if (null == configurators) {
            configurators = EMPTY_CONFIGURATORS;
        }
        this.configurators = configurators;
    }

    @Override
    public void configureNewPipeline(ChannelPipeline pipeline) {
        for (PipelineConfigurator configurator : this.configurators) {
            if (null == configurator) continue;
            configurator.configureNewPipeline(pipeline);
        }
    }

    public List<PipelineConfigurator> getConstituentConfigurators() {
        return Collections.unmodifiableList(Arrays.asList(this.configurators));
    }
}

