/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.channel;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import mantis.io.reactivex.netty.RxNetty;
import mantis.io.reactivex.netty.channel.RxDefaultThreadFactory;
import mantis.io.reactivex.netty.channel.RxEventLoopProvider;

public class SingleNioLoopProvider
extends RxEventLoopProvider {
    private final SharedNioEventLoopGroup eventLoop;
    private final SharedNioEventLoopGroup parentEventLoop;
    private final AtomicReference<EpollEventLoopGroup> nativeEventLoop;
    private final AtomicReference<EpollEventLoopGroup> nativeParentEventLoop;
    private final int parentEventLoopCount;
    private final int childEventLoopCount;

    public SingleNioLoopProvider() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public SingleNioLoopProvider(int threadCount) {
        this.parentEventLoop = this.eventLoop = new SharedNioEventLoopGroup(threadCount);
        this.parentEventLoopCount = this.childEventLoopCount = threadCount;
        this.nativeEventLoop = new AtomicReference();
        this.nativeParentEventLoop = this.nativeEventLoop;
    }

    public SingleNioLoopProvider(int parentEventLoopCount, int childEventLoopCount) {
        this.parentEventLoopCount = parentEventLoopCount;
        this.childEventLoopCount = childEventLoopCount;
        this.parentEventLoop = new SharedNioEventLoopGroup(parentEventLoopCount);
        this.eventLoop = new SharedNioEventLoopGroup(childEventLoopCount);
        this.nativeParentEventLoop = new AtomicReference();
        this.nativeEventLoop = new AtomicReference();
    }

    @Override
    public EventLoopGroup globalClientEventLoop() {
        this.eventLoop.retain();
        return this.eventLoop;
    }

    @Override
    public EventLoopGroup globalServerEventLoop() {
        this.eventLoop.retain();
        return this.eventLoop;
    }

    @Override
    public EventLoopGroup globalServerParentEventLoop() {
        return this.parentEventLoop;
    }

    @Override
    public EventLoopGroup globalClientEventLoop(boolean nativeTransport) {
        if (nativeTransport && RxNetty.isUsingNativeTransport()) {
            return this.getNativeEventLoop();
        }
        return this.globalClientEventLoop();
    }

    @Override
    public EventLoopGroup globalServerEventLoop(boolean nativeTransport) {
        if (nativeTransport && RxNetty.isUsingNativeTransport()) {
            return this.getNativeEventLoop();
        }
        return this.globalServerEventLoop();
    }

    @Override
    public EventLoopGroup globalServerParentEventLoop(boolean nativeTransport) {
        if (nativeTransport && RxNetty.isUsingNativeTransport()) {
            return this.getNativeParentEventLoop();
        }
        return this.globalServerParentEventLoop();
    }

    private EpollEventLoopGroup getNativeParentEventLoop() {
        EpollEventLoopGroup newEventLoopGroup;
        if (this.nativeParentEventLoop == this.nativeEventLoop) {
            return this.getNativeEventLoop();
        }
        EpollEventLoopGroup eventLoopGroup = this.nativeParentEventLoop.get();
        if (null == eventLoopGroup && !this.nativeParentEventLoop.compareAndSet(null, newEventLoopGroup = new EpollEventLoopGroup(this.parentEventLoopCount, new RxDefaultThreadFactory("rxnetty-epoll-eventloop")))) {
            newEventLoopGroup.shutdownGracefully();
        }
        return this.nativeParentEventLoop.get();
    }

    private EpollEventLoopGroup getNativeEventLoop() {
        EpollEventLoopGroup newEventLoopGroup;
        EpollEventLoopGroup eventLoopGroup = this.nativeEventLoop.get();
        if (null == eventLoopGroup && !this.nativeEventLoop.compareAndSet(null, newEventLoopGroup = new EpollEventLoopGroup(this.childEventLoopCount, new RxDefaultThreadFactory("rxnetty-epoll-eventloop")))) {
            newEventLoopGroup.shutdownGracefully();
        }
        return this.nativeEventLoop.get();
    }

    public static class SharedNioEventLoopGroup
    extends NioEventLoopGroup {
        private final AtomicInteger refCount = new AtomicInteger();

        public SharedNioEventLoopGroup() {
            super(0, new RxDefaultThreadFactory("rxnetty-nio-eventloop"));
        }

        public SharedNioEventLoopGroup(int threadCount) {
            super(threadCount, new RxDefaultThreadFactory("rxnetty-nio-eventloop"));
        }

        @Override
        public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
            if (0 == this.release()) {
                return super.shutdownGracefully(quietPeriod, timeout, unit);
            }
            return this.terminationFuture();
        }

        @Override
        @Deprecated
        public void shutdown() {
            if (0 == this.release()) {
                super.shutdown();
            }
        }

        public int retain() {
            return this.refCount.incrementAndGet();
        }

        public int release() {
            return this.refCount.decrementAndGet();
        }
    }
}

