/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.concurrent;

import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedPredicate;
import io.vavr.CheckedRunnable;
import io.vavr.PartialFunction;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Value;
import io.vavr.collection.Iterator;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Stream;
import io.vavr.concurrent.FutureImpl;
import io.vavr.concurrent.GwtIncompatible;
import io.vavr.concurrent.Promise;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface Future<T>
extends Value<T> {
    public static final ExecutorService DEFAULT_EXECUTOR_SERVICE = Executors.newCachedThreadPool();

    public static <T> Future<T> failed(Throwable exception) {
        Objects.requireNonNull(exception, "exception is null");
        return Future.failed(DEFAULT_EXECUTOR_SERVICE, exception);
    }

    public static <T> Future<T> failed(ExecutorService executorService, Throwable exception) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(exception, "exception is null");
        return Promise.failed(executorService, exception).future();
    }

    public static <T> Future<Option<T>> find(Iterable<? extends Future<? extends T>> futures, Predicate<? super T> predicate) {
        return Future.find(DEFAULT_EXECUTOR_SERVICE, futures, predicate);
    }

    public static <T> Future<Option<T>> find(ExecutorService executorService, Iterable<? extends Future<? extends T>> futures, Predicate<? super T> predicate) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(futures, "futures is null");
        Objects.requireNonNull(predicate, "predicate is null");
        Promise promise2 = Promise.make(executorService);
        List<Future<Future>> list = List.ofAll(futures);
        if (list.isEmpty()) {
            promise2.success(Option.none());
        } else {
            AtomicInteger count2 = new AtomicInteger(list.length());
            list.forEach(future2 -> future2.onComplete(result -> {
                AtomicInteger atomicInteger = count2;
                synchronized (atomicInteger) {
                    if (!promise2.isCompleted()) {
                        boolean wasLast = count2.decrementAndGet() == 0;
                        result.filter(predicate).onSuccess(value -> promise2.trySuccess(Option.some(value))).onFailure(ignored -> {
                            if (wasLast) {
                                promise2.trySuccess(Option.none());
                            }
                        });
                    }
                }
            }));
        }
        return promise2.future();
    }

    public static <T> Future<T> firstCompletedOf(Iterable<? extends Future<? extends T>> futures) {
        return Future.firstCompletedOf(DEFAULT_EXECUTOR_SERVICE, futures);
    }

    public static <T> Future<T> firstCompletedOf(ExecutorService executorService, Iterable<? extends Future<? extends T>> futures) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(futures, "futures is null");
        Promise promise2 = Promise.make(executorService);
        Consumer<Try> completeFirst = promise2::tryComplete;
        futures.forEach(future2 -> future2.onComplete(completeFirst));
        return promise2.future();
    }

    public static <T, U> Future<U> fold(Iterable<? extends Future<? extends T>> futures, U zero, BiFunction<? super U, ? super T, ? extends U> f) {
        return Future.fold(DEFAULT_EXECUTOR_SERVICE, futures, zero, f);
    }

    public static <T, U> Future<U> fold(ExecutorService executorService, Iterable<? extends Future<? extends T>> futures, U zero, BiFunction<? super U, ? super T, ? extends U> f) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(futures, "futures is null");
        Objects.requireNonNull(f, "f is null");
        if (!futures.iterator().hasNext()) {
            return Future.successful(executorService, zero);
        }
        return Future.sequence(executorService, futures).map((T seq) -> seq.foldLeft(zero, f));
    }

    public static <T> Future<T> fromJavaFuture(java.util.concurrent.Future<T> future2) {
        Objects.requireNonNull(future2, "future is null");
        return Future.of(DEFAULT_EXECUTOR_SERVICE, future2::get);
    }

    public static <T> Future<T> fromJavaFuture(ExecutorService executorService, java.util.concurrent.Future<T> future2) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(future2, "future is null");
        return Future.of(executorService, future2::get);
    }

    @GwtIncompatible
    public static <T> Future<T> fromCompletableFuture(CompletableFuture<T> future2) {
        return Future.fromCompletableFuture(DEFAULT_EXECUTOR_SERVICE, future2);
    }

    @GwtIncompatible
    public static <T> Future<T> fromCompletableFuture(ExecutorService executorService, CompletableFuture<T> future2) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(future2, "future is null");
        Promise promise2 = Promise.make();
        future2.handle((t, err) -> err == null ? promise2.success(t) : promise2.failure((Throwable)err));
        return promise2.future();
    }

    public static <T> Future<T> fromTry(Try<? extends T> result) {
        return Future.fromTry(DEFAULT_EXECUTOR_SERVICE, result);
    }

    public static <T> Future<T> fromTry(ExecutorService executorService, Try<? extends T> result) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(result, "result is null");
        return Promise.fromTry(executorService, result).future();
    }

    public static <T> Future<T> narrow(Future<? extends T> future2) {
        return future2;
    }

    public static <T> Future<T> ofSupplier(Supplier<? extends T> computation) {
        Objects.requireNonNull(computation, "computation is null");
        return Future.of(DEFAULT_EXECUTOR_SERVICE, computation::get);
    }

    public static <T> Future<T> ofSupplier(ExecutorService executorService, Supplier<? extends T> computation) {
        Objects.requireNonNull(computation, "computation is null");
        return Future.of(executorService, computation::get);
    }

    public static <T> Future<T> ofCallable(Callable<? extends T> computation) {
        Objects.requireNonNull(computation, "computation is null");
        return Future.of(DEFAULT_EXECUTOR_SERVICE, computation::call);
    }

    public static <T> Future<T> ofCallable(ExecutorService executorService, Callable<? extends T> computation) {
        Objects.requireNonNull(computation, "computation is null");
        return Future.of(executorService, computation::call);
    }

    public static Future<Void> runRunnable(Runnable computation) {
        Objects.requireNonNull(computation, "computation is null");
        return Future.run(DEFAULT_EXECUTOR_SERVICE, computation::run);
    }

    public static Future<Void> runRunnable(ExecutorService executorService, Runnable computation) {
        Objects.requireNonNull(computation, "computation is null");
        return Future.run(executorService, computation::run);
    }

    public static <T> Future<T> of(CheckedFunction0<? extends T> computation) {
        return Future.of(DEFAULT_EXECUTOR_SERVICE, computation);
    }

    public static <T> Future<T> of(ExecutorService executorService, CheckedFunction0<? extends T> computation) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(computation, "computation is null");
        FutureImpl<? extends T> future2 = new FutureImpl<T>(executorService);
        future2.run(computation);
        return future2;
    }

    public static <T> Future<T> reduce(Iterable<? extends Future<? extends T>> futures, BiFunction<? super T, ? super T, ? extends T> f) {
        return Future.reduce(DEFAULT_EXECUTOR_SERVICE, futures, f);
    }

    public static <T> Future<T> reduce(ExecutorService executorService, Iterable<? extends Future<? extends T>> futures, BiFunction<? super T, ? super T, ? extends T> f) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(futures, "futures is null");
        Objects.requireNonNull(f, "f is null");
        if (!futures.iterator().hasNext()) {
            throw new NoSuchElementException("Future.reduce on empty futures");
        }
        return Future.sequence(futures).map((T seq) -> seq.reduceLeft(f));
    }

    public static Future<Void> run(CheckedRunnable unit) {
        return Future.run(DEFAULT_EXECUTOR_SERVICE, unit);
    }

    public static Future<Void> run(ExecutorService executorService, CheckedRunnable unit) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(unit, "unit is null");
        return Future.of(executorService, () -> {
            unit.run();
            return null;
        });
    }

    public static <T> Future<Seq<T>> sequence(Iterable<? extends Future<? extends T>> futures) {
        return Future.sequence(DEFAULT_EXECUTOR_SERVICE, futures);
    }

    public static <T> Future<Seq<T>> sequence(ExecutorService executorService, Iterable<? extends Future<? extends T>> futures) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(futures, "futures is null");
        Future zero = Future.successful(executorService, Stream.empty());
        BiFunction<Future, Future, Future> f = (result, future2) -> result.flatMap(seq -> future2.map(seq::append));
        return Iterator.ofAll(futures).foldLeft(zero, f);
    }

    public static <T> Future<T> successful(T result) {
        return Future.successful(DEFAULT_EXECUTOR_SERVICE, result);
    }

    public static <T> Future<T> successful(ExecutorService executorService, T result) {
        Objects.requireNonNull(executorService, "executorService is null");
        return Promise.successful(executorService, result).future();
    }

    @Override
    @GwtIncompatible
    default public CompletableFuture<T> toCompletableFuture() {
        CompletableFuture future2 = new CompletableFuture();
        this.onSuccess(future2::complete);
        this.onFailure(future2::completeExceptionally);
        return future2;
    }

    public static <T, U> Future<Seq<U>> traverse(Iterable<? extends T> values, Function<? super T, ? extends Future<? extends U>> mapper) {
        return Future.traverse(DEFAULT_EXECUTOR_SERVICE, values, mapper);
    }

    public static <T, U> Future<Seq<U>> traverse(ExecutorService executorService, Iterable<? extends T> values, Function<? super T, ? extends Future<? extends U>> mapper) {
        Objects.requireNonNull(executorService, "executorService is null");
        Objects.requireNonNull(values, "values is null");
        Objects.requireNonNull(mapper, "mapper is null");
        return Future.sequence(executorService, Iterator.ofAll(values).map(mapper));
    }

    default public Future<T> andThen(Consumer<? super Try<T>> action2) {
        Objects.requireNonNull(action2, "action is null");
        Promise promise2 = Promise.make(this.executorService());
        this.onComplete(t -> {
            Try.run(() -> action2.accept((Object)t));
            promise2.complete(t);
        });
        return promise2.future();
    }

    public Future<T> await();

    default public boolean cancel() {
        return this.cancel(true);
    }

    public boolean cancel(boolean var1);

    default public <R> Future<R> collect(PartialFunction<? super T, ? extends R> partialFunction) {
        Objects.requireNonNull(partialFunction, "partialFunction is null");
        Promise promise2 = Promise.make(this.executorService());
        this.onComplete(result -> promise2.complete(result.collect(partialFunction)));
        return promise2.future();
    }

    public ExecutorService executorService();

    default public Future<Throwable> failed() {
        Promise promise2 = Promise.make(this.executorService());
        this.onComplete(result -> {
            if (result.isFailure()) {
                promise2.success(result.getCause());
            } else {
                promise2.failure(new NoSuchElementException("Future.failed completed without a throwable"));
            }
        });
        return promise2.future();
    }

    default public Future<T> fallbackTo(Future<? extends T> that) {
        Objects.requireNonNull(that, "that is null");
        Promise promise2 = Promise.make(this.executorService());
        this.onComplete(t -> {
            if (t.isSuccess()) {
                promise2.complete(t);
            } else {
                that.onComplete(alt2 -> {
                    if (alt2.isSuccess()) {
                        promise2.complete(alt2);
                    } else {
                        promise2.complete(t);
                    }
                });
            }
        });
        return promise2.future();
    }

    default public Future<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.filterTry(predicate::test);
    }

    default public Future<T> filterTry(CheckedPredicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        Promise promise2 = Promise.make(this.executorService());
        this.onComplete(result -> promise2.complete(result.filterTry(predicate)));
        return promise2.future();
    }

    default public Option<Throwable> getCause() {
        return this.getValue().map(Try::getCause);
    }

    public Option<Try<T>> getValue();

    public boolean isCompleted();

    default public boolean isSuccess() {
        return this.getValue().map(Try::isSuccess).getOrElse(false);
    }

    default public boolean isFailure() {
        return this.getValue().map(Try::isFailure).getOrElse(false);
    }

    public Future<T> onComplete(Consumer<? super Try<T>> var1);

    default public Future<T> onFailure(Consumer<? super Throwable> action2) {
        Objects.requireNonNull(action2, "action is null");
        return this.onComplete(result -> result.onFailure(action2));
    }

    default public Future<T> onSuccess(Consumer<? super T> action2) {
        Objects.requireNonNull(action2, "action is null");
        return this.onComplete(result -> result.onSuccess(action2));
    }

    default public Future<T> recover(Function<? super Throwable, ? extends T> f) {
        Objects.requireNonNull(f, "f is null");
        return this.transformValue(t -> t.recover(f::apply));
    }

    default public Future<T> recoverWith(Function<? super Throwable, ? extends Future<? extends T>> f) {
        Objects.requireNonNull(f, "f is null");
        Promise promise2 = Promise.make(this.executorService());
        this.onComplete(t -> {
            if (t.isFailure()) {
                Try.run(() -> ((Future)f.apply(t.getCause())).onComplete(promise2::complete)).onFailure(promise2::failure);
            } else {
                promise2.complete(t);
            }
        });
        return promise2.future();
    }

    default public <U> U transform(Function<? super Future<T>, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return f.apply(this);
    }

    default public <U> Future<U> transformValue(Function<? super Try<T>, ? extends Try<? extends U>> f) {
        Objects.requireNonNull(f, "f is null");
        Promise promise2 = Promise.make(this.executorService());
        this.onComplete(t -> Try.run(() -> promise2.complete((Try)f.apply((Object)t))).onFailure(promise2::failure));
        return promise2.future();
    }

    default public <U> Future<Tuple2<T, U>> zip(Future<? extends U> that) {
        Objects.requireNonNull(that, "that is null");
        return this.zipWith(that, Tuple::of);
    }

    default public <U, R> Future<R> zipWith(Future<? extends U> that, BiFunction<? super T, ? super U, ? extends R> combinator) {
        Objects.requireNonNull(that, "that is null");
        Objects.requireNonNull(combinator, "combinator is null");
        Promise promise2 = Promise.make(this.executorService());
        this.onComplete(res1 -> {
            if (res1.isFailure()) {
                promise2.complete((Try.Failure)res1);
            } else {
                that.onComplete(res2 -> {
                    Try result = res1.flatMap((? super T t) -> res2.map((T u) -> combinator.apply(t, u)));
                    promise2.complete(result);
                });
            }
        });
        return promise2.future();
    }

    default public <U> Future<U> flatMap(Function<? super T, ? extends Future<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.flatMapTry(mapper::apply);
    }

    default public <U> Future<U> flatMapTry(CheckedFunction1<? super T, ? extends Future<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        Promise promise2 = Promise.make(this.executorService());
        this.onComplete(result -> result.mapTry(mapper).onSuccess(promise2::completeWith).onFailure(promise2::failure));
        return promise2.future();
    }

    @Override
    default public void forEach(Consumer<? super T> action2) {
        Objects.requireNonNull(action2, "action is null");
        this.onComplete(result -> result.forEach(action2));
    }

    @Override
    default public T get() {
        return this.await().getValue().get().get();
    }

    @Override
    default public boolean isAsync() {
        return true;
    }

    @Override
    default public boolean isEmpty() {
        return this.await().getValue().get().isEmpty();
    }

    @Override
    default public boolean isLazy() {
        return false;
    }

    @Override
    default public boolean isSingleValued() {
        return true;
    }

    @Override
    default public Iterator<T> iterator() {
        return this.isEmpty() ? Iterator.empty() : Iterator.of(this.get());
    }

    @Override
    default public <U> Future<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.transformValue(t -> t.map(mapper::apply));
    }

    default public <U> Future<U> mapTry(CheckedFunction1<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.transformValue(t -> t.mapTry(mapper::apply));
    }

    default public Future<T> orElse(Future<? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        Promise promise2 = Promise.make(this.executorService());
        this.onComplete(result -> {
            if (result.isSuccess()) {
                promise2.complete(result);
            } else {
                other.onComplete(promise2::complete);
            }
        });
        return promise2.future();
    }

    default public Future<T> orElse(Supplier<? extends Future<? extends T>> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        Promise promise2 = Promise.make(this.executorService());
        this.onComplete(result -> {
            if (result.isSuccess()) {
                promise2.complete(result);
            } else {
                ((Future)supplier.get()).onComplete(promise2::complete);
            }
        });
        return promise2.future();
    }

    @Override
    default public Future<T> peek(Consumer<? super T> action2) {
        Objects.requireNonNull(action2, "action is null");
        this.onSuccess(action2::accept);
        return this;
    }

    @Override
    default public String stringPrefix() {
        return "Future";
    }
}

