/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.AbstractIterator;
import io.vavr.collection.HashArrayMappedTrie;
import io.vavr.collection.Iterator;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

interface HashArrayMappedTrieModule {

    public static final class ArrayNode<K, V>
    extends AbstractNode<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Object[] subNodes;
        private final int count;
        private final int size;

        ArrayNode(int count2, int size, Object[] subNodes) {
            this.subNodes = subNodes;
            this.count = count2;
            this.size = size;
        }

        @Override
        Option<V> lookup(int shift, int keyHash, K key2) {
            int frag = ArrayNode.hashFragment(shift, keyHash);
            AbstractNode child = (AbstractNode)this.subNodes[frag];
            return child.lookup(shift + 5, keyHash, key2);
        }

        @Override
        V lookup(int shift, int keyHash, K key2, V defaultValue) {
            int frag = ArrayNode.hashFragment(shift, keyHash);
            AbstractNode child = (AbstractNode)this.subNodes[frag];
            return child.lookup(shift + 5, keyHash, key2, defaultValue);
        }

        @Override
        AbstractNode<K, V> modify(int shift, int keyHash, K key2, V value, Action action2) {
            int frag = ArrayNode.hashFragment(shift, keyHash);
            AbstractNode child = (AbstractNode)this.subNodes[frag];
            AbstractNode<K, V> newChild = child.modify(shift + 5, keyHash, key2, value, action2);
            if (child.isEmpty() && !newChild.isEmpty()) {
                return new ArrayNode<K, V>(this.count + 1, this.size + newChild.size(), ArrayNode.update(this.subNodes, frag, newChild));
            }
            if (!child.isEmpty() && newChild.isEmpty()) {
                if (this.count - 1 <= 8) {
                    return this.pack(frag, this.subNodes);
                }
                return new ArrayNode<K, V>(this.count - 1, this.size - child.size(), ArrayNode.update(this.subNodes, frag, EmptyNode.instance()));
            }
            return new ArrayNode<K, V>(this.count, this.size - child.size() + newChild.size(), ArrayNode.update(this.subNodes, frag, newChild));
        }

        private IndexedNode<K, V> pack(int idx, Object[] elements) {
            Object[] arr = new Object[this.count - 1];
            int bitmap = 0;
            int size = 0;
            int ptr = 0;
            for (int i = 0; i < 32; ++i) {
                AbstractNode elem = (AbstractNode)elements[i];
                if (i == idx || elem.isEmpty()) continue;
                size += elem.size();
                arr[ptr++] = elem;
                bitmap |= 1 << i;
            }
            return new IndexedNode(bitmap, size, arr);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.subNodes);
        }
    }

    public static final class IndexedNode<K, V>
    extends AbstractNode<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int bitmap;
        private final int size;
        private final Object[] subNodes;

        IndexedNode(int bitmap, int size, Object[] subNodes) {
            this.bitmap = bitmap;
            this.size = size;
            this.subNodes = subNodes;
        }

        @Override
        Option<V> lookup(int shift, int keyHash, K key2) {
            int frag = IndexedNode.hashFragment(shift, keyHash);
            int bit = IndexedNode.toBitmap(frag);
            if ((this.bitmap & bit) != 0) {
                AbstractNode n = (AbstractNode)this.subNodes[IndexedNode.fromBitmap(this.bitmap, bit)];
                return n.lookup(shift + 5, keyHash, key2);
            }
            return Option.none();
        }

        @Override
        V lookup(int shift, int keyHash, K key2, V defaultValue) {
            int frag = IndexedNode.hashFragment(shift, keyHash);
            int bit = IndexedNode.toBitmap(frag);
            if ((this.bitmap & bit) != 0) {
                AbstractNode n = (AbstractNode)this.subNodes[IndexedNode.fromBitmap(this.bitmap, bit)];
                return n.lookup(shift + 5, keyHash, key2, defaultValue);
            }
            return defaultValue;
        }

        @Override
        AbstractNode<K, V> modify(int shift, int keyHash, K key2, V value, Action action2) {
            int newBitmap;
            boolean added;
            int frag = IndexedNode.hashFragment(shift, keyHash);
            int bit = IndexedNode.toBitmap(frag);
            int index2 = IndexedNode.fromBitmap(this.bitmap, bit);
            int mask = this.bitmap;
            boolean exists = (mask & bit) != 0;
            AbstractNode atIndx = exists ? (AbstractNode)this.subNodes[index2] : null;
            AbstractNode<K, V> child = exists ? atIndx.modify(shift + 5, keyHash, key2, value, action2) : EmptyNode.instance().modify(shift + 5, keyHash, key2, value, action2);
            boolean removed = exists && child.isEmpty();
            boolean bl = added = !exists && !child.isEmpty();
            int n = removed ? mask & ~bit : (newBitmap = added ? mask | bit : mask);
            if (newBitmap == 0) {
                return EmptyNode.instance();
            }
            if (removed) {
                if (this.subNodes.length <= 2 && this.subNodes[index2 ^ 1] instanceof LeafNode) {
                    return (AbstractNode)this.subNodes[index2 ^ 1];
                }
                return new IndexedNode<K, V>(newBitmap, this.size - atIndx.size(), IndexedNode.remove(this.subNodes, index2));
            }
            if (added) {
                if (this.subNodes.length >= 16) {
                    return this.expand(frag, child, mask, this.subNodes);
                }
                return new IndexedNode<K, V>(newBitmap, this.size + child.size(), IndexedNode.insert(this.subNodes, index2, child));
            }
            if (!exists) {
                return this;
            }
            return new IndexedNode<K, V>(newBitmap, this.size - atIndx.size() + child.size(), IndexedNode.update(this.subNodes, index2, child));
        }

        private ArrayNode<K, V> expand(int frag, AbstractNode<K, V> child, int mask, Object[] subNodes) {
            int bit = mask;
            int count2 = 0;
            int ptr = 0;
            Object[] arr = new Object[32];
            for (int i = 0; i < 32; ++i) {
                if ((bit & 1) != 0) {
                    arr[i] = subNodes[ptr++];
                    ++count2;
                } else if (i == frag) {
                    arr[i] = child;
                    ++count2;
                } else {
                    arr[i] = EmptyNode.instance();
                }
                bit >>>= 1;
            }
            return new ArrayNode(count2, this.size + child.size(), arr);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.subNodes);
        }
    }

    public static final class LeafList<K, V>
    extends LeafNode<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int hash;
        private final K key;
        private final V value;
        private final int size;
        private final LeafNode<K, V> tail;

        LeafList(int hash2, K key2, V value, LeafNode<K, V> tail) {
            this.hash = hash2;
            this.key = key2;
            this.value = value;
            this.size = 1 + tail.size();
            this.tail = tail;
        }

        @Override
        Option<V> lookup(int shift, int keyHash, K key2) {
            if (this.hash != keyHash) {
                return Option.none();
            }
            return this.nodes().find(node2 -> Objects.equals(node2.key(), key2)).map(LeafNode::value);
        }

        @Override
        V lookup(int shift, int keyHash, K key2, V defaultValue) {
            if (this.hash != keyHash) {
                return defaultValue;
            }
            V result = defaultValue;
            Iterator<LeafNode<K, V>> iterator = this.nodes();
            while (iterator.hasNext()) {
                LeafNode node2 = (LeafNode)iterator.next();
                if (!Objects.equals(node2.key(), key2)) continue;
                result = node2.value();
                break;
            }
            return result;
        }

        @Override
        AbstractNode<K, V> modify(int shift, int keyHash, K key2, V value, Action action2) {
            if (keyHash == this.hash) {
                AbstractNode<K, V> filtered = this.removeElement(key2);
                if (action2 == Action.REMOVE) {
                    return filtered;
                }
                return new LeafList<K, V>(this.hash, key2, value, (LeafNode)filtered);
            }
            return action2 == Action.REMOVE ? this : LeafList.mergeLeaves(shift, this, new LeafSingleton<K, V>(keyHash, key2, value));
        }

        private static <K, V> AbstractNode<K, V> mergeNodes(LeafNode<K, V> leaf1, LeafNode<K, V> leaf2) {
            if (leaf2 == null) {
                return leaf1;
            }
            if (leaf1 instanceof LeafSingleton) {
                return new LeafList<K, V>(leaf1.hash(), leaf1.key(), leaf1.value(), leaf2);
            }
            if (leaf2 instanceof LeafSingleton) {
                return new LeafList<K, V>(leaf2.hash(), leaf2.key(), leaf2.value(), leaf1);
            }
            LeafNode<K, V> result = leaf1;
            LeafNode<K, V> tail = leaf2;
            while (tail instanceof LeafList) {
                LeafList list = (LeafList)tail;
                result = new LeafList<K, V>(list.hash, list.key, list.value, result);
                tail = list.tail;
            }
            return new LeafList<K, V>(tail.hash(), tail.key(), tail.value(), result);
        }

        private AbstractNode<K, V> removeElement(K k) {
            if (Objects.equals(k, this.key)) {
                return this.tail;
            }
            LeafNode leaf1 = new LeafSingleton<K, V>(this.hash, this.key, this.value);
            LeafNode<K, V> leaf2 = this.tail;
            boolean found = false;
            while (!found && leaf2 != null) {
                if (Objects.equals(k, leaf2.key())) {
                    found = true;
                } else {
                    leaf1 = new LeafList<K, V>(leaf2.hash(), leaf2.key(), leaf2.value(), leaf1);
                }
                leaf2 = leaf2 instanceof LeafList ? ((LeafList)leaf2).tail : null;
            }
            return LeafList.mergeNodes(leaf1, leaf2);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator<LeafNode<K, V>> nodes() {
            return new AbstractIterator<LeafNode<K, V>>(){
                LeafNode<K, V> node;
                {
                    this.node = this;
                }

                @Override
                public boolean hasNext() {
                    return this.node != null;
                }

                @Override
                public LeafNode<K, V> getNext() {
                    LeafNode result = this.node;
                    this.node = this.node instanceof LeafSingleton ? null : ((LeafList)this.node).tail;
                    return result;
                }
            };
        }

        @Override
        public int hashCode() {
            Iterator<LeafNode<K, V>> it = this.nodes();
            int hashCode = 0;
            while (it.hasNext()) {
                LeafNode node2 = (LeafNode)it.next();
                hashCode += Objects.hash(node2.key(), node2.value());
            }
            return hashCode;
        }

        @Override
        int hash() {
            return this.hash;
        }

        @Override
        K key() {
            return this.key;
        }

        @Override
        V value() {
            return this.value;
        }
    }

    public static final class LeafSingleton<K, V>
    extends LeafNode<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int hash;
        private final K key;
        private final V value;

        LeafSingleton(int hash2, K key2, V value) {
            this.hash = hash2;
            this.key = key2;
            this.value = value;
        }

        private boolean equals(int keyHash, K key2) {
            return keyHash == this.hash && Objects.equals(key2, this.key);
        }

        @Override
        Option<V> lookup(int shift, int keyHash, K key2) {
            return Option.when(this.equals(keyHash, key2), this.value);
        }

        @Override
        V lookup(int shift, int keyHash, K key2, V defaultValue) {
            return this.equals(keyHash, key2) ? this.value : defaultValue;
        }

        @Override
        AbstractNode<K, V> modify(int shift, int keyHash, K key2, V value, Action action2) {
            if (keyHash == this.hash && Objects.equals(key2, this.key)) {
                return action2 == Action.REMOVE ? EmptyNode.instance() : new LeafSingleton<K, V>(this.hash, key2, value);
            }
            return action2 == Action.REMOVE ? this : LeafSingleton.mergeLeaves(shift, this, new LeafSingleton<K, V>(keyHash, key2, value));
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Iterator<LeafNode<K, V>> nodes() {
            return Iterator.of(this);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.hash, this.value);
        }

        @Override
        int hash() {
            return this.hash;
        }

        @Override
        K key() {
            return this.key;
        }

        @Override
        V value() {
            return this.value;
        }
    }

    public static abstract class LeafNode<K, V>
    extends AbstractNode<K, V> {
        abstract K key();

        abstract V value();

        abstract int hash();

        static <K, V> AbstractNode<K, V> mergeLeaves(int shift, LeafNode<K, V> leaf1, LeafSingleton<K, V> leaf2) {
            Object[] objectArray;
            int h2;
            int h1 = leaf1.hash();
            if (h1 == (h2 = leaf2.hash())) {
                return new LeafList<K, V>(h1, leaf2.key(), leaf2.value(), leaf1);
            }
            int subH1 = LeafNode.hashFragment(shift, h1);
            int subH2 = LeafNode.hashFragment(shift, h2);
            int newBitmap = LeafNode.toBitmap(subH1) | LeafNode.toBitmap(subH2);
            if (subH1 == subH2) {
                AbstractNode<K, V> newLeaves = LeafNode.mergeLeaves(shift + 5, leaf1, leaf2);
                return new IndexedNode(newBitmap, newLeaves.size(), new Object[]{newLeaves});
            }
            int n = leaf1.size() + leaf2.size();
            if (subH1 < subH2) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = leaf1;
                objectArray = objectArray2;
                objectArray2[1] = leaf2;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = leaf2;
                objectArray = objectArray3;
                objectArray3[1] = leaf1;
            }
            return new IndexedNode(newBitmap, n, objectArray);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    public static final class EmptyNode<K, V>
    extends AbstractNode<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final EmptyNode<?, ?> INSTANCE = new EmptyNode();

        private EmptyNode() {
        }

        static <K, V> EmptyNode<K, V> instance() {
            return INSTANCE;
        }

        @Override
        Option<V> lookup(int shift, int keyHash, K key2) {
            return Option.none();
        }

        @Override
        V lookup(int shift, int keyHash, K key2, V defaultValue) {
            return defaultValue;
        }

        @Override
        AbstractNode<K, V> modify(int shift, int keyHash, K key2, V value, Action action2) {
            return action2 == Action.REMOVE ? this : new LeafSingleton<K, V>(keyHash, key2, value);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<LeafNode<K, V>> nodes() {
            return Iterator.empty();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    public static abstract class AbstractNode<K, V>
    implements HashArrayMappedTrie<K, V> {
        static final int SIZE = 5;
        static final int BUCKET_SIZE = 32;
        static final int MAX_INDEX_NODE = 16;
        static final int MIN_ARRAY_NODE = 8;

        static int hashFragment(int shift, int hash2) {
            return hash2 >>> shift & 0x1F;
        }

        static int toBitmap(int hash2) {
            return 1 << hash2;
        }

        static int fromBitmap(int bitmap, int bit) {
            return Integer.bitCount(bitmap & bit - 1);
        }

        static Object[] update(Object[] arr, int index2, Object newElement) {
            Object[] newArr = Arrays.copyOf(arr, arr.length);
            newArr[index2] = newElement;
            return newArr;
        }

        static Object[] remove(Object[] arr, int index2) {
            Object[] newArr = new Object[arr.length - 1];
            System.arraycopy(arr, 0, newArr, 0, index2);
            System.arraycopy(arr, index2 + 1, newArr, index2, arr.length - index2 - 1);
            return newArr;
        }

        static Object[] insert(Object[] arr, int index2, Object newElem) {
            Object[] newArr = new Object[arr.length + 1];
            System.arraycopy(arr, 0, newArr, 0, index2);
            newArr[index2] = newElem;
            System.arraycopy(arr, index2, newArr, index2 + 1, arr.length - index2);
            return newArr;
        }

        abstract Option<V> lookup(int var1, int var2, K var3);

        abstract V lookup(int var1, int var2, K var3, V var4);

        abstract AbstractNode<K, V> modify(int var1, int var2, K var3, V var4, Action var5);

        Iterator<LeafNode<K, V>> nodes() {
            return new LeafNodeIterator(this);
        }

        @Override
        public Iterator<Tuple2<K, V>> iterator() {
            return this.nodes().map(node2 -> Tuple.of(node2.key(), node2.value()));
        }

        @Override
        public Iterator<K> keysIterator() {
            return this.nodes().map(LeafNode::key);
        }

        @Override
        public Option<V> get(K key2) {
            return this.lookup(0, Objects.hashCode(key2), key2);
        }

        @Override
        public V getOrElse(K key2, V defaultValue) {
            return this.lookup(0, Objects.hashCode(key2), key2, defaultValue);
        }

        @Override
        public boolean containsKey(K key2) {
            return this.get(key2).isDefined();
        }

        @Override
        public HashArrayMappedTrie<K, V> put(K key2, V value) {
            return this.modify(0, Objects.hashCode(key2), key2, value, Action.PUT);
        }

        @Override
        public HashArrayMappedTrie<K, V> remove(K key2) {
            return this.modify(0, Objects.hashCode(key2), key2, null, Action.REMOVE);
        }

        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof HashArrayMappedTrie) {
                HashArrayMappedTrie that = (HashArrayMappedTrie)o;
                if (this.size() == that.size()) {
                    for (Tuple2 thisEntry : this) {
                        Option thatValue = that.get(thisEntry._1);
                        if (thatValue.isDefined() && thatValue.get().equals(thisEntry._2)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        public abstract int hashCode();

        public final String toString() {
            return this.iterator().map(t -> t._1 + " -> " + t._2).mkString("HashArrayMappedTrie(", ", ", ")");
        }
    }

    public static class LeafNodeIterator<K, V>
    extends AbstractIterator<LeafNode<K, V>> {
        private static final int MAX_LEVELS = 8;
        private final int total;
        private final Object[] nodes = new Object[8];
        private final int[] indexes = new int[8];
        private int level;
        private int ptr = 0;

        LeafNodeIterator(AbstractNode<K, V> root2) {
            this.total = root2.size();
            this.level = LeafNodeIterator.downstairs(this.nodes, this.indexes, root2, 0);
        }

        @Override
        public boolean hasNext() {
            return this.ptr < this.total;
        }

        @Override
        protected LeafNode<K, V> getNext() {
            Object node2 = this.nodes[this.level];
            while (!(node2 instanceof LeafNode)) {
                node2 = this.findNextLeaf();
            }
            ++this.ptr;
            if (node2 instanceof LeafList) {
                LeafList leaf = (LeafList)node2;
                this.nodes[this.level] = leaf.tail;
                return leaf;
            }
            this.nodes[this.level] = EmptyNode.instance();
            return (LeafSingleton)node2;
        }

        private Object findNextLeaf() {
            AbstractNode<K, V> node2 = null;
            while (this.level > 0) {
                int n = --this.level;
                this.indexes[n] = this.indexes[n] + 1;
                node2 = LeafNodeIterator.getChild((AbstractNode)this.nodes[this.level], this.indexes[this.level]);
                if (node2 == null) continue;
            }
            this.level = LeafNodeIterator.downstairs(this.nodes, this.indexes, node2, this.level + 1);
            return this.nodes[this.level];
        }

        private static <K, V> int downstairs(Object[] nodes, int[] indexes, AbstractNode<K, V> root2, int level) {
            while (true) {
                nodes[level] = root2;
                indexes[level] = 0;
                if ((root2 = LeafNodeIterator.getChild(root2, 0)) == null) break;
                ++level;
            }
            return level;
        }

        private static <K, V> AbstractNode<K, V> getChild(AbstractNode<K, V> node2, int index2) {
            if (node2 instanceof IndexedNode) {
                Object[] subNodes = ((IndexedNode)node2).subNodes;
                return index2 < subNodes.length ? (AbstractNode)subNodes[index2] : null;
            }
            if (node2 instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)node2;
                return index2 < 32 ? (AbstractNode)arrayNode.subNodes[index2] : null;
            }
            return null;
        }
    }

    public static enum Action {
        PUT,
        REMOVE;

    }
}

