/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.remote.observable.ingress;

import io.reactivex.mantis.remote.observable.RemoteRxEvent;
import io.reactivex.mantis.remote.observable.ingress.InetAddressWhiteListIngressPolicy;
import io.reactivex.mantis.remote.observable.ingress.IngressPolicy;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mantis.io.reactivex.netty.channel.ObservableConnection;
import rx.Observable;
import rx.subjects.ReplaySubject;

public class IngressPolicies {
    private IngressPolicies() {
    }

    public static IngressPolicy whiteListPolicy(Observable<Set<String>> whiteList) {
        return new InetAddressWhiteListIngressPolicy(whiteList);
    }

    public static IngressPolicy allowOnlyLocalhost() {
        ReplaySubject<Set<String>> subject = ReplaySubject.create();
        HashSet<String> list = new HashSet<String>();
        list.add("127.0.0.1");
        subject.onNext(list);
        return new InetAddressWhiteListIngressPolicy(subject);
    }

    public static IngressPolicy allowAll() {
        return new IngressPolicy(){

            @Override
            public boolean allowed(ObservableConnection<RemoteRxEvent, List<RemoteRxEvent>> connection) {
                return true;
            }
        };
    }
}

