/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.network.push;

import io.reactivex.mantis.network.push.ChunkProcessor;
import io.reactivex.mantis.network.push.ConnectionManager;
import io.reactivex.mantis.network.push.MonitoredQueue;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class SingleThreadedChunker<T>
implements Callable<Void> {
    final MonitoredQueue<T> inputQueue;
    final int TIME_PROBE_COUNT = 100000;
    private final int chunkSize;
    private final long maxChunkInterval;
    private final ConnectionManager<T> connectionManager;
    private final ChunkProcessor<T> processor;
    private final Object[] chunk;
    int iteration = 0;
    private int index = 0;

    public SingleThreadedChunker(ChunkProcessor<T> processor, MonitoredQueue<T> iQ, int chunkSize, long maxChunkInterval, ConnectionManager<T> connMgr) {
        this.inputQueue = iQ;
        this.chunkSize = chunkSize;
        this.maxChunkInterval = maxChunkInterval;
        this.processor = processor;
        this.connectionManager = connMgr;
        this.chunk = new Object[this.chunkSize];
    }

    private boolean stopCondition() {
        return Thread.currentThread().isInterrupted();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Void call() throws Exception {
        long chunkStartTime = System.currentTimeMillis();
        while (true) {
            ++this.iteration;
            if (this.iteration == 100000) {
                long currTime = System.currentTimeMillis();
                if (currTime - this.maxChunkInterval > chunkStartTime) {
                    this.drain();
                }
                this.iteration = 0;
                if (this.stopCondition()) return null;
            }
            if (this.index < this.chunkSize) {
                T ele = this.inputQueue.poll();
                if (ele == null) continue;
                this.chunk[this.index++] = ele;
                continue;
            }
            this.drain();
            chunkStartTime = System.currentTimeMillis();
            if (this.stopCondition()) return null;
        }
    }

    private void drain() {
        if (this.index > 0) {
            ArrayList<Object> copy2 = new ArrayList<Object>(this.index);
            for (int i = 0; i < this.index; ++i) {
                copy2.add(this.chunk[i]);
            }
            this.processor.process(this.connectionManager, copy2);
            this.index = 0;
        }
    }
}

