/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.network.push;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.spectator.GaugeCallback;
import io.mantisrx.common.metrics.spectator.MetricGroupId;
import io.reactivex.mantis.network.push.AsyncConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Func0;

public class ConnectionGroup<T> {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionGroup.class);
    private String groupId;
    private Map<String, AsyncConnection<T>> connections;
    private Metrics metrics;
    private MetricGroupId metricsGroup;
    private Counter successfulWrites;
    private Counter numSlotSwaps;
    private Counter failedWrites;

    public ConnectionGroup(String groupId) {
        this.groupId = groupId;
        this.connections = new HashMap<String, AsyncConnection<T>>();
        String grpId = Optional.ofNullable(groupId).orElse("none");
        BasicTag groupIdTag = new BasicTag("groupId", grpId);
        this.metricsGroup = new MetricGroupId("ConnectionGroup", new Tag[]{groupIdTag});
        GaugeCallback activeConnections = new GaugeCallback(this.metricsGroup, "activeConnections", new Func0<Double>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Double call() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    return ConnectionGroup.this.connections.size();
                }
            }
        });
        this.metrics = new Metrics.Builder().id(this.metricsGroup).addCounter("numSlotSwaps").addCounter("numSuccessfulWrites").addCounter("numFailedWrites").addGauge(activeConnections).build();
        this.successfulWrites = this.metrics.getCounter("numSuccessfulWrites");
        this.failedWrites = this.metrics.getCounter("numFailedWrites");
        this.numSlotSwaps = this.metrics.getCounter("numSlotSwaps");
    }

    public synchronized void incrementSuccessfulWrites(int count2) {
        this.successfulWrites.increment(count2);
    }

    public synchronized void incrementFailedWrites(int count2) {
        this.failedWrites.increment(count2);
    }

    public synchronized void removeConnection(AsyncConnection<T> connection) {
        AsyncConnection<T> existingConn = this.connections.get(connection.getSlotId());
        logger.info("Attempt to remove connection: " + connection + " existing connection entry " + existingConn);
        if (existingConn != null && existingConn.getId() == connection.getId()) {
            this.connections.remove(connection.getSlotId());
        } else {
            logger.warn("Attempt to remove connection ignored. Either there is no such connection or a a new connection has already been swapped in the place of the old connection");
        }
    }

    public synchronized void addConnection(AsyncConnection<T> connection) {
        String slotId = connection.getSlotId();
        AsyncConnection<T> previousConnection = this.connections.get(slotId);
        this.connections.put(slotId, connection);
        if (previousConnection != null) {
            logger.info("Swapping connection: " + previousConnection + " with new connection: " + connection);
            previousConnection.close();
            this.numSlotSwaps.increment();
        }
    }

    public synchronized boolean isEmpty() {
        return this.connections.isEmpty();
    }

    public synchronized Set<AsyncConnection<T>> getConnections() {
        HashSet<AsyncConnection<T>> copy2 = new HashSet<AsyncConnection<T>>();
        copy2.addAll(this.connections.values());
        return copy2;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public MetricGroupId getMetricsGroup() {
        return this.metricsGroup;
    }

    public String toString() {
        return "ConnectionGroup [groupId=" + this.groupId + ", connections=" + this.connections + "]";
    }
}

