/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.util;

import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffer;
import io.mantisrx.shaded.org.jboss.netty.channel.MessageEvent;
import io.mantisrx.shaded.org.jboss.netty.util.EstimatableObjectWrapper;
import io.mantisrx.shaded.org.jboss.netty.util.ObjectSizeEstimator;
import io.mantisrx.shaded.org.jboss.netty.util.internal.ConcurrentIdentityWeakKeyHashMap;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjectSizeEstimator
implements ObjectSizeEstimator {
    private final ConcurrentMap<Class<?>, Integer> class2size = new ConcurrentIdentityWeakKeyHashMap();

    public DefaultObjectSizeEstimator() {
        this.class2size.put(Boolean.TYPE, 4);
        this.class2size.put(Byte.TYPE, 1);
        this.class2size.put(Character.TYPE, 2);
        this.class2size.put(Integer.TYPE, 4);
        this.class2size.put(Short.TYPE, 2);
        this.class2size.put(Long.TYPE, 8);
        this.class2size.put(Float.TYPE, 4);
        this.class2size.put(Double.TYPE, 8);
        this.class2size.put(Void.TYPE, 0);
    }

    @Override
    public int estimateSize(Object o) {
        if (o == null) {
            return 8;
        }
        int answer = 8 + this.estimateSize(o.getClass(), null);
        if (o instanceof EstimatableObjectWrapper) {
            answer += this.estimateSize(((EstimatableObjectWrapper)o).unwrap());
        } else if (o instanceof MessageEvent) {
            answer += this.estimateSize(((MessageEvent)o).getMessage());
        } else if (o instanceof ChannelBuffer) {
            answer += ((ChannelBuffer)o).capacity();
        } else if (o instanceof byte[]) {
            answer += ((byte[])o).length;
        } else if (o instanceof ByteBuffer) {
            answer += ((ByteBuffer)o).remaining();
        } else if (o instanceof CharSequence) {
            answer += ((CharSequence)o).length() << 1;
        } else if (o instanceof Iterable) {
            for (Object m : (Iterable)o) {
                answer += this.estimateSize(m);
            }
        }
        return DefaultObjectSizeEstimator.align(answer);
    }

    private int estimateSize(Class<?> clazz, Set<Class<?>> visitedClasses) {
        Integer objectSize = (Integer)this.class2size.get(clazz);
        if (objectSize != null) {
            return objectSize;
        }
        if (visitedClasses != null) {
            if (visitedClasses.contains(clazz)) {
                return 0;
            }
        } else {
            visitedClasses = new HashSet();
        }
        visitedClasses.add(clazz);
        int answer = 8;
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            Field[] fields;
            for (Field f : fields = c.getDeclaredFields()) {
                if ((f.getModifiers() & 8) != 0) continue;
                answer += this.estimateSize(f.getType(), visitedClasses);
            }
        }
        visitedClasses.remove(clazz);
        answer = DefaultObjectSizeEstimator.align(answer);
        this.class2size.putIfAbsent(clazz, answer);
        return answer;
    }

    private static int align(int size) {
        int r = size % 8;
        if (r != 0) {
            size += 8 - r;
        }
        return size;
    }
}

