/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy;

import io.mantisrx.shaded.org.jboss.netty.channel.Channel;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelDownstreamHandler;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFuture;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFutureListener;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelStateEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.Channels;
import io.mantisrx.shaded.org.jboss.netty.channel.ExceptionEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.MessageEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.DefaultSpdyGoAwayFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.DefaultSpdyWindowUpdateFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdyCodecUtil;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdyDataFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdyGoAwayFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdyPingFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdyProtocolException;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdySession;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdySessionStatus;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdySettingsFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdyStreamStatus;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdyWindowUpdateFrame;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicInteger;

public class SpdySessionHandler
extends SimpleChannelUpstreamHandler
implements ChannelDownstreamHandler {
    private static final SpdyProtocolException PROTOCOL_EXCEPTION = new SpdyProtocolException();
    private final SpdySession spdySession = new SpdySession();
    private volatile int lastGoodStreamId;
    private static final int DEFAULT_MAX_CONCURRENT_STREAMS = Integer.MAX_VALUE;
    private volatile int remoteConcurrentStreams = Integer.MAX_VALUE;
    private volatile int localConcurrentStreams = Integer.MAX_VALUE;
    private volatile int maxConcurrentStreams = Integer.MAX_VALUE;
    private static final int DEFAULT_WINDOW_SIZE = 65536;
    private volatile int initialSendWindowSize = 65536;
    private volatile int initialReceiveWindowSize = 65536;
    private final Object flowControlLock = new Object();
    private final AtomicInteger pings = new AtomicInteger();
    private volatile boolean sentGoAwayFrame;
    private volatile boolean receivedGoAwayFrame;
    private volatile ChannelFutureListener closeSessionFutureListener;
    private final boolean server;
    private final boolean flowControl;

    public SpdySessionHandler(int version, boolean server2) {
        if (version < 2 || version > 3) {
            throw new IllegalArgumentException("unsupported version: " + version);
        }
        this.server = server2;
        this.flowControl = version >= 3;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e2) throws Exception {
        Object msg = e2.getMessage();
        if (msg instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
            int streamId = spdyDataFrame.getStreamId();
            if (!this.spdySession.isActiveStream(streamId)) {
                if (streamId <= this.lastGoodStreamId) {
                    this.issueStreamError(ctx, e2.getRemoteAddress(), streamId, SpdyStreamStatus.PROTOCOL_ERROR);
                } else if (!this.sentGoAwayFrame) {
                    this.issueStreamError(ctx, e2.getRemoteAddress(), streamId, SpdyStreamStatus.INVALID_STREAM);
                }
                return;
            }
            if (this.spdySession.isRemoteSideClosed(streamId)) {
                this.issueStreamError(ctx, e2.getRemoteAddress(), streamId, SpdyStreamStatus.STREAM_ALREADY_CLOSED);
                return;
            }
            if (!this.isRemoteInitiatedID(streamId) && !this.spdySession.hasReceivedReply(streamId)) {
                this.issueStreamError(ctx, e2.getRemoteAddress(), streamId, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            if (this.flowControl) {
                int deltaWindowSize = -1 * spdyDataFrame.getData().readableBytes();
                int newWindowSize = this.spdySession.updateReceiveWindowSize(streamId, deltaWindowSize);
                if (newWindowSize < this.spdySession.getReceiveWindowSizeLowerBound(streamId)) {
                    this.issueStreamError(ctx, e2.getRemoteAddress(), streamId, SpdyStreamStatus.FLOW_CONTROL_ERROR);
                    return;
                }
                if (newWindowSize < 0) {
                    while (spdyDataFrame.getData().readableBytes() > this.initialReceiveWindowSize) {
                        DefaultSpdyDataFrame partialDataFrame = new DefaultSpdyDataFrame(streamId);
                        partialDataFrame.setData(spdyDataFrame.getData().readSlice(this.initialReceiveWindowSize));
                        Channels.fireMessageReceived(ctx, (Object)partialDataFrame, e2.getRemoteAddress());
                    }
                }
                if (newWindowSize <= this.initialReceiveWindowSize / 2 && !spdyDataFrame.isLast()) {
                    deltaWindowSize = this.initialReceiveWindowSize - newWindowSize;
                    this.spdySession.updateReceiveWindowSize(streamId, deltaWindowSize);
                    DefaultSpdyWindowUpdateFrame spdyWindowUpdateFrame = new DefaultSpdyWindowUpdateFrame(streamId, deltaWindowSize);
                    Channels.write(ctx, Channels.future(e2.getChannel()), spdyWindowUpdateFrame, e2.getRemoteAddress());
                }
            }
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(streamId, true, e2.getFuture());
            }
        } else if (msg instanceof SpdySynStreamFrame) {
            boolean localSideClosed;
            boolean remoteSideClosed;
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)msg;
            int streamId = spdySynStreamFrame.getStreamId();
            if (spdySynStreamFrame.isInvalid() || !this.isRemoteInitiatedID(streamId) || this.spdySession.isActiveStream(streamId)) {
                this.issueStreamError(ctx, e2.getRemoteAddress(), streamId, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            if (streamId <= this.lastGoodStreamId) {
                this.issueSessionError(ctx, e2.getChannel(), e2.getRemoteAddress(), SpdySessionStatus.PROTOCOL_ERROR);
                return;
            }
            byte priority = spdySynStreamFrame.getPriority();
            if (!this.acceptStream(streamId, priority, remoteSideClosed = spdySynStreamFrame.isLast(), localSideClosed = spdySynStreamFrame.isUnidirectional())) {
                this.issueStreamError(ctx, e2.getRemoteAddress(), streamId, SpdyStreamStatus.REFUSED_STREAM);
                return;
            }
        } else if (msg instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)msg;
            int streamId = spdySynReplyFrame.getStreamId();
            if (spdySynReplyFrame.isInvalid() || this.isRemoteInitiatedID(streamId) || this.spdySession.isRemoteSideClosed(streamId)) {
                this.issueStreamError(ctx, e2.getRemoteAddress(), streamId, SpdyStreamStatus.INVALID_STREAM);
                return;
            }
            if (this.spdySession.hasReceivedReply(streamId)) {
                this.issueStreamError(ctx, e2.getRemoteAddress(), streamId, SpdyStreamStatus.STREAM_IN_USE);
                return;
            }
            this.spdySession.receivedReply(streamId);
            if (spdySynReplyFrame.isLast()) {
                this.halfCloseStream(streamId, true, e2.getFuture());
            }
        } else if (msg instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)msg;
            this.removeStream(spdyRstStreamFrame.getStreamId(), e2.getFuture());
        } else if (msg instanceof SpdySettingsFrame) {
            int newInitialWindowSize;
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)msg;
            int newConcurrentStreams = spdySettingsFrame.getValue(4);
            if (newConcurrentStreams >= 0) {
                this.updateConcurrentStreams(newConcurrentStreams, true);
            }
            if (spdySettingsFrame.isPersisted(7)) {
                spdySettingsFrame.removeValue(7);
            }
            spdySettingsFrame.setPersistValue(7, false);
            if (this.flowControl && (newInitialWindowSize = spdySettingsFrame.getValue(7)) >= 0) {
                this.updateInitialSendWindowSize(newInitialWindowSize);
            }
        } else if (msg instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)msg;
            if (this.isRemoteInitiatedID(spdyPingFrame.getId())) {
                Channels.write(ctx, Channels.future(e2.getChannel()), spdyPingFrame, e2.getRemoteAddress());
                return;
            }
            if (this.pings.get() == 0) {
                return;
            }
            this.pings.getAndDecrement();
        } else if (msg instanceof SpdyGoAwayFrame) {
            this.receivedGoAwayFrame = true;
        } else if (msg instanceof SpdyHeadersFrame) {
            SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)msg;
            int streamId = spdyHeadersFrame.getStreamId();
            if (spdyHeadersFrame.isInvalid()) {
                this.issueStreamError(ctx, e2.getRemoteAddress(), streamId, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            if (this.spdySession.isRemoteSideClosed(streamId)) {
                this.issueStreamError(ctx, e2.getRemoteAddress(), streamId, SpdyStreamStatus.INVALID_STREAM);
                return;
            }
            if (spdyHeadersFrame.isLast()) {
                this.halfCloseStream(streamId, true, e2.getFuture());
            }
        } else if (msg instanceof SpdyWindowUpdateFrame) {
            if (this.flowControl) {
                SpdyWindowUpdateFrame spdyWindowUpdateFrame = (SpdyWindowUpdateFrame)msg;
                int streamId = spdyWindowUpdateFrame.getStreamId();
                int deltaWindowSize = spdyWindowUpdateFrame.getDeltaWindowSize();
                if (this.spdySession.isLocalSideClosed(streamId)) {
                    return;
                }
                if (this.spdySession.getSendWindowSize(streamId) > Integer.MAX_VALUE - deltaWindowSize) {
                    this.issueStreamError(ctx, e2.getRemoteAddress(), streamId, SpdyStreamStatus.FLOW_CONTROL_ERROR);
                    return;
                }
                this.updateSendWindowSize(ctx, streamId, deltaWindowSize);
            }
            return;
        }
        super.messageReceived(ctx, e2);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e2) throws Exception {
        Throwable cause = e2.getCause();
        if (cause instanceof SpdyProtocolException) {
            this.issueSessionError(ctx, e2.getChannel(), null, SpdySessionStatus.PROTOCOL_ERROR);
        }
        super.exceptionCaught(ctx, e2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        ChannelEvent e2;
        if (evt instanceof ChannelStateEvent) {
            e2 = (ChannelStateEvent)evt;
            switch (e2.getState()) {
                case OPEN: 
                case CONNECTED: 
                case BOUND: {
                    if (!Boolean.FALSE.equals(e2.getValue()) && e2.getValue() != null) break;
                    this.sendGoAwayFrame(ctx, (ChannelStateEvent)e2);
                    return;
                }
            }
        }
        if (!(evt instanceof MessageEvent)) {
            ctx.sendDownstream(evt);
            return;
        }
        e2 = (MessageEvent)evt;
        Object msg = e2.getMessage();
        if (msg instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
            final int streamId = spdyDataFrame.getStreamId();
            if (this.spdySession.isLocalSideClosed(streamId)) {
                e2.getFuture().setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            if (this.flowControl) {
                Object object = this.flowControlLock;
                synchronized (object) {
                    int dataLength = spdyDataFrame.getData().readableBytes();
                    int sendWindowSize = this.spdySession.getSendWindowSize(streamId);
                    if (sendWindowSize <= 0) {
                        this.spdySession.putPendingWrite(streamId, (MessageEvent)e2);
                        return;
                    }
                    if (sendWindowSize < dataLength) {
                        this.spdySession.updateSendWindowSize(streamId, -1 * sendWindowSize);
                        DefaultSpdyDataFrame partialDataFrame = new DefaultSpdyDataFrame(streamId);
                        partialDataFrame.setData(spdyDataFrame.getData().readSlice(sendWindowSize));
                        this.spdySession.putPendingWrite(streamId, (MessageEvent)e2);
                        ChannelFuture writeFuture = Channels.future(e2.getChannel());
                        final SocketAddress remoteAddress = e2.getRemoteAddress();
                        final ChannelHandlerContext context = ctx;
                        e2.getFuture().addListener(new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future2) throws Exception {
                                if (!future2.isSuccess()) {
                                    SpdySessionHandler.this.issueStreamError(context, remoteAddress, streamId, SpdyStreamStatus.INTERNAL_ERROR);
                                }
                            }
                        });
                        Channels.write(ctx, writeFuture, partialDataFrame, remoteAddress);
                        return;
                    }
                    this.spdySession.updateSendWindowSize(streamId, -1 * dataLength);
                    final SocketAddress remoteAddress = e2.getRemoteAddress();
                    final ChannelHandlerContext context = ctx;
                    e2.getFuture().addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future2) throws Exception {
                            if (!future2.isSuccess()) {
                                SpdySessionHandler.this.issueStreamError(context, remoteAddress, streamId, SpdyStreamStatus.INTERNAL_ERROR);
                            }
                        }
                    });
                }
            }
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(streamId, false, e2.getFuture());
            }
        } else if (msg instanceof SpdySynStreamFrame) {
            boolean localSideClosed;
            boolean remoteSideClosed;
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)msg;
            int streamId = spdySynStreamFrame.getStreamId();
            if (this.isRemoteInitiatedID(streamId)) {
                e2.getFuture().setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            byte priority = spdySynStreamFrame.getPriority();
            if (!this.acceptStream(streamId, priority, remoteSideClosed = spdySynStreamFrame.isUnidirectional(), localSideClosed = spdySynStreamFrame.isLast())) {
                e2.getFuture().setFailure(PROTOCOL_EXCEPTION);
                return;
            }
        } else if (msg instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)msg;
            int streamId = spdySynReplyFrame.getStreamId();
            if (!this.isRemoteInitiatedID(streamId) || this.spdySession.isLocalSideClosed(streamId)) {
                e2.getFuture().setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            if (spdySynReplyFrame.isLast()) {
                this.halfCloseStream(streamId, false, e2.getFuture());
            }
        } else if (msg instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)msg;
            this.removeStream(spdyRstStreamFrame.getStreamId(), e2.getFuture());
        } else if (msg instanceof SpdySettingsFrame) {
            int newInitialWindowSize;
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)msg;
            int newConcurrentStreams = spdySettingsFrame.getValue(4);
            if (newConcurrentStreams >= 0) {
                this.updateConcurrentStreams(newConcurrentStreams, false);
            }
            if (spdySettingsFrame.isPersisted(7)) {
                spdySettingsFrame.removeValue(7);
            }
            spdySettingsFrame.setPersistValue(7, false);
            if (this.flowControl && (newInitialWindowSize = spdySettingsFrame.getValue(7)) >= 0) {
                this.updateInitialReceiveWindowSize(newInitialWindowSize);
            }
        } else if (msg instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)msg;
            if (this.isRemoteInitiatedID(spdyPingFrame.getId())) {
                e2.getFuture().setFailure(new IllegalArgumentException("invalid PING ID: " + spdyPingFrame.getId()));
                return;
            }
            this.pings.getAndIncrement();
        } else {
            if (msg instanceof SpdyGoAwayFrame) {
                e2.getFuture().setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            if (msg instanceof SpdyHeadersFrame) {
                SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)msg;
                int streamId = spdyHeadersFrame.getStreamId();
                if (this.spdySession.isLocalSideClosed(streamId)) {
                    e2.getFuture().setFailure(PROTOCOL_EXCEPTION);
                    return;
                }
                if (spdyHeadersFrame.isLast()) {
                    this.halfCloseStream(streamId, false, e2.getFuture());
                }
            } else if (msg instanceof SpdyWindowUpdateFrame) {
                e2.getFuture().setFailure(PROTOCOL_EXCEPTION);
                return;
            }
        }
        ctx.sendDownstream(evt);
    }

    private void issueSessionError(ChannelHandlerContext ctx, Channel channel, SocketAddress remoteAddress, SpdySessionStatus status) {
        ChannelFuture future2 = this.sendGoAwayFrame(ctx, channel, remoteAddress, status);
        future2.addListener(ChannelFutureListener.CLOSE);
    }

    private void issueStreamError(ChannelHandlerContext ctx, SocketAddress remoteAddress, int streamId, SpdyStreamStatus status) {
        boolean fireMessageReceived = !this.spdySession.isRemoteSideClosed(streamId);
        ChannelFuture future2 = Channels.future(ctx.getChannel());
        this.removeStream(streamId, future2);
        DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamId, status);
        Channels.write(ctx, future2, spdyRstStreamFrame, remoteAddress);
        if (fireMessageReceived) {
            Channels.fireMessageReceived(ctx, (Object)spdyRstStreamFrame, remoteAddress);
        }
    }

    private boolean isRemoteInitiatedID(int id) {
        boolean serverID = SpdyCodecUtil.isServerId(id);
        return this.server && !serverID || !this.server && serverID;
    }

    private void updateConcurrentStreams(int newConcurrentStreams, boolean remote) {
        if (remote) {
            this.remoteConcurrentStreams = newConcurrentStreams;
        } else {
            this.localConcurrentStreams = newConcurrentStreams;
        }
        this.maxConcurrentStreams = Math.min(this.localConcurrentStreams, this.remoteConcurrentStreams);
    }

    private synchronized void updateInitialSendWindowSize(int newInitialWindowSize) {
        int deltaWindowSize = newInitialWindowSize - this.initialSendWindowSize;
        this.initialSendWindowSize = newInitialWindowSize;
        for (Integer StreamId : this.spdySession.getActiveStreams()) {
            this.spdySession.updateSendWindowSize(StreamId, deltaWindowSize);
        }
    }

    private synchronized void updateInitialReceiveWindowSize(int newInitialWindowSize) {
        int deltaWindowSize = newInitialWindowSize - this.initialReceiveWindowSize;
        this.initialReceiveWindowSize = newInitialWindowSize;
        this.spdySession.updateAllReceiveWindowSizes(deltaWindowSize);
    }

    private synchronized boolean acceptStream(int streamId, byte priority, boolean remoteSideClosed, boolean localSideClosed) {
        if (this.receivedGoAwayFrame || this.sentGoAwayFrame) {
            return false;
        }
        int maxConcurrentStreams = this.maxConcurrentStreams;
        if (this.spdySession.numActiveStreams() >= maxConcurrentStreams) {
            return false;
        }
        this.spdySession.acceptStream(streamId, priority, remoteSideClosed, localSideClosed, this.initialSendWindowSize, this.initialReceiveWindowSize);
        if (this.isRemoteInitiatedID(streamId)) {
            this.lastGoodStreamId = streamId;
        }
        return true;
    }

    private void halfCloseStream(int streamId, boolean remote, ChannelFuture future2) {
        if (remote) {
            this.spdySession.closeRemoteSide(streamId);
        } else {
            this.spdySession.closeLocalSide(streamId);
        }
        if (this.closeSessionFutureListener != null && this.spdySession.noActiveStreams()) {
            future2.addListener(this.closeSessionFutureListener);
        }
    }

    private void removeStream(int streamId, ChannelFuture future2) {
        this.spdySession.removeStream(streamId);
        if (this.closeSessionFutureListener != null && this.spdySession.noActiveStreams()) {
            future2.addListener(this.closeSessionFutureListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSendWindowSize(ChannelHandlerContext ctx, final int streamId, int deltaWindowSize) {
        Object object = this.flowControlLock;
        synchronized (object) {
            MessageEvent e2;
            int newWindowSize = this.spdySession.updateSendWindowSize(streamId, deltaWindowSize);
            while (newWindowSize > 0 && (e2 = this.spdySession.getPendingWrite(streamId)) != null) {
                SpdyDataFrame spdyDataFrame = (SpdyDataFrame)e2.getMessage();
                int dataFrameSize = spdyDataFrame.getData().readableBytes();
                if (newWindowSize >= dataFrameSize) {
                    this.spdySession.removePendingWrite(streamId);
                    newWindowSize = this.spdySession.updateSendWindowSize(streamId, -1 * dataFrameSize);
                    final SocketAddress remoteAddress = e2.getRemoteAddress();
                    final ChannelHandlerContext context = ctx;
                    e2.getFuture().addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future2) throws Exception {
                            if (!future2.isSuccess()) {
                                SpdySessionHandler.this.issueStreamError(context, remoteAddress, streamId, SpdyStreamStatus.INTERNAL_ERROR);
                            }
                        }
                    });
                    if (spdyDataFrame.isLast()) {
                        this.halfCloseStream(streamId, false, e2.getFuture());
                    }
                    Channels.write(ctx, e2.getFuture(), spdyDataFrame, e2.getRemoteAddress());
                    continue;
                }
                this.spdySession.updateSendWindowSize(streamId, -1 * newWindowSize);
                DefaultSpdyDataFrame partialDataFrame = new DefaultSpdyDataFrame(streamId);
                partialDataFrame.setData(spdyDataFrame.getData().readSlice(newWindowSize));
                ChannelFuture writeFuture = Channels.future(e2.getChannel());
                final SocketAddress remoteAddress = e2.getRemoteAddress();
                final ChannelHandlerContext context = ctx;
                e2.getFuture().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future2) throws Exception {
                        if (!future2.isSuccess()) {
                            SpdySessionHandler.this.issueStreamError(context, remoteAddress, streamId, SpdyStreamStatus.INTERNAL_ERROR);
                        }
                    }
                });
                Channels.write(ctx, writeFuture, partialDataFrame, remoteAddress);
                newWindowSize = 0;
            }
        }
    }

    private void sendGoAwayFrame(ChannelHandlerContext ctx, ChannelStateEvent e2) {
        if (!e2.getChannel().isConnected()) {
            ctx.sendDownstream(e2);
            return;
        }
        ChannelFuture future2 = this.sendGoAwayFrame(ctx, e2.getChannel(), null, SpdySessionStatus.OK);
        if (this.spdySession.noActiveStreams()) {
            future2.addListener(new ClosingChannelFutureListener(ctx, e2));
        } else {
            this.closeSessionFutureListener = new ClosingChannelFutureListener(ctx, e2);
        }
    }

    private synchronized ChannelFuture sendGoAwayFrame(ChannelHandlerContext ctx, Channel channel, SocketAddress remoteAddress, SpdySessionStatus status) {
        if (!this.sentGoAwayFrame) {
            this.sentGoAwayFrame = true;
            DefaultSpdyGoAwayFrame spdyGoAwayFrame = new DefaultSpdyGoAwayFrame(this.lastGoodStreamId, status);
            ChannelFuture future2 = Channels.future(channel);
            Channels.write(ctx, future2, spdyGoAwayFrame, remoteAddress);
            return future2;
        }
        return Channels.succeededFuture(channel);
    }

    private static final class ClosingChannelFutureListener
    implements ChannelFutureListener {
        private final ChannelHandlerContext ctx;
        private final ChannelStateEvent e;

        ClosingChannelFutureListener(ChannelHandlerContext ctx, ChannelStateEvent e2) {
            this.ctx = ctx;
            this.e = e2;
        }

        public void operationComplete(ChannelFuture sentGoAwayFuture) throws Exception {
            if (!(sentGoAwayFuture.getCause() instanceof ClosedChannelException)) {
                Channels.close(this.ctx, this.e.getFuture());
            } else {
                this.e.getFuture().setSuccess();
            }
        }
    }
}

