/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server.quorum;

import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.flexible.QuorumHierarchical;
import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@InterfaceAudience.Public
public class QuorumPeerConfig {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumPeerConfig.class);
    protected InetSocketAddress clientPortAddress;
    protected String dataDir;
    protected String dataLogDir;
    protected int tickTime = 3000;
    protected int maxClientCnxns = 60;
    protected int minSessionTimeout = -1;
    protected int maxSessionTimeout = -1;
    protected int initLimit;
    protected int syncLimit;
    protected int electionAlg = 3;
    protected int electionPort = 2182;
    protected boolean quorumListenOnAllIPs = false;
    protected final HashMap<Long, QuorumPeer.QuorumServer> servers = new HashMap();
    protected final HashMap<Long, QuorumPeer.QuorumServer> observers = new HashMap();
    protected long serverId;
    protected HashMap<Long, Long> serverWeight = new HashMap();
    protected HashMap<Long, Long> serverGroup = new HashMap();
    protected int numGroups = 0;
    protected QuorumVerifier quorumVerifier;
    protected int snapRetainCount = 3;
    protected int purgeInterval = 0;
    protected boolean syncEnabled = true;
    protected QuorumPeer.LearnerType peerType = QuorumPeer.LearnerType.PARTICIPANT;
    protected boolean quorumServerRequireSasl = false;
    protected boolean quorumLearnerRequireSasl = false;
    protected boolean quorumEnableSasl = false;
    protected String quorumServicePrincipal = "zkquorum/localhost";
    protected String quorumLearnerLoginContext = "QuorumLearner";
    protected String quorumServerLoginContext = "QuorumServer";
    protected int quorumCnxnThreadsSize;
    private final int MIN_SNAP_RETAIN_COUNT = 3;

    private static String[] splitWithLeadingHostname(String s) throws ConfigException {
        if (s.startsWith("[")) {
            int i = s.indexOf("]:");
            if (i < 0) {
                throw new ConfigException(s + " starts with '[' but has no matching ']:'");
            }
            String[] sa = s.substring(i + 2).split(":");
            String[] nsa = new String[sa.length + 1];
            nsa[0] = s.substring(1, i);
            System.arraycopy(sa, 0, nsa, 1, sa.length);
            return nsa;
        }
        return s.split(":");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String path2) throws ConfigException {
        File configFile = new File(path2);
        LOG.info("Reading configuration from: " + configFile);
        try {
            if (!configFile.exists()) {
                throw new IllegalArgumentException(configFile.toString() + " file is missing");
            }
            Properties cfg2 = new Properties();
            FileInputStream in = new FileInputStream(configFile);
            try {
                cfg2.load(in);
            }
            finally {
                in.close();
            }
            this.parseProperties(cfg2);
        }
        catch (IOException e2) {
            throw new ConfigException("Error processing " + path2, e2);
        }
        catch (IllegalArgumentException e3) {
            throw new ConfigException("Error processing " + path2, e3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseProperties(Properties zkProp) throws IOException, ConfigException {
        int clientPort = 0;
        String clientPortAddress = null;
        for (Map.Entry<Object, Object> entry : zkProp.entrySet()) {
            String[] parts;
            long sid;
            int dot;
            String key2 = entry.getKey().toString().trim();
            String value = entry.getValue().toString().trim();
            if (key2.equals("dataDir")) {
                this.dataDir = value;
                continue;
            }
            if (key2.equals("dataLogDir")) {
                this.dataLogDir = value;
                continue;
            }
            if (key2.equals("clientPort")) {
                clientPort = Integer.parseInt(value);
                continue;
            }
            if (key2.equals("clientPortAddress")) {
                clientPortAddress = value.trim();
                continue;
            }
            if (key2.equals("tickTime")) {
                this.tickTime = Integer.parseInt(value);
                continue;
            }
            if (key2.equals("maxClientCnxns")) {
                this.maxClientCnxns = Integer.parseInt(value);
                continue;
            }
            if (key2.equals("minSessionTimeout")) {
                this.minSessionTimeout = Integer.parseInt(value);
                continue;
            }
            if (key2.equals("maxSessionTimeout")) {
                this.maxSessionTimeout = Integer.parseInt(value);
                continue;
            }
            if (key2.equals("initLimit")) {
                this.initLimit = Integer.parseInt(value);
                continue;
            }
            if (key2.equals("syncLimit")) {
                this.syncLimit = Integer.parseInt(value);
                continue;
            }
            if (key2.equals("electionAlg")) {
                this.electionAlg = Integer.parseInt(value);
                continue;
            }
            if (key2.equals("quorumListenOnAllIPs")) {
                this.quorumListenOnAllIPs = Boolean.parseBoolean(value);
                continue;
            }
            if (key2.equals("peerType")) {
                if (value.toLowerCase().equals("observer")) {
                    this.peerType = QuorumPeer.LearnerType.OBSERVER;
                    continue;
                }
                if (value.toLowerCase().equals("participant")) {
                    this.peerType = QuorumPeer.LearnerType.PARTICIPANT;
                    continue;
                }
                throw new ConfigException("Unrecognised peertype: " + value);
            }
            if (key2.equals("syncEnabled")) {
                this.syncEnabled = Boolean.parseBoolean(value);
                continue;
            }
            if (key2.equals("autopurge.snapRetainCount")) {
                this.snapRetainCount = Integer.parseInt(value);
                continue;
            }
            if (key2.equals("autopurge.purgeInterval")) {
                this.purgeInterval = Integer.parseInt(value);
                continue;
            }
            if (key2.startsWith("server.")) {
                dot = key2.indexOf(46);
                sid = Long.parseLong(key2.substring(dot + 1));
                parts = QuorumPeerConfig.splitWithLeadingHostname(value);
                if (parts.length != 2 && parts.length != 3 && parts.length != 4) {
                    LOG.error(value + " does not have the form host:port or host:port:port  or host:port:port:type");
                }
                QuorumPeer.LearnerType type2 = null;
                String hostname = parts[0];
                Integer port = Integer.parseInt(parts[1]);
                Integer electionPort = null;
                if (parts.length > 2) {
                    electionPort = Integer.parseInt(parts[2]);
                }
                if (parts.length > 3) {
                    if (parts[3].toLowerCase().equals("observer")) {
                        type2 = QuorumPeer.LearnerType.OBSERVER;
                    } else if (parts[3].toLowerCase().equals("participant")) {
                        type2 = QuorumPeer.LearnerType.PARTICIPANT;
                    } else {
                        throw new ConfigException("Unrecognised peertype: " + value);
                    }
                }
                if (type2 == QuorumPeer.LearnerType.OBSERVER) {
                    this.observers.put(sid, new QuorumPeer.QuorumServer(sid, hostname, port, electionPort, type2));
                    continue;
                }
                this.servers.put(sid, new QuorumPeer.QuorumServer(sid, hostname, port, electionPort, type2));
                continue;
            }
            if (key2.startsWith("group")) {
                dot = key2.indexOf(46);
                long gid = Long.parseLong(key2.substring(dot + 1));
                ++this.numGroups;
                for (String s : parts = value.split(":")) {
                    long sid2 = Long.parseLong(s);
                    if (this.serverGroup.containsKey(sid2)) {
                        throw new ConfigException("Server " + sid2 + "is in multiple groups");
                    }
                    this.serverGroup.put(sid2, gid);
                }
                continue;
            }
            if (key2.startsWith("weight")) {
                dot = key2.indexOf(46);
                sid = Long.parseLong(key2.substring(dot + 1));
                this.serverWeight.put(sid, Long.parseLong(value));
                continue;
            }
            if (key2.equals("quorum.auth.enableSasl")) {
                this.quorumEnableSasl = Boolean.parseBoolean(value);
                continue;
            }
            if (key2.equals("quorum.auth.serverRequireSasl")) {
                this.quorumServerRequireSasl = Boolean.parseBoolean(value);
                continue;
            }
            if (key2.equals("quorum.auth.learnerRequireSasl")) {
                this.quorumLearnerRequireSasl = Boolean.parseBoolean(value);
                continue;
            }
            if (key2.equals("quorum.auth.learner.saslLoginContext")) {
                this.quorumLearnerLoginContext = value;
                continue;
            }
            if (key2.equals("quorum.auth.server.saslLoginContext")) {
                this.quorumServerLoginContext = value;
                continue;
            }
            if (key2.equals("quorum.auth.kerberos.servicePrincipal")) {
                this.quorumServicePrincipal = value;
                continue;
            }
            if (key2.equals("quorum.cnxn.threads.size")) {
                this.quorumCnxnThreadsSize = Integer.parseInt(value);
                continue;
            }
            System.setProperty("zookeeper." + key2, value);
        }
        if (!this.quorumEnableSasl && this.quorumServerRequireSasl) {
            throw new IllegalArgumentException("quorum.auth.enableSasl is disabled, so cannot enable quorum.auth.serverRequireSasl");
        }
        if (!this.quorumEnableSasl && this.quorumLearnerRequireSasl) {
            throw new IllegalArgumentException("quorum.auth.enableSasl is disabled, so cannot enable quorum.auth.learnerRequireSasl");
        }
        if (!this.quorumLearnerRequireSasl && this.quorumServerRequireSasl) {
            throw new IllegalArgumentException("quorum.auth.learnerRequireSasl is disabled, so cannot enable quorum.auth.serverRequireSasl");
        }
        if (this.snapRetainCount < 3) {
            LOG.warn("Invalid autopurge.snapRetainCount: " + this.snapRetainCount + ". Defaulting to " + 3);
            this.snapRetainCount = 3;
        }
        if (this.dataDir == null) {
            throw new IllegalArgumentException("dataDir is not set");
        }
        if (this.dataLogDir == null) {
            this.dataLogDir = this.dataDir;
        }
        if (clientPort == 0) {
            throw new IllegalArgumentException("clientPort is not set");
        }
        this.clientPortAddress = clientPortAddress != null ? new InetSocketAddress(InetAddress.getByName(clientPortAddress), clientPort) : new InetSocketAddress(clientPort);
        if (this.tickTime == 0) {
            throw new IllegalArgumentException("tickTime is not set");
        }
        if (this.minSessionTimeout > this.maxSessionTimeout) {
            throw new IllegalArgumentException("minSessionTimeout must not be larger than maxSessionTimeout");
        }
        if (this.servers.size() == 0) {
            if (this.observers.size() > 0) {
                throw new IllegalArgumentException("Observers w/o participants is an invalid configuration");
            }
            return;
        }
        if (this.servers.size() == 1) {
            if (this.observers.size() > 0) {
                throw new IllegalArgumentException("Observers w/o quorum is an invalid configuration");
            }
            LOG.error("Invalid configuration, only one server specified (ignoring)");
            this.servers.clear();
        } else if (this.servers.size() > 1) {
            QuorumPeer.LearnerType roleByServersList;
            String myIdString;
            if (this.servers.size() == 2) {
                LOG.warn("No server failure will be tolerated. You need at least 3 servers.");
            } else if (this.servers.size() % 2 == 0) {
                LOG.warn("Non-optimial configuration, consider an odd number of servers.");
            }
            if (this.initLimit == 0) {
                throw new IllegalArgumentException("initLimit is not set");
            }
            if (this.syncLimit == 0) {
                throw new IllegalArgumentException("syncLimit is not set");
            }
            if (this.electionAlg != 0) {
                for (QuorumPeer.QuorumServer s : this.servers.values()) {
                    if (s.electionAddr != null) continue;
                    throw new IllegalArgumentException("Missing election port for server: " + s.id);
                }
            }
            if (this.serverGroup.size() > 0) {
                if (this.servers.size() != this.serverGroup.size()) {
                    throw new ConfigException("Every server must be in exactly one group");
                }
                for (QuorumPeer.QuorumServer s : this.servers.values()) {
                    if (this.serverWeight.containsKey(s.id)) continue;
                    this.serverWeight.put(s.id, 1L);
                }
                this.quorumVerifier = new QuorumHierarchical(this.numGroups, this.serverWeight, this.serverGroup);
            } else {
                LOG.info("Defaulting to majority quorums");
                this.quorumVerifier = new QuorumMaj(this.servers.size());
            }
            this.servers.putAll(this.observers);
            File myIdFile = new File(this.dataDir, "myid");
            if (!myIdFile.exists()) {
                throw new IllegalArgumentException(myIdFile.toString() + " file is missing");
            }
            BufferedReader br = new BufferedReader(new FileReader(myIdFile));
            try {
                myIdString = br.readLine();
            }
            finally {
                br.close();
            }
            try {
                this.serverId = Long.parseLong(myIdString);
                MDC.put("myid", myIdString);
            }
            catch (NumberFormatException e2) {
                throw new IllegalArgumentException("serverid " + myIdString + " is not a number");
            }
            QuorumPeer.LearnerType learnerType = roleByServersList = this.observers.containsKey(this.serverId) ? QuorumPeer.LearnerType.OBSERVER : QuorumPeer.LearnerType.PARTICIPANT;
            if (roleByServersList != this.peerType) {
                LOG.warn("Peer type from servers list (" + (Object)((Object)roleByServersList) + ") doesn't match peerType (" + (Object)((Object)this.peerType) + "). Defaulting to servers list.");
                this.peerType = roleByServersList;
            }
        }
    }

    public InetSocketAddress getClientPortAddress() {
        return this.clientPortAddress;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public String getDataLogDir() {
        return this.dataLogDir;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public int getMaxClientCnxns() {
        return this.maxClientCnxns;
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout;
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout;
    }

    public int getInitLimit() {
        return this.initLimit;
    }

    public int getSyncLimit() {
        return this.syncLimit;
    }

    public int getElectionAlg() {
        return this.electionAlg;
    }

    public int getElectionPort() {
        return this.electionPort;
    }

    public int getSnapRetainCount() {
        return this.snapRetainCount;
    }

    public int getPurgeInterval() {
        return this.purgeInterval;
    }

    public boolean getSyncEnabled() {
        return this.syncEnabled;
    }

    public QuorumVerifier getQuorumVerifier() {
        return this.quorumVerifier;
    }

    public Map<Long, QuorumPeer.QuorumServer> getServers() {
        return Collections.unmodifiableMap(this.servers);
    }

    public long getServerId() {
        return this.serverId;
    }

    public boolean isDistributed() {
        return this.servers.size() > 1;
    }

    public QuorumPeer.LearnerType getPeerType() {
        return this.peerType;
    }

    public Boolean getQuorumListenOnAllIPs() {
        return this.quorumListenOnAllIPs;
    }

    public static class ConfigException
    extends Exception {
        public ConfigException(String msg) {
            super(msg);
        }

        public ConfigException(String msg, Exception e2) {
            super(msg, e2);
        }
    }
}

