/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server;

import io.mantisrx.shaded.org.apache.jute.BinaryOutputArchive;
import io.mantisrx.shaded.org.apache.jute.Record;
import io.mantisrx.shaded.org.apache.zookeeper.CreateMode;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.MultiTransactionRecord;
import io.mantisrx.shaded.org.apache.zookeeper.Op;
import io.mantisrx.shaded.org.apache.zookeeper.common.PathUtils;
import io.mantisrx.shaded.org.apache.zookeeper.common.Time;
import io.mantisrx.shaded.org.apache.zookeeper.data.ACL;
import io.mantisrx.shaded.org.apache.zookeeper.data.Id;
import io.mantisrx.shaded.org.apache.zookeeper.data.StatPersisted;
import io.mantisrx.shaded.org.apache.zookeeper.proto.CheckVersionRequest;
import io.mantisrx.shaded.org.apache.zookeeper.proto.CreateRequest;
import io.mantisrx.shaded.org.apache.zookeeper.proto.DeleteRequest;
import io.mantisrx.shaded.org.apache.zookeeper.proto.SetACLRequest;
import io.mantisrx.shaded.org.apache.zookeeper.proto.SetDataRequest;
import io.mantisrx.shaded.org.apache.zookeeper.server.ByteBufferInputStream;
import io.mantisrx.shaded.org.apache.zookeeper.server.DataNode;
import io.mantisrx.shaded.org.apache.zookeeper.server.Request;
import io.mantisrx.shaded.org.apache.zookeeper.server.RequestProcessor;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooKeeperCriticalThread;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooTrace;
import io.mantisrx.shaded.org.apache.zookeeper.server.auth.AuthenticationProvider;
import io.mantisrx.shaded.org.apache.zookeeper.server.auth.ProviderRegistry;
import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.Leader;
import io.mantisrx.shaded.org.apache.zookeeper.txn.CheckVersionTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.CreateSessionTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.CreateTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.DeleteTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.ErrorTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.MultiTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.SetACLTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.SetDataTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.Txn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.TxnHeader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepRequestProcessor
extends ZooKeeperCriticalThread
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(PrepRequestProcessor.class);
    static boolean skipACL = System.getProperty("zookeeper.skipACL", "no").equals("yes");
    private static boolean failCreate;
    LinkedBlockingQueue<Request> submittedRequests = new LinkedBlockingQueue();
    RequestProcessor nextProcessor;
    ZooKeeperServer zks;

    public PrepRequestProcessor(ZooKeeperServer zks, RequestProcessor nextProcessor) {
        super("ProcessThread(sid:" + zks.getServerId() + " cport:" + zks.getClientPort() + "):", zks.getZooKeeperServerListener());
        this.nextProcessor = nextProcessor;
        this.zks = zks;
    }

    public static void setFailCreate(boolean b) {
        failCreate = b;
    }

    @Override
    public void run() {
        try {
            while (true) {
                Request request = this.submittedRequests.take();
                long traceMask = 2L;
                if (request.type == 11) {
                    traceMask = 8L;
                }
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logRequest(LOG, traceMask, 'P', request, "");
                }
                if (Request.requestOfDeath != request) {
                    this.pRequest(request);
                    continue;
                }
                break;
            }
        }
        catch (RequestProcessor.RequestProcessorException e2) {
            if (e2.getCause() instanceof Leader.XidRolloverException) {
                LOG.info(e2.getCause().getMessage());
            }
            this.handleException(this.getName(), e2);
        }
        catch (Exception e3) {
            this.handleException(this.getName(), e3);
        }
        LOG.info("PrepRequestProcessor exited loop!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ZooKeeperServer.ChangeRecord getRecordForPath(String path2) throws KeeperException.NoNodeException {
        ZooKeeperServer.ChangeRecord lastChange = null;
        List<ZooKeeperServer.ChangeRecord> list = this.zks.outstandingChanges;
        synchronized (list) {
            DataNode n;
            lastChange = this.zks.outstandingChangesForPath.get(path2);
            if (lastChange == null && (n = this.zks.getZKDatabase().getNode(path2)) != null) {
                Set<String> children2;
                DataNode dataNode = n;
                synchronized (dataNode) {
                    children2 = n.getChildren();
                }
                lastChange = new ZooKeeperServer.ChangeRecord(-1L, path2, n.stat, children2.size(), this.zks.getZKDatabase().aclForNode(n));
            }
        }
        if (lastChange == null || lastChange.stat == null) {
            throw new KeeperException.NoNodeException(path2);
        }
        return lastChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZooKeeperServer.ChangeRecord getOutstandingChange(String path2) {
        List<ZooKeeperServer.ChangeRecord> list = this.zks.outstandingChanges;
        synchronized (list) {
            return this.zks.outstandingChangesForPath.get(path2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChangeRecord(ZooKeeperServer.ChangeRecord c) {
        List<ZooKeeperServer.ChangeRecord> list = this.zks.outstandingChanges;
        synchronized (list) {
            this.zks.outstandingChanges.add(c);
            this.zks.outstandingChangesForPath.put(c.path, c);
        }
    }

    HashMap<String, ZooKeeperServer.ChangeRecord> getPendingChanges(MultiTransactionRecord multiRequest) {
        HashMap<String, ZooKeeperServer.ChangeRecord> pendingChangeRecords = new HashMap<String, ZooKeeperServer.ChangeRecord>();
        for (Op op : multiRequest) {
            String parentPath;
            ZooKeeperServer.ChangeRecord parentCr;
            int lastSlash;
            String path2 = op.getPath();
            ZooKeeperServer.ChangeRecord cr = this.getOutstandingChange(path2);
            if (cr != null) {
                pendingChangeRecords.put(path2, cr);
            }
            if ((lastSlash = path2.lastIndexOf(47)) == -1 || path2.indexOf(0) != -1 || (parentCr = this.getOutstandingChange(parentPath = path2.substring(0, lastSlash))) == null) continue;
            pendingChangeRecords.put(parentPath, parentCr);
        }
        return pendingChangeRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackPendingChanges(long zxid, HashMap<String, ZooKeeperServer.ChangeRecord> pendingChangeRecords) {
        List<ZooKeeperServer.ChangeRecord> list = this.zks.outstandingChanges;
        synchronized (list) {
            ListIterator<ZooKeeperServer.ChangeRecord> iter = this.zks.outstandingChanges.listIterator(this.zks.outstandingChanges.size());
            while (iter.hasPrevious()) {
                ZooKeeperServer.ChangeRecord c = iter.previous();
                if (c.zxid != zxid) break;
                iter.remove();
                this.zks.outstandingChangesForPath.remove(c.path);
            }
            if (this.zks.outstandingChanges.isEmpty()) {
                return;
            }
            long firstZxid = this.zks.outstandingChanges.get((int)0).zxid;
            for (ZooKeeperServer.ChangeRecord c : pendingChangeRecords.values()) {
                if (c.zxid < firstZxid) continue;
                this.zks.outstandingChangesForPath.put(c.path, c);
            }
        }
    }

    static void checkACL(ZooKeeperServer zks, List<ACL> acl, int perm, List<Id> ids) throws KeeperException.NoAuthException {
        if (skipACL) {
            return;
        }
        if (acl == null || acl.size() == 0) {
            return;
        }
        for (Id authId : ids) {
            if (!authId.getScheme().equals("super")) continue;
            return;
        }
        for (ACL a : acl) {
            Id id = a.getId();
            if ((a.getPerms() & perm) == 0) continue;
            if (id.getScheme().equals("world") && id.getId().equals("anyone")) {
                return;
            }
            AuthenticationProvider ap = ProviderRegistry.getProvider(id.getScheme());
            if (ap == null) continue;
            for (Id authId : ids) {
                if (!authId.getScheme().equals(id.getScheme()) || !ap.matches(authId.getId(), id.getId())) continue;
                return;
            }
        }
        throw new KeeperException.NoAuthException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pRequest2Txn(int type2, long zxid, Request request, Record record, boolean deserialize) throws KeeperException, IOException, RequestProcessor.RequestProcessorException {
        request.hdr = new TxnHeader(request.sessionId, request.cxid, zxid, Time.currentWallTime(), type2);
        switch (type2) {
            case 1: {
                boolean ephemeralParent;
                String path2;
                int lastSlash;
                this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                CreateRequest createRequest = (CreateRequest)record;
                if (deserialize) {
                    ByteBufferInputStream.byteBuffer2Record(request.request, createRequest);
                }
                if ((lastSlash = (path2 = createRequest.getPath()).lastIndexOf(47)) == -1 || path2.indexOf(0) != -1 || failCreate) {
                    LOG.info("Invalid path " + path2 + " with session 0x" + Long.toHexString(request.sessionId));
                    throw new KeeperException.BadArgumentsException(path2);
                }
                List<ACL> listACL = this.removeDuplicates(createRequest.getAcl());
                if (!this.fixupACL(request.authInfo, listACL)) {
                    throw new KeeperException.InvalidACLException(path2);
                }
                String parentPath = path2.substring(0, lastSlash);
                ZooKeeperServer.ChangeRecord parentRecord = this.getRecordForPath(parentPath);
                PrepRequestProcessor.checkACL(this.zks, parentRecord.acl, 4, request.authInfo);
                int parentCVersion = parentRecord.stat.getCversion();
                CreateMode createMode = CreateMode.fromFlag(createRequest.getFlags());
                if (createMode.isSequential()) {
                    path2 = path2 + String.format(Locale.ENGLISH, "%010d", parentCVersion);
                }
                this.validatePath(path2, request.sessionId);
                try {
                    if (this.getRecordForPath(path2) != null) {
                        throw new KeeperException.NodeExistsException(path2);
                    }
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    // empty catch block
                }
                boolean bl = ephemeralParent = parentRecord.stat.getEphemeralOwner() != 0L;
                if (ephemeralParent) {
                    throw new KeeperException.NoChildrenForEphemeralsException(path2);
                }
                int newCversion = parentRecord.stat.getCversion() + 1;
                request.txn = new CreateTxn(path2, createRequest.getData(), listACL, createMode.isEphemeral(), newCversion);
                StatPersisted s = new StatPersisted();
                if (createMode.isEphemeral()) {
                    s.setEphemeralOwner(request.sessionId);
                }
                parentRecord = parentRecord.duplicate(request.hdr.getZxid());
                ++parentRecord.childCount;
                parentRecord.stat.setCversion(newCversion);
                this.addChangeRecord(parentRecord);
                this.addChangeRecord(new ZooKeeperServer.ChangeRecord(request.hdr.getZxid(), path2, s, 0, listACL));
                break;
            }
            case 2: {
                String path3;
                int lastSlash;
                this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                DeleteRequest deleteRequest = (DeleteRequest)record;
                if (deserialize) {
                    ByteBufferInputStream.byteBuffer2Record(request.request, deleteRequest);
                }
                if ((lastSlash = (path3 = deleteRequest.getPath()).lastIndexOf(47)) == -1 || path3.indexOf(0) != -1 || this.zks.getZKDatabase().isSpecialPath(path3)) {
                    throw new KeeperException.BadArgumentsException(path3);
                }
                String parentPath = path3.substring(0, lastSlash);
                ZooKeeperServer.ChangeRecord parentRecord = this.getRecordForPath(parentPath);
                ZooKeeperServer.ChangeRecord nodeRecord = this.getRecordForPath(path3);
                PrepRequestProcessor.checkACL(this.zks, parentRecord.acl, 8, request.authInfo);
                int version = deleteRequest.getVersion();
                if (version != -1 && nodeRecord.stat.getVersion() != version) {
                    throw new KeeperException.BadVersionException(path3);
                }
                if (nodeRecord.childCount > 0) {
                    throw new KeeperException.NotEmptyException(path3);
                }
                request.txn = new DeleteTxn(path3);
                parentRecord = parentRecord.duplicate(request.hdr.getZxid());
                --parentRecord.childCount;
                this.addChangeRecord(parentRecord);
                this.addChangeRecord(new ZooKeeperServer.ChangeRecord(request.hdr.getZxid(), path3, null, -1, null));
                break;
            }
            case 5: {
                this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                SetDataRequest setDataRequest = (SetDataRequest)record;
                if (deserialize) {
                    ByteBufferInputStream.byteBuffer2Record(request.request, setDataRequest);
                }
                String path4 = setDataRequest.getPath();
                this.validatePath(path4, request.sessionId);
                ZooKeeperServer.ChangeRecord nodeRecord = this.getRecordForPath(path4);
                PrepRequestProcessor.checkACL(this.zks, nodeRecord.acl, 2, request.authInfo);
                int version = setDataRequest.getVersion();
                int currentVersion = nodeRecord.stat.getVersion();
                if (version != -1 && version != currentVersion) {
                    throw new KeeperException.BadVersionException(path4);
                }
                version = currentVersion + 1;
                request.txn = new SetDataTxn(path4, setDataRequest.getData(), version);
                nodeRecord = nodeRecord.duplicate(request.hdr.getZxid());
                nodeRecord.stat.setVersion(version);
                this.addChangeRecord(nodeRecord);
                break;
            }
            case 7: {
                this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                SetACLRequest setAclRequest = (SetACLRequest)record;
                if (deserialize) {
                    ByteBufferInputStream.byteBuffer2Record(request.request, setAclRequest);
                }
                String path5 = setAclRequest.getPath();
                this.validatePath(path5, request.sessionId);
                List<ACL> listACL = this.removeDuplicates(setAclRequest.getAcl());
                if (!this.fixupACL(request.authInfo, listACL)) {
                    throw new KeeperException.InvalidACLException(path5);
                }
                ZooKeeperServer.ChangeRecord nodeRecord = this.getRecordForPath(path5);
                PrepRequestProcessor.checkACL(this.zks, nodeRecord.acl, 16, request.authInfo);
                int version = setAclRequest.getVersion();
                int currentVersion = nodeRecord.stat.getAversion();
                if (version != -1 && version != currentVersion) {
                    throw new KeeperException.BadVersionException(path5);
                }
                version = currentVersion + 1;
                request.txn = new SetACLTxn(path5, listACL, version);
                nodeRecord = nodeRecord.duplicate(request.hdr.getZxid());
                nodeRecord.stat.setAversion(version);
                this.addChangeRecord(nodeRecord);
                break;
            }
            case -10: {
                request.request.rewind();
                int to = request.request.getInt();
                request.txn = new CreateSessionTxn(to);
                request.request.rewind();
                this.zks.sessionTracker.addSession(request.sessionId, to);
                this.zks.setOwner(request.sessionId, request.getOwner());
                break;
            }
            case -11: {
                HashSet<String> es = this.zks.getZKDatabase().getEphemerals(request.sessionId);
                List<ZooKeeperServer.ChangeRecord> list = this.zks.outstandingChanges;
                synchronized (list) {
                    for (ZooKeeperServer.ChangeRecord c : this.zks.outstandingChanges) {
                        if (c.stat == null) {
                            es.remove(c.path);
                            continue;
                        }
                        if (c.stat.getEphemeralOwner() != request.sessionId) continue;
                        es.add(c.path);
                    }
                    for (String path2Delete : es) {
                        this.addChangeRecord(new ZooKeeperServer.ChangeRecord(request.hdr.getZxid(), path2Delete, null, 0, null));
                    }
                    this.zks.sessionTracker.setSessionClosing(request.sessionId);
                }
                LOG.info("Processed session termination for sessionid: 0x" + Long.toHexString(request.sessionId));
                break;
            }
            case 13: {
                this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                CheckVersionRequest checkVersionRequest = (CheckVersionRequest)record;
                if (deserialize) {
                    ByteBufferInputStream.byteBuffer2Record(request.request, checkVersionRequest);
                }
                String path6 = checkVersionRequest.getPath();
                this.validatePath(path6, request.sessionId);
                ZooKeeperServer.ChangeRecord nodeRecord = this.getRecordForPath(path6);
                PrepRequestProcessor.checkACL(this.zks, nodeRecord.acl, 1, request.authInfo);
                int version = checkVersionRequest.getVersion();
                int currentVersion = nodeRecord.stat.getVersion();
                if (version != -1 && version != currentVersion) {
                    throw new KeeperException.BadVersionException(path6);
                }
                version = currentVersion + 1;
                request.txn = new CheckVersionTxn(path6, version);
                break;
            }
            default: {
                LOG.error("Invalid OpCode: {} received by PrepRequestProcessor", (Object)type2);
            }
        }
    }

    private void validatePath(String path2, long sessionId) throws KeeperException.BadArgumentsException {
        try {
            PathUtils.validatePath(path2);
        }
        catch (IllegalArgumentException ie) {
            LOG.info("Invalid path " + path2 + " with session 0x" + Long.toHexString(sessionId) + ", reason: " + ie.getMessage());
            throw new KeeperException.BadArgumentsException(path2);
        }
    }

    protected void pRequest(Request request) throws RequestProcessor.RequestProcessorException {
        block24: {
            request.hdr = null;
            request.txn = null;
            try {
                switch (request.type) {
                    case 1: {
                        CreateRequest createRequest = new CreateRequest();
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, createRequest, true);
                        break;
                    }
                    case 2: {
                        DeleteRequest deleteRequest = new DeleteRequest();
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, deleteRequest, true);
                        break;
                    }
                    case 5: {
                        SetDataRequest setDataRequest = new SetDataRequest();
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, setDataRequest, true);
                        break;
                    }
                    case 7: {
                        SetACLRequest setAclRequest = new SetACLRequest();
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, setAclRequest, true);
                        break;
                    }
                    case 13: {
                        CheckVersionRequest checkRequest = new CheckVersionRequest();
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, checkRequest, true);
                        break;
                    }
                    case 14: {
                        MultiTransactionRecord multiRequest = new MultiTransactionRecord();
                        try {
                            ByteBufferInputStream.byteBuffer2Record(request.request, multiRequest);
                        }
                        catch (IOException e2) {
                            request.hdr = new TxnHeader(request.sessionId, request.cxid, this.zks.getNextZxid(), Time.currentWallTime(), 14);
                            throw e2;
                        }
                        ArrayList<Txn> txns = new ArrayList<Txn>();
                        long zxid = this.zks.getNextZxid();
                        KeeperException ke = null;
                        HashMap<String, ZooKeeperServer.ChangeRecord> pendingChanges = this.getPendingChanges(multiRequest);
                        int index2 = 0;
                        for (Op op : multiRequest) {
                            Record subrequest = op.toRequestRecord();
                            if (ke != null) {
                                request.hdr.setType(-1);
                                request.txn = new ErrorTxn(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue());
                            } else {
                                try {
                                    this.pRequest2Txn(op.getType(), zxid, request, subrequest, false);
                                }
                                catch (KeeperException e3) {
                                    ke = e3;
                                    request.hdr.setType(-1);
                                    request.txn = new ErrorTxn(e3.code().intValue());
                                    LOG.info("Got user-level KeeperException when processing " + request.toString() + " aborting remaining multi ops. Error Path:" + e3.getPath() + " Error:" + e3.getMessage());
                                    request.setException(e3);
                                    this.rollbackPendingChanges(zxid, pendingChanges);
                                }
                            }
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
                            request.txn.serialize(boa, "request");
                            ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
                            txns.add(new Txn(request.hdr.getType(), bb.array()));
                            ++index2;
                        }
                        request.hdr = new TxnHeader(request.sessionId, request.cxid, zxid, Time.currentWallTime(), request.type);
                        request.txn = new MultiTxn(txns);
                        break;
                    }
                    case -11: 
                    case -10: {
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, null, true);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 101: {
                        this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                        break;
                    }
                    default: {
                        LOG.warn("unknown type " + request.type);
                        break;
                    }
                }
            }
            catch (KeeperException e4) {
                if (request.hdr != null) {
                    request.hdr.setType(-1);
                    request.txn = new ErrorTxn(e4.code().intValue());
                }
                LOG.info("Got user-level KeeperException when processing " + request.toString() + " Error Path:" + e4.getPath() + " Error:" + e4.getMessage());
                request.setException(e4);
            }
            catch (Exception e5) {
                LOG.error("Failed to process " + request, e5);
                StringBuilder sb = new StringBuilder();
                ByteBuffer bb = request.request;
                if (bb != null) {
                    bb.rewind();
                    while (bb.hasRemaining()) {
                        sb.append(Integer.toHexString(bb.get() & 0xFF));
                    }
                } else {
                    sb.append("request buffer is null");
                }
                LOG.error("Dumping request buffer: 0x" + sb.toString());
                if (request.hdr == null) break block24;
                request.hdr.setType(-1);
                request.txn = new ErrorTxn(KeeperException.Code.MARSHALLINGERROR.intValue());
            }
        }
        request.zxid = this.zks.getZxid();
        this.nextProcessor.processRequest(request);
    }

    private List<ACL> removeDuplicates(List<ACL> acl) {
        ArrayList<ACL> retval = new ArrayList<ACL>();
        for (ACL a : acl) {
            if (retval.contains(a)) continue;
            retval.add(a);
        }
        return retval;
    }

    private boolean fixupACL(List<Id> authInfo, List<ACL> acl) {
        if (skipACL) {
            return true;
        }
        if (acl == null || acl.size() == 0) {
            return false;
        }
        Iterator<ACL> it = acl.iterator();
        LinkedList<ACL> toAdd = null;
        while (it.hasNext()) {
            ACL a = it.next();
            Id id = a.getId();
            if (id.getScheme().equals("world") && id.getId().equals("anyone")) continue;
            if (id.getScheme().equals("auth")) {
                it.remove();
                if (toAdd == null) {
                    toAdd = new LinkedList<ACL>();
                }
                boolean authIdValid = false;
                for (Id cid : authInfo) {
                    AuthenticationProvider ap = ProviderRegistry.getProvider(cid.getScheme());
                    if (ap == null) {
                        LOG.error("Missing AuthenticationProvider for " + cid.getScheme());
                        continue;
                    }
                    if (!ap.isAuthenticated()) continue;
                    authIdValid = true;
                    toAdd.add(new ACL(a.getPerms(), cid));
                }
                if (authIdValid) continue;
                return false;
            }
            AuthenticationProvider ap = ProviderRegistry.getProvider(id.getScheme());
            if (ap == null) {
                return false;
            }
            if (ap.isValid(id.getId())) continue;
            return false;
        }
        if (toAdd != null) {
            for (ACL a : toAdd) {
                acl.add(a);
            }
        }
        return acl.size() > 0;
    }

    @Override
    public void processRequest(Request request) {
        this.submittedRequests.add(request);
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down");
        this.submittedRequests.clear();
        this.submittedRequests.add(Request.requestOfDeath);
        this.nextProcessor.shutdown();
    }

    static {
        if (skipACL) {
            LOG.info("zookeeper.skipACL==\"yes\", ACL checks will be skipped");
        }
        failCreate = false;
    }
}

