/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper;

import io.mantisrx.shaded.org.apache.zookeeper.AsyncCallback;
import io.mantisrx.shaded.org.apache.zookeeper.CreateMode;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.Op;
import io.mantisrx.shaded.org.apache.zookeeper.OpResult;
import io.mantisrx.shaded.org.apache.zookeeper.ZooKeeper;
import io.mantisrx.shaded.org.apache.zookeeper.data.ACL;
import java.util.ArrayList;
import java.util.List;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class Transaction {
    private ZooKeeper zk;
    private List<Op> ops = new ArrayList<Op>();

    protected Transaction(ZooKeeper zk) {
        this.zk = zk;
    }

    public Transaction create(String path2, byte[] data2, List<ACL> acl, CreateMode createMode) {
        this.ops.add(Op.create(path2, data2, acl, createMode.toFlag()));
        return this;
    }

    public Transaction delete(String path2, int version) {
        this.ops.add(Op.delete(path2, version));
        return this;
    }

    public Transaction check(String path2, int version) {
        this.ops.add(Op.check(path2, version));
        return this;
    }

    public Transaction setData(String path2, byte[] data2, int version) {
        this.ops.add(Op.setData(path2, data2, version));
        return this;
    }

    public List<OpResult> commit() throws InterruptedException, KeeperException {
        return this.zk.multi(this.ops);
    }

    public void commit(AsyncCallback.MultiCallback cb, Object ctx) {
        this.zk.multi(this.ops, cb, ctx);
    }
}

