/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.jute.compiler;

import io.mantisrx.shaded.org.apache.jute.compiler.JCompType;
import io.mantisrx.shaded.org.apache.jute.compiler.JType;

public class JMap
extends JCompType {
    private static int level = 0;
    private JType mKey;
    private JType mValue;

    private static String getLevel() {
        return Integer.toString(level);
    }

    private static void incrLevel() {
        ++level;
    }

    private static void decrLevel() {
        --level;
    }

    private static String getId(String id) {
        return id + JMap.getLevel();
    }

    public JMap(JType t1, JType t2) {
        super("#error", " ::std::map<" + t1.getCppType() + "," + t2.getCppType() + ">", "System.Collections.Generic.SortedDictionary<string, string>", "java.util.TreeMap", "Map", "System.Collections.Generic.SortedDictionary<string, string>", "java.util.TreeMap");
        this.mKey = t1;
        this.mValue = t2;
    }

    @Override
    public String getSignature() {
        return "{" + this.mKey.getSignature() + this.mValue.getSignature() + "}";
    }

    @Override
    public String genJavaCompareTo(String fname) {
        return "    throw new UnsupportedOperationException(\"comparing " + fname + " is unimplemented\");\n";
    }

    @Override
    public String genJavaReadWrapper(String fname, String tag, boolean decl) {
        StringBuilder ret = new StringBuilder("");
        if (decl) {
            ret.append("    java.util.TreeMap " + fname + ";\n");
        }
        ret.append("    {\n");
        JMap.incrLevel();
        ret.append("      org.apache.jute.Index " + JMap.getId("midx") + " = a_.startMap(\"" + tag + "\");\n");
        ret.append("      " + fname + "=new java.util.TreeMap();\n");
        ret.append("      for (; !" + JMap.getId("midx") + ".done(); " + JMap.getId("midx") + ".incr()) {\n");
        ret.append(this.mKey.genJavaReadWrapper(JMap.getId("k"), JMap.getId("k"), true));
        ret.append(this.mValue.genJavaReadWrapper(JMap.getId("v"), JMap.getId("v"), true));
        ret.append("        " + fname + ".put(" + JMap.getId("k") + "," + JMap.getId("v") + ");\n");
        ret.append("      }\n");
        ret.append("    a_.endMap(\"" + tag + "\");\n");
        JMap.decrLevel();
        ret.append("    }\n");
        return ret.toString();
    }

    @Override
    public String genJavaReadMethod(String fname, String tag) {
        return this.genJavaReadWrapper(fname, tag, false);
    }

    @Override
    public String genJavaWriteWrapper(String fname, String tag) {
        StringBuilder ret = new StringBuilder("    {\n");
        JMap.incrLevel();
        ret.append("      a_.startMap(" + fname + ",\"" + tag + "\");\n");
        ret.append("      java.util.Set " + JMap.getId("es") + " = " + fname + ".entrySet();\n");
        ret.append("      for(java.util.Iterator " + JMap.getId("midx") + " = " + JMap.getId("es") + ".iterator(); " + JMap.getId("midx") + ".hasNext(); ) {\n");
        ret.append("        java.util.Map.Entry " + JMap.getId("me") + " = (java.util.Map.Entry) " + JMap.getId("midx") + ".next();\n");
        ret.append("        " + this.mKey.getJavaWrapperType() + " " + JMap.getId("k") + " = (" + this.mKey.getJavaWrapperType() + ") " + JMap.getId("me") + ".getKey();\n");
        ret.append("        " + this.mValue.getJavaWrapperType() + " " + JMap.getId("v") + " = (" + this.mValue.getJavaWrapperType() + ") " + JMap.getId("me") + ".getValue();\n");
        ret.append(this.mKey.genJavaWriteWrapper(JMap.getId("k"), JMap.getId("k")));
        ret.append(this.mValue.genJavaWriteWrapper(JMap.getId("v"), JMap.getId("v")));
        ret.append("      }\n");
        ret.append("      a_.endMap(" + fname + ",\"" + tag + "\");\n");
        ret.append("    }\n");
        JMap.decrLevel();
        return ret.toString();
    }

    @Override
    public String genJavaWriteMethod(String fname, String tag) {
        return this.genJavaWriteWrapper(fname, tag);
    }

    public String genCsharpWriteWrapper(String fname, int tag) {
        StringBuilder ret = new StringBuilder("    {\n");
        JMap.incrLevel();
        ret.append("      a_.StartMap(" + fname + ",\"" + tag + "\");\n");
        ret.append("      java.util.Set " + JMap.getId("es") + " = " + fname + ".entrySet();\n");
        ret.append("      for(java.util.Iterator " + JMap.getId("midx") + " = " + JMap.getId("es") + ".iterator(); " + JMap.getId("midx") + ".hasNext(); ) {\n");
        ret.append("        java.util.Map.Entry " + JMap.getId("me") + " = (java.util.Map.Entry) " + JMap.getId("midx") + ".next();\n");
        ret.append("        " + this.mKey.getCsharpWrapperType() + " " + JMap.getId("k") + " = (" + this.mKey.getCsharpWrapperType() + ") " + JMap.getId("me") + ".getKey();\n");
        ret.append("        " + this.mValue.getCsharpWrapperType() + " " + JMap.getId("v") + " = (" + this.mValue.getCsharpWrapperType() + ") " + JMap.getId("me") + ".getValue();\n");
        ret.append(this.mKey.genCsharpWriteWrapper(JMap.getId("k"), JMap.getId("k")));
        ret.append(this.mValue.genCsharpWriteWrapper(JMap.getId("v"), JMap.getId("v")));
        ret.append("      }\n");
        ret.append("      a_.EndMap(" + fname + ",\"" + tag + "\");\n");
        ret.append("    }\n");
        JMap.decrLevel();
        return ret.toString();
    }

    String genCsharpWriteMethod(String fname, int tag) {
        return this.genCsharpWriteWrapper(fname, tag);
    }

    public String genCsharpReadWrapper(String fname, int tag, boolean decl) {
        StringBuilder ret = new StringBuilder("");
        if (decl) {
            ret.append("    System.Collections.SortedDictionary<string,string> " + JMap.capitalize(fname) + ";\n");
        }
        ret.append("    {\n");
        JMap.incrLevel();
        ret.append("      Org.Apache.Jute.IIndex " + JMap.getId("midx") + " = a_.StartMap(\"" + tag + "\");\n");
        ret.append("      " + fname + "= new System.Collections.SortedDictionary<string,string>();\n");
        ret.append("      for (; !" + JMap.getId("midx") + ".done(); " + JMap.getId("midx") + ".incr()) {\n");
        ret.append(this.mKey.genCsharpReadWrapper(JMap.getId("k"), JMap.getId("k"), true));
        ret.append(this.mValue.genCsharpReadWrapper(JMap.getId("v"), JMap.getId("v"), true));
        ret.append("        " + fname + ".Add(" + JMap.getId("k") + "," + JMap.getId("v") + ");\n");
        ret.append("      }\n");
        ret.append("    a_.EndMap(\"" + tag + "\");\n");
        JMap.decrLevel();
        ret.append("    }\n");
        return ret.toString();
    }

    String genCsharpReadMethod(String fname, int tag) {
        return this.genCsharpReadWrapper(fname, tag, false);
    }
}

