/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.utils;

import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Splitter;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.Lists;
import io.mantisrx.shaded.org.apache.curator.utils.InternalACLProvider;
import io.mantisrx.shaded.org.apache.curator.utils.PathUtils;
import io.mantisrx.shaded.org.apache.zookeeper.CreateMode;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.ZooDefs;
import io.mantisrx.shaded.org.apache.zookeeper.ZooKeeper;
import io.mantisrx.shaded.org.apache.zookeeper.data.ACL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKPaths {
    public static final String PATH_SEPARATOR = "/";
    private static final CreateMode NON_CONTAINER_MODE = CreateMode.PERSISTENT;
    private static final Splitter PATH_SPLITTER = Splitter.on("/").omitEmptyStrings();

    public static CreateMode getContainerCreateMode() {
        return CreateModeHolder.containerCreateMode;
    }

    public static boolean hasContainerSupport() {
        return ZKPaths.getContainerCreateMode() != NON_CONTAINER_MODE;
    }

    public static String fixForNamespace(String namespace2, String path2) {
        return ZKPaths.fixForNamespace(namespace2, path2, false);
    }

    public static String fixForNamespace(String namespace2, String path2, boolean isSequential) {
        PathUtils.validatePath(path2, isSequential);
        if (namespace2 != null) {
            return ZKPaths.makePath(namespace2, path2);
        }
        return path2;
    }

    public static String getNodeFromPath(String path2) {
        PathUtils.validatePath(path2);
        int i = path2.lastIndexOf(PATH_SEPARATOR);
        if (i < 0) {
            return path2;
        }
        if (i + 1 >= path2.length()) {
            return "";
        }
        return path2.substring(i + 1);
    }

    public static PathAndNode getPathAndNode(String path2) {
        PathUtils.validatePath(path2);
        int i = path2.lastIndexOf(PATH_SEPARATOR);
        if (i < 0) {
            return new PathAndNode(path2, "");
        }
        if (i + 1 >= path2.length()) {
            return new PathAndNode(PATH_SEPARATOR, "");
        }
        String node2 = path2.substring(i + 1);
        String parentPath = i > 0 ? path2.substring(0, i) : PATH_SEPARATOR;
        return new PathAndNode(parentPath, node2);
    }

    public static List<String> split(String path2) {
        PathUtils.validatePath(path2);
        return PATH_SPLITTER.splitToList(path2);
    }

    public static void mkdirs(ZooKeeper zookeeper, String path2) throws InterruptedException, KeeperException {
        ZKPaths.mkdirs(zookeeper, path2, true, null, false);
    }

    public static void mkdirs(ZooKeeper zookeeper, String path2, boolean makeLastNode) throws InterruptedException, KeeperException {
        ZKPaths.mkdirs(zookeeper, path2, makeLastNode, null, false);
    }

    public static void mkdirs(ZooKeeper zookeeper, String path2, boolean makeLastNode, InternalACLProvider aclProvider) throws InterruptedException, KeeperException {
        ZKPaths.mkdirs(zookeeper, path2, makeLastNode, aclProvider, false);
    }

    public static void mkdirs(ZooKeeper zookeeper, String path2, boolean makeLastNode, InternalACLProvider aclProvider, boolean asContainers) throws InterruptedException, KeeperException {
        PathUtils.validatePath(path2);
        int pos = 1;
        do {
            String subPath;
            if ((pos = path2.indexOf(PATH_SEPARATOR, pos + 1)) == -1) {
                if (!makeLastNode) break;
                pos = path2.length();
            }
            if (zookeeper.exists(subPath = path2.substring(0, pos), false) != null) continue;
            try {
                List<ACL> acl = null;
                if (aclProvider != null && (acl = aclProvider.getAclForPath(subPath)) == null) {
                    acl = aclProvider.getDefaultAcl();
                }
                if (acl == null) {
                    acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
                }
                zookeeper.create(subPath, new byte[0], acl, ZKPaths.getCreateMode(asContainers));
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        } while (pos < path2.length());
    }

    public static void deleteChildren(ZooKeeper zookeeper, String path2, boolean deleteSelf) throws InterruptedException, KeeperException {
        PathUtils.validatePath(path2);
        List<String> children2 = zookeeper.getChildren(path2, null);
        for (String child : children2) {
            String fullPath = ZKPaths.makePath(path2, child);
            ZKPaths.deleteChildren(zookeeper, fullPath, true);
        }
        if (deleteSelf) {
            try {
                zookeeper.delete(path2, -1);
            }
            catch (KeeperException.NotEmptyException e2) {
                ZKPaths.deleteChildren(zookeeper, path2, true);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
        }
    }

    public static List<String> getSortedChildren(ZooKeeper zookeeper, String path2) throws InterruptedException, KeeperException {
        List<String> children2 = zookeeper.getChildren(path2, false);
        ArrayList<String> sortedList = Lists.newArrayList(children2);
        Collections.sort(sortedList);
        return sortedList;
    }

    public static String makePath(String parent, String child) {
        StringBuilder path2 = new StringBuilder();
        ZKPaths.joinPath(path2, parent, child);
        return path2.toString();
    }

    public static String makePath(String parent, String firstChild, String ... restChildren) {
        StringBuilder path2 = new StringBuilder();
        ZKPaths.joinPath(path2, parent, firstChild);
        if (restChildren == null) {
            return path2.toString();
        }
        for (String child : restChildren) {
            ZKPaths.joinPath(path2, "", child);
        }
        return path2.toString();
    }

    private static void joinPath(StringBuilder path2, String parent, String child) {
        if (parent != null && parent.length() > 0) {
            if (!parent.startsWith(PATH_SEPARATOR)) {
                path2.append(PATH_SEPARATOR);
            }
            if (parent.endsWith(PATH_SEPARATOR)) {
                path2.append(parent.substring(0, parent.length() - 1));
            } else {
                path2.append(parent);
            }
        }
        if (child == null || child.length() == 0 || child.equals(PATH_SEPARATOR)) {
            if (path2.length() == 0) {
                path2.append(PATH_SEPARATOR);
            }
            return;
        }
        path2.append(PATH_SEPARATOR);
        if (child.startsWith(PATH_SEPARATOR)) {
            child = child.substring(1);
        }
        if (child.endsWith(PATH_SEPARATOR)) {
            child = child.substring(0, child.length() - 1);
        }
        path2.append(child);
    }

    private ZKPaths() {
    }

    private static CreateMode getCreateMode(boolean asContainers) {
        return asContainers ? ZKPaths.getContainerCreateMode() : CreateMode.PERSISTENT;
    }

    public static class PathAndNode {
        private final String path;
        private final String node;

        public PathAndNode(String path2, String node2) {
            this.path = path2;
            this.node = node2;
        }

        public String getPath() {
            return this.path;
        }

        public String getNode() {
            return this.node;
        }
    }

    private static class CreateModeHolder {
        private static final Logger log;
        private static final CreateMode containerCreateMode;

        private CreateModeHolder() {
        }

        static {
            CreateMode localCreateMode;
            log = LoggerFactory.getLogger(ZKPaths.class);
            try {
                localCreateMode = CreateMode.valueOf("CONTAINER");
            }
            catch (IllegalArgumentException ignore) {
                localCreateMode = NON_CONTAINER_MODE;
                log.warn("The version of ZooKeeper being used doesn't support Container nodes. CreateMode.PERSISTENT will be used instead.");
            }
            containerCreateMode = localCreateMode;
        }
    }
}

