/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.hash;

import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.hash.BloomFilter;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.hash.Funnel;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.hash.Hashing;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.math.LongMath;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.primitives.Ints;
import java.math.RoundingMode;
import java.util.Arrays;

enum BloomFilterStrategies implements BloomFilter.Strategy
{
    MURMUR128_MITZ_32{

        @Override
        public <T> boolean put(T object, Funnel<? super T> funnel, int numHashFunctions, BitArray bits) {
            long hash64 = Hashing.murmur3_128().hashObject(object, funnel).asLong();
            int hash1 = (int)hash64;
            int hash2 = (int)(hash64 >>> 32);
            boolean bitsChanged = false;
            for (int i = 1; i <= numHashFunctions; ++i) {
                int nextHash = hash1 + i * hash2;
                if (nextHash < 0) {
                    nextHash ^= 0xFFFFFFFF;
                }
                bitsChanged |= bits.set(nextHash % bits.bitSize());
            }
            return bitsChanged;
        }

        @Override
        public <T> boolean mightContain(T object, Funnel<? super T> funnel, int numHashFunctions, BitArray bits) {
            long hash64 = Hashing.murmur3_128().hashObject(object, funnel).asLong();
            int hash1 = (int)hash64;
            int hash2 = (int)(hash64 >>> 32);
            for (int i = 1; i <= numHashFunctions; ++i) {
                int nextHash = hash1 + i * hash2;
                if (nextHash < 0) {
                    nextHash ^= 0xFFFFFFFF;
                }
                if (bits.get(nextHash % bits.bitSize())) continue;
                return false;
            }
            return true;
        }
    };


    static class BitArray {
        final long[] data;
        int bitCount;

        BitArray(long bits) {
            this(new long[Ints.checkedCast(LongMath.divide(bits, 64L, RoundingMode.CEILING))]);
        }

        BitArray(long[] data2) {
            Preconditions.checkArgument(data2.length > 0, "data length is zero!");
            this.data = data2;
            int bitCount = 0;
            for (long value : data2) {
                bitCount += Long.bitCount(value);
            }
            this.bitCount = bitCount;
        }

        boolean set(int index2) {
            if (!this.get(index2)) {
                int n = index2 >> 6;
                this.data[n] = this.data[n] | 1L << index2;
                ++this.bitCount;
                return true;
            }
            return false;
        }

        boolean get(int index2) {
            return (this.data[index2 >> 6] & 1L << index2) != 0L;
        }

        int bitSize() {
            return this.data.length * 64;
        }

        int bitCount() {
            return this.bitCount;
        }

        BitArray copy() {
            return new BitArray((long[])this.data.clone());
        }

        void putAll(BitArray array2) {
            Preconditions.checkArgument(this.data.length == array2.data.length, "BitArrays must be of equal length (%s != %s)", this.data.length, array2.data.length);
            this.bitCount = 0;
            for (int i = 0; i < this.data.length; ++i) {
                int n = i;
                this.data[n] = this.data[n] | array2.data[i];
                this.bitCount += Long.bitCount(this.data[i]);
            }
        }

        public boolean equals(Object o) {
            if (o instanceof BitArray) {
                BitArray bitArray = (BitArray)o;
                return Arrays.equals(this.data, bitArray.data);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }
}

