/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.hash;

import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.hash.AbstractStreamingHashFunction;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.hash.Funnel;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.hash.HashCode;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.hash.HashFunction;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.hash.Hasher;
import java.nio.charset.Charset;

abstract class AbstractCompositeHashFunction
extends AbstractStreamingHashFunction {
    final HashFunction[] functions;
    private static final long serialVersionUID = 0L;

    AbstractCompositeHashFunction(HashFunction ... functions) {
        for (HashFunction function : functions) {
            Preconditions.checkNotNull(function);
        }
        this.functions = functions;
    }

    abstract HashCode makeHash(Hasher[] var1);

    @Override
    public Hasher newHasher() {
        final Hasher[] hashers = new Hasher[this.functions.length];
        for (int i = 0; i < hashers.length; ++i) {
            hashers[i] = this.functions[i].newHasher();
        }
        return new Hasher(){

            @Override
            public Hasher putByte(byte b) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putByte(b);
                }
                return this;
            }

            @Override
            public Hasher putBytes(byte[] bytes2) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putBytes(bytes2);
                }
                return this;
            }

            @Override
            public Hasher putBytes(byte[] bytes2, int off, int len) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putBytes(bytes2, off, len);
                }
                return this;
            }

            @Override
            public Hasher putShort(short s) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putShort(s);
                }
                return this;
            }

            @Override
            public Hasher putInt(int i) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putInt(i);
                }
                return this;
            }

            @Override
            public Hasher putLong(long l) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putLong(l);
                }
                return this;
            }

            @Override
            public Hasher putFloat(float f) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putFloat(f);
                }
                return this;
            }

            @Override
            public Hasher putDouble(double d) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putDouble(d);
                }
                return this;
            }

            @Override
            public Hasher putBoolean(boolean b) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putBoolean(b);
                }
                return this;
            }

            @Override
            public Hasher putChar(char c) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putChar(c);
                }
                return this;
            }

            @Override
            public Hasher putUnencodedChars(CharSequence chars2) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putUnencodedChars(chars2);
                }
                return this;
            }

            @Override
            public Hasher putString(CharSequence chars2, Charset charset) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putString(chars2, charset);
                }
                return this;
            }

            @Override
            public <T> Hasher putObject(T instance, Funnel<? super T> funnel) {
                for (Hasher hasher2 : hashers) {
                    hasher2.putObject(instance, funnel);
                }
                return this;
            }

            @Override
            public HashCode hash() {
                return AbstractCompositeHashFunction.this.makeHash(hashers);
            }
        };
    }
}

