/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.retry;

import io.mantisrx.shaded.org.apache.curator.RetryPolicy;
import io.mantisrx.shaded.org.apache.curator.RetrySleeper;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryForever
implements RetryPolicy {
    private static final Logger log = LoggerFactory.getLogger(RetryForever.class);
    private final int retryIntervalMs;

    public RetryForever(int retryIntervalMs) {
        Preconditions.checkArgument(retryIntervalMs > 0);
        this.retryIntervalMs = retryIntervalMs;
    }

    @Override
    public boolean allowRetry(int retryCount, long elapsedTimeMs, RetrySleeper sleeper) {
        try {
            sleeper.sleepFor(this.retryIntervalMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            log.warn("Error occurred while sleeping", e2);
            return false;
        }
        return true;
    }
}

