/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.imps;

import io.mantisrx.shaded.org.apache.curator.drivers.OperationTrace;
import io.mantisrx.shaded.org.apache.curator.framework.api.CuratorEventType;
import io.mantisrx.shaded.org.apache.curator.framework.api.ErrorListenerPathable;
import io.mantisrx.shaded.org.apache.curator.framework.imps.BackgroundOperation;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CreateBuilderImpl;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorEventImpl;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import io.mantisrx.shaded.org.apache.curator.framework.imps.OperationAndData;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import io.mantisrx.shaded.org.apache.curator.utils.ThreadUtils;
import io.mantisrx.shaded.org.apache.curator.utils.ZKPaths;
import io.mantisrx.shaded.org.apache.zookeeper.AsyncCallback;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.data.Stat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FindAndDeleteProtectedNodeInBackground
implements BackgroundOperation<Void> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFrameworkImpl client;
    private final String namespaceAdjustedParentPath;
    private final String protectedId;
    @VisibleForTesting
    static final AtomicBoolean debugInsertError = new AtomicBoolean(false);

    FindAndDeleteProtectedNodeInBackground(CuratorFrameworkImpl client, String namespaceAdjustedParentPath, String protectedId) {
        this.client = client;
        this.namespaceAdjustedParentPath = namespaceAdjustedParentPath;
        this.protectedId = protectedId;
    }

    void execute() {
        OperationAndData.ErrorCallback<Void> errorCallback = new OperationAndData.ErrorCallback<Void>(){

            @Override
            public void retriesExhausted(OperationAndData<Void> operationAndData) {
                operationAndData.reset();
                FindAndDeleteProtectedNodeInBackground.this.client.processBackgroundOperation(operationAndData, null);
            }
        };
        OperationAndData<Void> operationAndData = new OperationAndData<Void>(this, null, null, errorCallback, null);
        this.client.processBackgroundOperation(operationAndData, null);
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<Void> operationAndData) throws Exception {
        final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("FindAndDeleteProtectedNodeInBackground");
        AsyncCallback.Children2Callback callback = new AsyncCallback.Children2Callback(){

            @Override
            public void processResult(int rc, String path2, Object o, List<String> strings, Stat stat) {
                String node2;
                trace.setReturnCode(rc).setPath(path2).setStat(stat).commit();
                if (debugInsertError.compareAndSet(true, false)) {
                    rc = KeeperException.Code.CONNECTIONLOSS.intValue();
                }
                if (rc == KeeperException.Code.OK.intValue() && (node2 = CreateBuilderImpl.findNode(strings, "/", FindAndDeleteProtectedNodeInBackground.this.protectedId)) != null) {
                    try {
                        String deletePath = FindAndDeleteProtectedNodeInBackground.this.client.unfixForNamespace(ZKPaths.makePath(FindAndDeleteProtectedNodeInBackground.this.namespaceAdjustedParentPath, node2));
                        ((ErrorListenerPathable)FindAndDeleteProtectedNodeInBackground.this.client.delete().guaranteed().inBackground()).forPath(deletePath);
                    }
                    catch (Exception e2) {
                        ThreadUtils.checkInterrupted(e2);
                        FindAndDeleteProtectedNodeInBackground.this.log.error("Could not start guaranteed delete for node: " + node2);
                        rc = KeeperException.Code.CONNECTIONLOSS.intValue();
                    }
                }
                if (rc != KeeperException.Code.OK.intValue()) {
                    CuratorEventImpl event = new CuratorEventImpl(FindAndDeleteProtectedNodeInBackground.this.client, CuratorEventType.CHILDREN, rc, path2, null, o, stat, null, strings, null, null);
                    FindAndDeleteProtectedNodeInBackground.this.client.processBackgroundOperation(operationAndData, event);
                }
            }
        };
        this.client.getZooKeeper().getChildren(this.namespaceAdjustedParentPath, false, callback, null);
    }
}

