/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.jline;

import io.mantisrx.shaded.jline.Terminal;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.StringTokenizer;

public class UnixTerminal
extends Terminal {
    public static final short ARROW_START = 27;
    public static final short ARROW_PREFIX = 91;
    public static final short ARROW_LEFT = 68;
    public static final short ARROW_RIGHT = 67;
    public static final short ARROW_UP = 65;
    public static final short ARROW_DOWN = 66;
    public static final short O_PREFIX = 79;
    public static final short HOME_CODE = 72;
    public static final short END_CODE = 70;
    public static final short DEL_THIRD = 51;
    public static final short DEL_SECOND = 126;
    private Map terminfo;
    private boolean echoEnabled;
    private String ttyConfig;
    private boolean backspaceDeleteSwitched = false;
    private static String sttyCommand = System.getProperty("io.mantisrx.shaded.jline.sttyCommand", "stty");
    String encoding = System.getProperty("input.encoding", "UTF-8");
    ReplayPrefixOneCharInputStream replayStream = new ReplayPrefixOneCharInputStream(this.encoding);
    InputStreamReader replayReader;

    public UnixTerminal() {
        try {
            this.replayReader = new InputStreamReader((InputStream)this.replayStream, this.encoding);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    protected void checkBackspace() {
        String[] ttyConfigSplit = this.ttyConfig.split(":|=");
        if (ttyConfigSplit.length < 7) {
            return;
        }
        if (ttyConfigSplit[6] == null) {
            return;
        }
        this.backspaceDeleteSwitched = ttyConfigSplit[6].equals("7f");
    }

    public void initializeTerminal() throws IOException, InterruptedException {
        this.ttyConfig = UnixTerminal.stty("-g");
        if (this.ttyConfig.length() == 0 || this.ttyConfig.indexOf("=") == -1 && this.ttyConfig.indexOf(":") == -1) {
            throw new IOException("Unrecognized stty code: " + this.ttyConfig);
        }
        this.checkBackspace();
        UnixTerminal.stty("-icanon min 1");
        UnixTerminal.stty("-echo");
        this.echoEnabled = false;
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void start() {
                    try {
                        UnixTerminal.this.restoreTerminal();
                    }
                    catch (Exception e2) {
                        UnixTerminal.this.consumeException(e2);
                    }
                }
            });
        }
        catch (AbstractMethodError ame) {
            this.consumeException(ame);
        }
    }

    public void restoreTerminal() throws Exception {
        if (this.ttyConfig != null) {
            UnixTerminal.stty(this.ttyConfig);
            this.ttyConfig = null;
        }
        UnixTerminal.resetTerminal();
    }

    public int readVirtualKey(InputStream in) throws IOException {
        int c = this.readCharacter(in);
        if (this.backspaceDeleteSwitched) {
            if (c == 127) {
                c = 8;
            } else if (c == 8) {
                c = 127;
            }
        }
        if (c == 27) {
            while (c == 27) {
                c = this.readCharacter(in);
            }
            if (c == 91 || c == 79) {
                c = this.readCharacter(in);
                if (c == 65) {
                    return 16;
                }
                if (c == 66) {
                    return 14;
                }
                if (c == 68) {
                    return 2;
                }
                if (c == 67) {
                    return 6;
                }
                if (c == 72) {
                    return 1;
                }
                if (c == 70) {
                    return 5;
                }
                if (c == 51) {
                    c = this.readCharacter(in);
                    return 127;
                }
            }
        }
        if (c > 128) {
            this.replayStream.setInput(c, in);
            c = this.replayReader.read();
        }
        return c;
    }

    private void consumeException(Throwable e2) {
    }

    public boolean isSupported() {
        return true;
    }

    public boolean getEcho() {
        return false;
    }

    public int getTerminalWidth() {
        int val2 = -1;
        try {
            val2 = UnixTerminal.getTerminalProperty("columns");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (val2 == -1) {
            val2 = 80;
        }
        return val2;
    }

    public int getTerminalHeight() {
        int val2 = -1;
        try {
            val2 = UnixTerminal.getTerminalProperty("rows");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (val2 == -1) {
            val2 = 24;
        }
        return val2;
    }

    private static int getTerminalProperty(String prop) throws IOException, InterruptedException {
        String props = UnixTerminal.stty("-a");
        StringTokenizer tok = new StringTokenizer(props, ";\n");
        while (tok.hasMoreTokens()) {
            String str2 = tok.nextToken().trim();
            if (str2.startsWith(prop)) {
                int index2 = str2.lastIndexOf(" ");
                return Integer.parseInt(str2.substring(index2).trim());
            }
            if (!str2.endsWith(prop)) continue;
            int index3 = str2.indexOf(" ");
            return Integer.parseInt(str2.substring(0, index3).trim());
        }
        return -1;
    }

    private static String stty(String args) throws IOException, InterruptedException {
        return UnixTerminal.exec("stty " + args + " < /dev/tty").trim();
    }

    private static String exec(String cmd) throws IOException, InterruptedException {
        return UnixTerminal.exec(new String[]{"sh", "-c", cmd});
    }

    private static String exec(String[] cmd) throws IOException, InterruptedException {
        int c;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream in = p.getInputStream();
        while ((c = in.read()) != -1) {
            bout.write(c);
        }
        in = p.getErrorStream();
        while ((c = in.read()) != -1) {
            bout.write(c);
        }
        p.waitFor();
        String result = new String(bout.toByteArray());
        return result;
    }

    public static void setSttyCommand(String cmd) {
        sttyCommand = cmd;
    }

    public static String getSttyCommand() {
        return sttyCommand;
    }

    public synchronized boolean isEchoEnabled() {
        return this.echoEnabled;
    }

    public synchronized void enableEcho() {
        try {
            UnixTerminal.stty("echo");
            this.echoEnabled = true;
        }
        catch (Exception e2) {
            this.consumeException(e2);
        }
    }

    public synchronized void disableEcho() {
        try {
            UnixTerminal.stty("-echo");
            this.echoEnabled = false;
        }
        catch (Exception e2) {
            this.consumeException(e2);
        }
    }

    static class ReplayPrefixOneCharInputStream
    extends InputStream {
        byte firstByte;
        int byteLength;
        InputStream wrappedStream;
        int byteRead;
        final String encoding;

        public ReplayPrefixOneCharInputStream(String encoding2) {
            this.encoding = encoding2;
        }

        public void setInput(int recorded, InputStream wrapped) throws IOException {
            this.byteRead = 0;
            this.firstByte = (byte)recorded;
            this.wrappedStream = wrapped;
            this.byteLength = 1;
            if (this.encoding.equalsIgnoreCase("UTF-8")) {
                this.setInputUTF8(recorded, wrapped);
            } else if (this.encoding.equalsIgnoreCase("UTF-16")) {
                this.byteLength = 2;
            } else if (this.encoding.equalsIgnoreCase("UTF-32")) {
                this.byteLength = 4;
            }
        }

        public void setInputUTF8(int recorded, InputStream wrapped) throws IOException {
            if ((this.firstByte & 0xFFFFFFE0) == -64) {
                this.byteLength = 2;
            } else if ((this.firstByte & 0xFFFFFFF0) == -32) {
                this.byteLength = 3;
            } else if ((this.firstByte & 0xFFFFFFF8) == -16) {
                this.byteLength = 4;
            } else {
                throw new IOException("invalid UTF-8 first byte: " + this.firstByte);
            }
        }

        public int read() throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            ++this.byteRead;
            if (this.byteRead == 1) {
                return this.firstByte;
            }
            return this.wrappedStream.read();
        }

        public int available() {
            return this.byteLength - this.byteRead;
        }
    }
}

