/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.jline;

import io.mantisrx.shaded.jline.CompletionHandler;
import io.mantisrx.shaded.jline.ConsoleReader;
import io.mantisrx.shaded.jline.CursorBuffer;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class CandidateListCompletionHandler
implements CompletionHandler {
    private static ResourceBundle loc = ResourceBundle.getBundle((class$jline$CandidateListCompletionHandler == null ? (class$jline$CandidateListCompletionHandler = CandidateListCompletionHandler.class$("io.mantisrx.shaded.jline.CandidateListCompletionHandler")) : class$jline$CandidateListCompletionHandler).getName());
    private boolean eagerNewlines = true;
    static /* synthetic */ Class class$jline$CandidateListCompletionHandler;

    public void setAlwaysIncludeNewline(boolean eagerNewlines) {
        this.eagerNewlines = eagerNewlines;
    }

    public boolean complete(ConsoleReader reader2, List candidates, int pos) throws IOException {
        CursorBuffer buf = reader2.getCursorBuffer();
        if (candidates.size() == 1) {
            String value = candidates.get(0).toString();
            if (value.equals(buf.toString())) {
                return false;
            }
            CandidateListCompletionHandler.setBuffer(reader2, value, pos);
            return true;
        }
        if (candidates.size() > 1) {
            String value = this.getUnambiguousCompletions(candidates);
            String bufString = buf.toString();
            CandidateListCompletionHandler.setBuffer(reader2, value, pos);
        }
        if (this.eagerNewlines) {
            reader2.printNewline();
        }
        CandidateListCompletionHandler.printCandidates(reader2, candidates, this.eagerNewlines);
        reader2.drawLine();
        return true;
    }

    public static void setBuffer(ConsoleReader reader2, String value, int offset) throws IOException {
        while (reader2.getCursorBuffer().cursor > offset && reader2.backspace()) {
        }
        reader2.putString(value);
        reader2.setCursorPosition(offset + value.length());
    }

    public static final void printCandidates(ConsoleReader reader2, Collection candidates, boolean eagerNewlines) throws IOException {
        HashSet distinct2 = new HashSet(candidates);
        if (distinct2.size() > reader2.getAutoprintThreshhold()) {
            int c;
            if (!eagerNewlines) {
                reader2.printNewline();
            }
            reader2.printString(MessageFormat.format(loc.getString("display-candidates"), new Integer(candidates.size())) + " ");
            reader2.flushConsole();
            String noOpt = loc.getString("display-candidates-no");
            String yesOpt = loc.getString("display-candidates-yes");
            while ((c = reader2.readCharacter(new char[]{yesOpt.charAt(0), noOpt.charAt(0)})) != -1) {
                if (noOpt.startsWith(new String(new char[]{(char)c}))) {
                    reader2.printNewline();
                    return;
                }
                if (yesOpt.startsWith(new String(new char[]{(char)c}))) break;
                reader2.beep();
            }
        }
        if (distinct2.size() != candidates.size()) {
            ArrayList copy2 = new ArrayList();
            Iterator i = candidates.iterator();
            while (i.hasNext()) {
                Object next2 = i.next();
                if (copy2.contains(next2)) continue;
                copy2.add(next2);
            }
            candidates = copy2;
        }
        reader2.printNewline();
        reader2.printColumns(candidates);
    }

    private final String getUnambiguousCompletions(List candidates) {
        if (candidates == null || candidates.size() == 0) {
            return null;
        }
        String[] strings = candidates.toArray(new String[candidates.size()]);
        String first2 = strings[0];
        StringBuffer candidate = new StringBuffer();
        for (int i = 0; i < first2.length() && this.startsWith(first2.substring(0, i + 1), strings); ++i) {
            candidate.append(first2.charAt(i));
        }
        return candidate.toString();
    }

    private final boolean startsWith(String starts, String[] candidates) {
        for (int i = 0; i < candidates.length; ++i) {
            if (candidates[i].startsWith(starts)) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

