/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.google.common.primitives;

import io.mantisrx.shaded.com.google.common.annotations.Beta;
import io.mantisrx.shaded.com.google.common.annotations.GwtIncompatible;
import io.mantisrx.shaded.com.google.common.annotations.VisibleForTesting;
import io.mantisrx.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.com.google.common.primitives.ElementTypesAreNonnullByDefault;
import io.mantisrx.shaded.com.google.common.primitives.UnsignedLongs;
import io.mantisrx.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import sun.misc.Unsafe;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class UnsignedBytes {
    public static final byte MAX_POWER_OF_TWO = -128;
    public static final byte MAX_VALUE = -1;
    private static final int UNSIGNED_MASK = 255;

    private UnsignedBytes() {
    }

    public static int toInt(byte value) {
        return value & 0xFF;
    }

    @CanIgnoreReturnValue
    public static byte checkedCast(long value) {
        Preconditions.checkArgument(value >> 8 == 0L, "out of range: %s", value);
        return (byte)value;
    }

    public static byte saturatedCast(long value) {
        if (value > (long)UnsignedBytes.toInt((byte)-1)) {
            return -1;
        }
        if (value < 0L) {
            return 0;
        }
        return (byte)value;
    }

    public static int compare(byte a, byte b) {
        return UnsignedBytes.toInt(a) - UnsignedBytes.toInt(b);
    }

    public static byte min(byte ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        int min2 = UnsignedBytes.toInt(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            int next2 = UnsignedBytes.toInt(array2[i]);
            if (next2 >= min2) continue;
            min2 = next2;
        }
        return (byte)min2;
    }

    public static byte max(byte ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        int max2 = UnsignedBytes.toInt(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            int next2 = UnsignedBytes.toInt(array2[i]);
            if (next2 <= max2) continue;
            max2 = next2;
        }
        return (byte)max2;
    }

    @Beta
    public static String toString(byte x) {
        return UnsignedBytes.toString(x, 10);
    }

    @Beta
    public static String toString(byte x, int radix) {
        Preconditions.checkArgument(radix >= 2 && radix <= 36, "radix (%s) must be between Character.MIN_RADIX and Character.MAX_RADIX", radix);
        return Integer.toString(UnsignedBytes.toInt(x), radix);
    }

    @Beta
    @CanIgnoreReturnValue
    public static byte parseUnsignedByte(String string2) {
        return UnsignedBytes.parseUnsignedByte(string2, 10);
    }

    @Beta
    @CanIgnoreReturnValue
    public static byte parseUnsignedByte(String string2, int radix) {
        int parse2 = Integer.parseInt(Preconditions.checkNotNull(string2), radix);
        if (parse2 >> 8 == 0) {
            return (byte)parse2;
        }
        throw new NumberFormatException(new StringBuilder(25).append("out of range: ").append(parse2).toString());
    }

    public static String join(String separator, byte ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * (3 + separator.length()));
        builder.append(UnsignedBytes.toInt(array2[0]));
        for (int i = 1; i < array2.length; ++i) {
            builder.append(separator).append(UnsignedBytes.toString(array2[i]));
        }
        return builder.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparatorHolder.BEST_COMPARATOR;
    }

    @VisibleForTesting
    static Comparator<byte[]> lexicographicalComparatorJavaImpl() {
        return LexicographicalComparatorHolder.PureJavaComparator.INSTANCE;
    }

    private static byte flip(byte b) {
        return (byte)(b ^ 0x80);
    }

    public static void sort(byte[] array2) {
        Preconditions.checkNotNull(array2);
        UnsignedBytes.sort(array2, 0, array2.length);
    }

    public static void sort(byte[] array2, int fromIndex, int toIndex) {
        int i;
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        for (i = fromIndex; i < toIndex; ++i) {
            array2[i] = UnsignedBytes.flip(array2[i]);
        }
        Arrays.sort(array2, fromIndex, toIndex);
        for (i = fromIndex; i < toIndex; ++i) {
            array2[i] = UnsignedBytes.flip(array2[i]);
        }
    }

    public static void sortDescending(byte[] array2) {
        Preconditions.checkNotNull(array2);
        UnsignedBytes.sortDescending(array2, 0, array2.length);
    }

    public static void sortDescending(byte[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        int i = fromIndex;
        while (i < toIndex) {
            int n = i++;
            array2[n] = (byte)(array2[n] ^ 0x7F);
        }
        Arrays.sort(array2, fromIndex, toIndex);
        i = fromIndex;
        while (i < toIndex) {
            int n = i++;
            array2[n] = (byte)(array2[n] ^ 0x7F);
        }
    }

    @VisibleForTesting
    static class LexicographicalComparatorHolder {
        static final String UNSAFE_COMPARATOR_NAME = String.valueOf(LexicographicalComparatorHolder.class.getName()).concat("$UnsafeComparator");
        static final Comparator<byte[]> BEST_COMPARATOR = LexicographicalComparatorHolder.getBestComparator();

        LexicographicalComparatorHolder() {
        }

        static Comparator<byte[]> getBestComparator() {
            try {
                Class<?> theClass = Class.forName(UNSAFE_COMPARATOR_NAME);
                ?[] constants = Objects.requireNonNull(theClass.getEnumConstants());
                Comparator comparator2 = (Comparator)constants[0];
                return comparator2;
            }
            catch (Throwable t) {
                return UnsignedBytes.lexicographicalComparatorJavaImpl();
            }
        }

        static enum PureJavaComparator implements Comparator<byte[]>
        {
            INSTANCE;


            @Override
            public int compare(byte[] left2, byte[] right2) {
                int minLength = Math.min(left2.length, right2.length);
                for (int i = 0; i < minLength; ++i) {
                    int result = UnsignedBytes.compare(left2[i], right2[i]);
                    if (result == 0) continue;
                    return result;
                }
                return left2.length - right2.length;
            }

            public String toString() {
                return "UnsignedBytes.lexicographicalComparator() (pure Java version)";
            }
        }

        @VisibleForTesting
        static enum UnsafeComparator implements Comparator<byte[]>
        {
            INSTANCE;

            static final boolean BIG_ENDIAN;
            static final Unsafe theUnsafe;
            static final int BYTE_ARRAY_BASE_OFFSET;

            private static Unsafe getUnsafe() {
                try {
                    return Unsafe.getUnsafe();
                }
                catch (SecurityException securityException) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                            @Override
                            public Unsafe run() throws Exception {
                                Class<Unsafe> k = Unsafe.class;
                                for (Field f : k.getDeclaredFields()) {
                                    f.setAccessible(true);
                                    Object x = f.get(null);
                                    if (!k.isInstance(x)) continue;
                                    return (Unsafe)k.cast(x);
                                }
                                throw new NoSuchFieldError("the Unsafe");
                            }
                        });
                    }
                    catch (PrivilegedActionException e2) {
                        throw new RuntimeException("Could not initialize intrinsics", e2.getCause());
                    }
                }
            }

            @Override
            public int compare(byte[] left2, byte[] right2) {
                int i;
                int stride = 8;
                int minLength = Math.min(left2.length, right2.length);
                int strideLimit = minLength & ~(stride - 1);
                for (i = 0; i < strideLimit; i += stride) {
                    long rw;
                    long lw = theUnsafe.getLong(left2, (long)BYTE_ARRAY_BASE_OFFSET + (long)i);
                    if (lw == (rw = theUnsafe.getLong(right2, (long)BYTE_ARRAY_BASE_OFFSET + (long)i))) continue;
                    if (BIG_ENDIAN) {
                        return UnsignedLongs.compare(lw, rw);
                    }
                    int n = Long.numberOfTrailingZeros(lw ^ rw) & 0xFFFFFFF8;
                    return (int)(lw >>> n & 0xFFL) - (int)(rw >>> n & 0xFFL);
                }
                while (i < minLength) {
                    int result = UnsignedBytes.compare(left2[i], right2[i]);
                    if (result != 0) {
                        return result;
                    }
                    ++i;
                }
                return left2.length - right2.length;
            }

            public String toString() {
                return "UnsignedBytes.lexicographicalComparator() (sun.misc.Unsafe version)";
            }

            static {
                BIG_ENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
                theUnsafe = UnsafeComparator.getUnsafe();
                BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
                if (!"64".equals(System.getProperty("sun.arch.data.model")) || BYTE_ARRAY_BASE_OFFSET % 8 != 0 || theUnsafe.arrayIndexScale(byte[].class) != 1) {
                    throw new Error();
                }
            }
        }
    }
}

