/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.google.common.graph;

import io.mantisrx.shaded.com.google.common.annotations.Beta;
import io.mantisrx.shaded.com.google.common.base.Function;
import io.mantisrx.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.com.google.common.collect.ImmutableMap;
import io.mantisrx.shaded.com.google.common.collect.Maps;
import io.mantisrx.shaded.com.google.common.graph.DirectedGraphConnections;
import io.mantisrx.shaded.com.google.common.graph.ElementOrder;
import io.mantisrx.shaded.com.google.common.graph.ElementTypesAreNonnullByDefault;
import io.mantisrx.shaded.com.google.common.graph.EndpointPair;
import io.mantisrx.shaded.com.google.common.graph.GraphConnections;
import io.mantisrx.shaded.com.google.common.graph.ImmutableGraph;
import io.mantisrx.shaded.com.google.common.graph.MutableValueGraph;
import io.mantisrx.shaded.com.google.common.graph.StandardValueGraph;
import io.mantisrx.shaded.com.google.common.graph.UndirectedGraphConnections;
import io.mantisrx.shaded.com.google.common.graph.ValueGraph;
import io.mantisrx.shaded.com.google.common.graph.ValueGraphBuilder;
import io.mantisrx.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.mantisrx.shaded.com.google.errorprone.annotations.Immutable;
import java.util.Objects;

@Immutable(containerOf={"N", "V"})
@ElementTypesAreNonnullByDefault
@Beta
public final class ImmutableValueGraph<N, V>
extends StandardValueGraph<N, V> {
    private ImmutableValueGraph(ValueGraph<N, V> graph2) {
        super(ValueGraphBuilder.from(graph2), ImmutableValueGraph.getNodeConnections(graph2), graph2.edges().size());
    }

    public static <N, V> ImmutableValueGraph<N, V> copyOf(ValueGraph<N, V> graph2) {
        return graph2 instanceof ImmutableValueGraph ? (ImmutableValueGraph<N, V>)graph2 : new ImmutableValueGraph<N, V>(graph2);
    }

    @Deprecated
    public static <N, V> ImmutableValueGraph<N, V> copyOf(ImmutableValueGraph<N, V> graph2) {
        return Preconditions.checkNotNull(graph2);
    }

    @Override
    public ElementOrder<N> incidentEdgeOrder() {
        return ElementOrder.stable();
    }

    @Override
    public ImmutableGraph<N> asGraph() {
        return new ImmutableGraph(this);
    }

    private static <N, V> ImmutableMap<N, GraphConnections<N, V>> getNodeConnections(ValueGraph<N, V> graph2) {
        ImmutableMap.Builder<N, GraphConnections<N, V>> nodeConnections = ImmutableMap.builder();
        for (N node2 : graph2.nodes()) {
            nodeConnections.put(node2, ImmutableValueGraph.connectionsOf(graph2, node2));
        }
        return nodeConnections.buildOrThrow();
    }

    private static <N, V> GraphConnections<N, V> connectionsOf(ValueGraph<N, V> graph2, N node2) {
        Function successorNodeToValueFn = successorNode -> Objects.requireNonNull(graph2.edgeValueOrDefault(node2, successorNode, null));
        return graph2.isDirected() ? DirectedGraphConnections.ofImmutable(node2, graph2.incidentEdges(node2), successorNodeToValueFn) : UndirectedGraphConnections.ofImmutable(Maps.asMap(graph2.adjacentNodes(node2), successorNodeToValueFn));
    }

    public static class Builder<N, V> {
        private final MutableValueGraph<N, V> mutableValueGraph;

        Builder(ValueGraphBuilder<N, V> graphBuilder) {
            this.mutableValueGraph = graphBuilder.copy().incidentEdgeOrder(ElementOrder.stable()).build();
        }

        @CanIgnoreReturnValue
        public Builder<N, V> addNode(N node2) {
            this.mutableValueGraph.addNode(node2);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<N, V> putEdgeValue(N nodeU, N nodeV, V value) {
            this.mutableValueGraph.putEdgeValue(nodeU, nodeV, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<N, V> putEdgeValue(EndpointPair<N> endpoints, V value) {
            this.mutableValueGraph.putEdgeValue(endpoints, value);
            return this;
        }

        public ImmutableValueGraph<N, V> build() {
            return ImmutableValueGraph.copyOf(this.mutableValueGraph);
        }
    }
}

