/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.fasterxml.jackson.datatype.jsr310.deser;

import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonFormat;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonParser;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonToken;
import io.mantisrx.shaded.com.fasterxml.jackson.core.StreamReadCapability;
import io.mantisrx.shaded.com.fasterxml.jackson.core.io.NumberInput;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.BeanProperty;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import io.mantisrx.shaded.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import io.mantisrx.shaded.com.fasterxml.jackson.datatype.jsr310.util.DurationUnitConverter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Duration;

public class DurationDeserializer
extends JSR310DeserializerBase<Duration>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    public static final DurationDeserializer INSTANCE = new DurationDeserializer();
    protected final DurationUnitConverter _durationUnitConverter;

    public DurationDeserializer() {
        super(Duration.class);
        this._durationUnitConverter = null;
    }

    protected DurationDeserializer(DurationDeserializer base, Boolean leniency) {
        super(base, leniency);
        this._durationUnitConverter = base._durationUnitConverter;
    }

    protected DurationDeserializer(DurationDeserializer base, DurationUnitConverter converter) {
        super(base, (Boolean)base._isLenient);
        this._durationUnitConverter = converter;
    }

    protected DurationDeserializer withLeniency(Boolean leniency) {
        return new DurationDeserializer(this, leniency);
    }

    protected DurationDeserializer withConverter(DurationUnitConverter converter) {
        return new DurationDeserializer(this, converter);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format2 = this.findFormatOverrides(ctxt, property, this.handledType());
        DurationDeserializer deser = this;
        if (format2 != null) {
            Boolean leniency;
            if (format2.hasLenient() && (leniency = format2.getLenient()) != null) {
                deser = deser.withLeniency(leniency);
            }
            if (format2.hasPattern()) {
                String pattern = format2.getPattern();
                DurationUnitConverter p = DurationUnitConverter.from(pattern);
                if (p == null) {
                    ctxt.reportBadDefinition(this.getValueType(ctxt), String.format("Bad 'pattern' definition (\"%s\") for `Duration`: expected one of [%s]", pattern, DurationUnitConverter.descForAllowed()));
                }
                deser = deser.withConverter(p);
            }
        }
        return deser;
    }

    @Override
    public Duration deserialize(JsonParser parser2, DeserializationContext context) throws IOException {
        switch (parser2.currentTokenId()) {
            case 8: {
                BigDecimal value = parser2.getDecimalValue();
                return DecimalUtils.extractSecondsAndNanos(value, Duration::ofSeconds);
            }
            case 7: {
                return this._fromTimestamp(context, parser2.getLongValue());
            }
            case 6: {
                return this._fromString(parser2, context, parser2.getText());
            }
            case 1: {
                return this._fromString(parser2, context, context.extractScalarFromObject(parser2, this, this.handledType()));
            }
            case 12: {
                return (Duration)parser2.getEmbeddedObject();
            }
            case 3: {
                return (Duration)this._deserializeFromArray(parser2, context);
            }
        }
        return (Duration)this._handleUnexpectedToken(context, parser2, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT);
    }

    protected Duration _fromString(JsonParser parser2, DeserializationContext ctxt, String value0) throws IOException {
        String value = value0.trim();
        if (value.length() == 0) {
            return (Duration)this._fromEmptyString(parser2, ctxt, value);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value)) {
            return this._fromTimestamp(ctxt, NumberInput.parseLong(value));
        }
        try {
            return Duration.parse(value);
        }
        catch (DateTimeException e2) {
            return (Duration)this._handleDateTimeException(ctxt, e2, value);
        }
    }

    protected Duration _fromTimestamp(DeserializationContext ctxt, long ts) {
        if (this._durationUnitConverter != null) {
            return this._durationUnitConverter.convert(ts);
        }
        if (ctxt.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
            return Duration.ofSeconds(ts);
        }
        return Duration.ofMillis(ts);
    }
}

