/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.source.http.impl;

import io.mantisrx.runtime.source.http.impl.ResumeOnErrorPolicy;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.schedulers.Schedulers;
import rx.subscriptions.SerialSubscription;

public class OperatorResumeOnError<T>
implements Observable.Operator<T, T> {
    private static Scheduler scheduler = Schedulers.trampoline();
    private final ResumeOnErrorPolicy<T> resumePolicy;
    private final int currentAttempts;

    private OperatorResumeOnError(int currentAttempts, ResumeOnErrorPolicy<T> resumePolicy) {
        this.currentAttempts = currentAttempts;
        this.resumePolicy = resumePolicy;
    }

    public OperatorResumeOnError(ResumeOnErrorPolicy<T> resumePolicy) {
        this(0, resumePolicy);
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        final SerialSubscription serialSubscription = new SerialSubscription();
        child.add(serialSubscription);
        return new Subscriber<T>(child){
            private final Scheduler.Worker worker;
            {
                super(x0);
                this.worker = scheduler.createWorker();
            }

            @Override
            public void onCompleted() {
                child.onCompleted();
            }

            @Override
            public void onError(final Throwable e2) {
                this.worker.schedule(new Action0(){

                    @Override
                    public void call() {
                        try {
                            int newAttempts = OperatorResumeOnError.this.currentAttempts + 1;
                            Observable<Object> resume = OperatorResumeOnError.this.resumePolicy.call(newAttempts, e2);
                            if (resume == null) {
                                child.onError(e2);
                            } else {
                                resume = resume.lift(new OperatorResumeOnError(newAttempts, OperatorResumeOnError.this.resumePolicy));
                                serialSubscription.set(resume.unsafeSubscribe(child));
                            }
                        }
                        catch (Throwable e22) {
                            child.onError(e22);
                        }
                    }
                });
            }

            @Override
            public void onNext(T t) {
                child.onNext(t);
            }
        };
    }
}

