/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.source.http.impl;

import io.mantisrx.runtime.source.http.impl.ResumeOnCompletedPolicy;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.schedulers.Schedulers;
import rx.subscriptions.SerialSubscription;

public class OperatorResumeOnCompleted<T>
implements Observable.Operator<T, T> {
    private static Scheduler scheduler = Schedulers.trampoline();
    private final ResumeOnCompletedPolicy<T> resumePolicy;
    private final int currentAttempts;

    private OperatorResumeOnCompleted(int currentAttempts, ResumeOnCompletedPolicy<T> resumePolicy) {
        this.currentAttempts = currentAttempts;
        this.resumePolicy = resumePolicy;
    }

    public OperatorResumeOnCompleted(ResumeOnCompletedPolicy<T> resumePolicy) {
        this(0, resumePolicy);
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        final SerialSubscription serialSubscription = new SerialSubscription();
        child.add(serialSubscription);
        return new Subscriber<T>(child){
            private final Scheduler.Worker worker;
            {
                super(x0);
                this.worker = scheduler.createWorker();
            }

            @Override
            public void onCompleted() {
                this.worker.schedule(new Action0(){

                    @Override
                    public void call() {
                        try {
                            int newAttempts = OperatorResumeOnCompleted.this.currentAttempts + 1;
                            Observable<Object> resume = OperatorResumeOnCompleted.this.resumePolicy.call(newAttempts);
                            if (resume == null) {
                                child.onCompleted();
                            } else {
                                resume = resume.lift(new OperatorResumeOnCompleted(newAttempts, OperatorResumeOnCompleted.this.resumePolicy));
                                serialSubscription.set(resume.unsafeSubscribe(child));
                            }
                        }
                        catch (Throwable e2) {
                            child.onError(e2);
                        }
                    }
                });
            }

            @Override
            public void onError(Throwable e2) {
                child.onError(e2);
            }

            @Override
            public void onNext(T t) {
                child.onNext(t);
            }
        };
    }
}

