/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.command;

import io.mantisrx.runtime.command.Command;
import io.mantisrx.runtime.command.CommandException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class CreateZipFile
implements Command {
    private File jobJarFile;
    private File jobDescriptor;
    private File zipfileName;

    public CreateZipFile(File zipfileName, File jobJarFile, File jobDescriptor) {
        this.zipfileName = zipfileName;
        this.jobJarFile = jobJarFile;
        this.jobDescriptor = jobDescriptor;
    }

    private void readBytesFromFile(File file2, ZipOutputStream os) throws CommandException {
        BufferedInputStream is2 = null;
        try {
            is2 = new BufferedInputStream(Files.newInputStream(Paths.get(file2.toURI()), new OpenOption[0]));
            byte[] in = new byte[1024];
            int bytesRead = -1;
            while ((bytesRead = is2.read(in)) > 0) {
                os.write(in, 0, bytesRead);
            }
        }
        catch (IOException e2) {
            throw new CommandException(e2);
        }
        finally {
            try {
                is2.close();
            }
            catch (IOException e3) {
                throw new CommandException(e3);
            }
        }
    }

    @Override
    public void execute() throws CommandException {
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.zipfileName)));
            ZipEntry jobJarEntry = new ZipEntry(this.jobJarFile.getName());
            out.putNextEntry(jobJarEntry);
            this.readBytesFromFile(this.jobJarFile, out);
            out.closeEntry();
            ZipEntry jobDescriptorEntry = new ZipEntry(this.jobDescriptor.getName());
            out.putNextEntry(jobDescriptorEntry);
            this.readBytesFromFile(this.jobDescriptor, out);
            out.closeEntry();
        }
        catch (IOException e2) {
            throw new CommandException(e2);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e3) {
                    throw new CommandException(e3);
                }
            }
        }
    }
}

