/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime;

import io.mantisrx.common.MantisGroup;
import io.reactivx.mantis.operators.GroupedObservableUtils;
import rx.Observable;
import rx.functions.Func1;
import rx.observables.GroupedObservable;

public class Groups {
    private Groups() {
    }

    public static <K, T> Observable<GroupedObservable<K, T>> flatten(Observable<Observable<GroupedObservable<K, T>>> groups) {
        Observable<GroupedObservable<K, T>> flattenedGroups = Observable.merge(groups);
        return flattenedGroups.groupBy(new Func1<GroupedObservable<K, T>, K>(){

            @Override
            public K call(GroupedObservable<K, T> group) {
                return group.getKey();
            }
        }).flatMap(new Func1<GroupedObservable<K, GroupedObservable<K, T>>, Observable<GroupedObservable<K, T>>>(){

            @Override
            public Observable<GroupedObservable<K, T>> call(GroupedObservable<K, GroupedObservable<K, T>> groups) {
                return Observable.just(GroupedObservableUtils.createGroupedObservable(groups.getKey(), Observable.merge(groups)));
            }
        });
    }

    public static <K, T> Observable<GroupedObservable<K, T>> flattenMantisGroupsToGroupedObservables(Observable<Observable<MantisGroup<K, T>>> groups) {
        Observable<MantisGroup<K, T>> flattenedGroups = Observable.merge(groups);
        return flattenedGroups.groupBy(new Func1<MantisGroup<K, T>, K>(){

            @Override
            public K call(MantisGroup<K, T> t) {
                return t.getKeyValue();
            }
        }, new Func1<MantisGroup<K, T>, T>(){

            @Override
            public T call(MantisGroup<K, T> t) {
                return t.getValue();
            }
        });
    }
}

