/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.codec;

import io.mantisrx.common.codec.Codec;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.mantisrx.shaded.com.fasterxml.jackson.core.type.TypeReference;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectReader;
import io.mantisrx.shaded.com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import io.mantisrx.shaded.com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class JacksonCodecs {
    private static final ObjectMapper mapper = new ObjectMapper(new CBORFactory());

    public static <T> Codec<T> pojo(final Class<T> clazz) {
        return new Codec<T>(){

            @Override
            public byte[] encode(T value) {
                try {
                    return mapper.writeValueAsBytes(value);
                }
                catch (JsonProcessingException e2) {
                    throw new RuntimeException("Failed to write bytes for value: " + value, e2);
                }
            }

            @Override
            public T decode(byte[] bytes2) {
                try {
                    return mapper.readValue(bytes2, clazz);
                }
                catch (IOException e2) {
                    throw new RuntimeException("Failed to convert to type: " + clazz.toString(), e2);
                }
            }
        };
    }

    public static <T> Codec<List<T>> list() {
        return new Codec<List<T>>(){

            @Override
            public byte[] encode(List<T> value) {
                try {
                    return mapper.writeValueAsBytes(value);
                }
                catch (JsonProcessingException e2) {
                    throw new RuntimeException("Failed to write list to bytes", e2);
                }
            }

            @Override
            public List<T> decode(byte[] bytes2) {
                try {
                    return (List)mapper.readValue(bytes2, new TypeReference<List<T>>(){});
                }
                catch (IOException e2) {
                    throw new RuntimeException("Failed to convert bytes to list", e2);
                }
            }
        };
    }

    public static Codec<Map<String, Object>> mapStringObject() {
        return new Codec<Map<String, Object>>(){
            private final ObjectReader reader = JacksonCodecs.access$000().readerFor(Map.class);

            @Override
            public byte[] encode(Map<String, Object> map2) {
                try {
                    return mapper.writeValueAsBytes(map2);
                }
                catch (IOException e2) {
                    throw new RuntimeException("Failed to write bytes for map: " + map2, e2);
                }
            }

            @Override
            public Map<String, Object> decode(byte[] bytes2) {
                try {
                    return (Map)this.reader.readValue(bytes2);
                }
                catch (IOException e2) {
                    throw new RuntimeException("Failed to convert bytes to map", e2);
                }
            }
        };
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule(new AfterburnerModule());
    }
}

