/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.channel.socket.nio;

import io.mantisrx.shaded.org.jboss.netty.channel.Channel;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFuture;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelPipeline;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelState;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelStateEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.MessageEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.nio.AbstractNioChannelSink;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.nio.NioServerBoss;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.nio.NioServerSocketChannel;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.nio.NioSocketChannel;
import java.net.SocketAddress;

class NioServerSocketPipelineSink
extends AbstractNioChannelSink {
    NioServerSocketPipelineSink() {
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e2) throws Exception {
        Channel channel = e2.getChannel();
        if (channel instanceof NioServerSocketChannel) {
            NioServerSocketPipelineSink.handleServerSocket(e2);
        } else if (channel instanceof NioSocketChannel) {
            NioServerSocketPipelineSink.handleAcceptedSocket(e2);
        }
    }

    private static void handleServerSocket(ChannelEvent e2) {
        if (!(e2 instanceof ChannelStateEvent)) {
            return;
        }
        ChannelStateEvent event = (ChannelStateEvent)e2;
        NioServerSocketChannel channel = (NioServerSocketChannel)event.getChannel();
        ChannelFuture future2 = event.getFuture();
        ChannelState state = event.getState();
        Object value = event.getValue();
        switch (state) {
            case OPEN: {
                if (!Boolean.FALSE.equals(value)) break;
                ((NioServerBoss)channel.boss).close(channel, future2);
                break;
            }
            case BOUND: {
                if (value != null) {
                    ((NioServerBoss)channel.boss).bind(channel, future2, (SocketAddress)value);
                    break;
                }
                ((NioServerBoss)channel.boss).close(channel, future2);
                break;
            }
        }
    }

    private static void handleAcceptedSocket(ChannelEvent e2) {
        if (e2 instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e2;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            ChannelFuture future2 = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    channel.worker.close(channel, future2);
                    break;
                }
                case BOUND: 
                case CONNECTED: {
                    if (value != null) break;
                    channel.worker.close(channel, future2);
                    break;
                }
                case INTEREST_OPS: {
                    channel.worker.setInterestOps(channel, future2, (Integer)value);
                }
            }
        } else if (e2 instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e2;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            boolean offered = channel.writeBufferQueue.offer(event);
            assert (offered);
            channel.worker.writeFromUserCode(channel);
        }
    }
}

