/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.vavr.jackson.datatype.serialize;

import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonGenerator;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JavaType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;

abstract class ValueSerializer<T>
extends StdSerializer<T> {
    private static final long serialVersionUID = 1L;
    JavaType type;

    ValueSerializer(JavaType type2) {
        super(type2);
        this.type = type2;
    }

    abstract Object toJavaObj(T var1) throws IOException;

    abstract JavaType emulatedJavaType(JavaType var1, TypeFactory var2);

    @Override
    public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Object obj = this.toJavaObj(value);
        if (obj == null) {
            provider.getDefaultNullValueSerializer().serialize(null, gen, provider);
        } else {
            JsonSerializer<Object> ser;
            try {
                JavaType emulated = this.emulatedJavaType(this.type, provider.getTypeFactory());
                ser = emulated.getRawClass() != Object.class ? provider.findTypedValueSerializer(emulated, true, null) : provider.findTypedValueSerializer(obj.getClass(), true, null);
            }
            catch (Exception ignore) {
                ser = provider.findTypedValueSerializer(obj.getClass(), true, null);
            }
            ser.serialize(obj, gen, provider);
        }
    }

    @Override
    public void serializeWithType(T value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForScalar(value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForScalar(value, gen);
    }
}

