/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.google.common.util.concurrent;

import io.mantisrx.shaded.com.google.common.annotations.GwtIncompatible;
import io.mantisrx.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import io.mantisrx.shaded.com.google.common.util.concurrent.FluentFuture;
import io.mantisrx.shaded.com.google.common.util.concurrent.ListenableFuture;
import io.mantisrx.shaded.com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
final class TimeoutFuture<V>
extends FluentFuture.TrustedFuture<V> {
    @CheckForNull
    private ListenableFuture<V> delegateRef;
    @CheckForNull
    private ScheduledFuture<?> timer;

    static <V> ListenableFuture<V> create(ListenableFuture<V> delegate, long time2, TimeUnit unit, ScheduledExecutorService scheduledExecutor) {
        TimeoutFuture<V> result = new TimeoutFuture<V>(delegate);
        Fire<V> fire = new Fire<V>(result);
        result.timer = scheduledExecutor.schedule(fire, time2, unit);
        delegate.addListener(fire, MoreExecutors.directExecutor());
        return result;
    }

    private TimeoutFuture(ListenableFuture<V> delegate) {
        this.delegateRef = Preconditions.checkNotNull(delegate);
    }

    @Override
    @CheckForNull
    protected String pendingToString() {
        ListenableFuture<V> localInputFuture = this.delegateRef;
        ScheduledFuture<?> localTimer = this.timer;
        if (localInputFuture != null) {
            long delay2;
            String string2 = String.valueOf(localInputFuture);
            String message = new StringBuilder(14 + String.valueOf(string2).length()).append("inputFuture=[").append(string2).append("]").toString();
            if (localTimer != null && (delay2 = localTimer.getDelay(TimeUnit.MILLISECONDS)) > 0L) {
                String string3 = String.valueOf(message);
                message = new StringBuilder(43 + String.valueOf(string3).length()).append(string3).append(", remaining delay=[").append(delay2).append(" ms]").toString();
            }
            return message;
        }
        return null;
    }

    @Override
    protected void afterDone() {
        this.maybePropagateCancellationTo(this.delegateRef);
        ScheduledFuture<?> localTimer = this.timer;
        if (localTimer != null) {
            localTimer.cancel(false);
        }
        this.delegateRef = null;
        this.timer = null;
    }

    private static final class TimeoutFutureException
    extends TimeoutException {
        private TimeoutFutureException(String message) {
            super(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            this.setStackTrace(new StackTraceElement[0]);
            return this;
        }
    }

    private static final class Fire<V>
    implements Runnable {
        @CheckForNull
        TimeoutFuture<V> timeoutFutureRef;

        Fire(TimeoutFuture<V> timeoutFuture) {
            this.timeoutFutureRef = timeoutFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TimeoutFuture<V> timeoutFuture = this.timeoutFutureRef;
            if (timeoutFuture == null) {
                return;
            }
            ListenableFuture delegate = ((TimeoutFuture)timeoutFuture).delegateRef;
            if (delegate == null) {
                return;
            }
            this.timeoutFutureRef = null;
            if (delegate.isDone()) {
                timeoutFuture.setFuture(delegate);
            } else {
                try {
                    ScheduledFuture timer = ((TimeoutFuture)timeoutFuture).timer;
                    ((TimeoutFuture)timeoutFuture).timer = null;
                    String message = "Timed out";
                    try {
                        long overDelayMs;
                        if (timer != null && (overDelayMs = Math.abs(timer.getDelay(TimeUnit.MILLISECONDS))) > 10L) {
                            String string2 = String.valueOf(message);
                            message = new StringBuilder(66 + String.valueOf(string2).length()).append(string2).append(" (timeout delayed by ").append(overDelayMs).append(" ms after scheduled time)").toString();
                        }
                        String string3 = String.valueOf(message);
                        String string4 = String.valueOf(delegate);
                        message = new StringBuilder(2 + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string3).append(": ").append(string4).toString();
                    }
                    finally {
                        timeoutFuture.setException(new TimeoutFutureException(message));
                    }
                }
                finally {
                    delegate.cancel(true);
                }
            }
        }
    }
}

