/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.google.common.io;

import io.mantisrx.shaded.com.google.common.annotations.GwtCompatible;
import io.mantisrx.shaded.com.google.common.annotations.GwtIncompatible;
import io.mantisrx.shaded.com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

@GwtCompatible(emulated=true)
final class GwtWorkarounds {
    private GwtWorkarounds() {
    }

    @GwtIncompatible(value="Reader")
    static CharInput asCharInput(final Reader reader2) {
        Preconditions.checkNotNull(reader2);
        return new CharInput(){

            @Override
            public int read() throws IOException {
                return reader2.read();
            }

            @Override
            public void close() throws IOException {
                reader2.close();
            }
        };
    }

    static CharInput asCharInput(final CharSequence chars2) {
        Preconditions.checkNotNull(chars2);
        return new CharInput(){
            int index = 0;

            @Override
            public int read() {
                if (this.index < chars2.length()) {
                    return chars2.charAt(this.index++);
                }
                return -1;
            }

            @Override
            public void close() {
                this.index = chars2.length();
            }
        };
    }

    @GwtIncompatible(value="InputStream")
    static InputStream asInputStream(final ByteInput input) {
        Preconditions.checkNotNull(input);
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return input.read();
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                Preconditions.checkNotNull(b);
                Preconditions.checkPositionIndexes(off, off + len, b.length);
                if (len == 0) {
                    return 0;
                }
                int firstByte = this.read();
                if (firstByte == -1) {
                    return -1;
                }
                b[off] = (byte)firstByte;
                for (int dst = 1; dst < len; ++dst) {
                    int readByte = this.read();
                    if (readByte == -1) {
                        return dst;
                    }
                    b[off + dst] = (byte)readByte;
                }
                return len;
            }

            @Override
            public void close() throws IOException {
                input.close();
            }
        };
    }

    @GwtIncompatible(value="OutputStream")
    static OutputStream asOutputStream(final ByteOutput output) {
        Preconditions.checkNotNull(output);
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                output.write((byte)b);
            }

            @Override
            public void flush() throws IOException {
                output.flush();
            }

            @Override
            public void close() throws IOException {
                output.close();
            }
        };
    }

    @GwtIncompatible(value="Writer")
    static CharOutput asCharOutput(final Writer writer2) {
        Preconditions.checkNotNull(writer2);
        return new CharOutput(){

            @Override
            public void write(char c) throws IOException {
                writer2.append(c);
            }

            @Override
            public void flush() throws IOException {
                writer2.flush();
            }

            @Override
            public void close() throws IOException {
                writer2.close();
            }
        };
    }

    static CharOutput stringBuilderOutput(int initialSize) {
        final StringBuilder builder = new StringBuilder(initialSize);
        return new CharOutput(){

            @Override
            public void write(char c) {
                builder.append(c);
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }

            public String toString() {
                return builder.toString();
            }
        };
    }

    static interface CharOutput {
        public void write(char var1) throws IOException;

        public void flush() throws IOException;

        public void close() throws IOException;
    }

    static interface ByteOutput {
        public void write(byte var1) throws IOException;

        public void flush() throws IOException;

        public void close() throws IOException;
    }

    static interface ByteInput {
        public int read() throws IOException;

        public void close() throws IOException;
    }

    static interface CharInput {
        public int read() throws IOException;

        public void close() throws IOException;
    }
}

