/*
 * Decompiled with CFR 0.152.
 */
package rx.observables;

import java.util.Comparator;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Functions;
import rx.math.operators.OperatorAverageDouble;
import rx.math.operators.OperatorAverageFloat;
import rx.math.operators.OperatorAverageInteger;
import rx.math.operators.OperatorAverageLong;
import rx.math.operators.OperatorMinMax;
import rx.math.operators.OperatorSum;

public class MathObservable<T> {
    private final Observable<T> o;

    private MathObservable(Observable<T> o) {
        this.o = o;
    }

    public static <T> MathObservable<T> from(Observable<T> o) {
        return new MathObservable<T>(o);
    }

    public static final Observable<Double> averageDouble(Observable<Double> source2) {
        return source2.lift(new OperatorAverageDouble(Functions.identity()));
    }

    public static final Observable<Float> averageFloat(Observable<Float> source2) {
        return source2.lift(new OperatorAverageFloat(Functions.identity()));
    }

    public static final Observable<Integer> averageInteger(Observable<Integer> source2) {
        return source2.lift(new OperatorAverageInteger(Functions.identity()));
    }

    public static final Observable<Long> averageLong(Observable<Long> source2) {
        return source2.lift(new OperatorAverageLong(Functions.identity()));
    }

    public static final <T extends Comparable<? super T>> Observable<T> max(Observable<T> source2) {
        return OperatorMinMax.max(source2);
    }

    public static final <T extends Comparable<? super T>> Observable<T> min(Observable<T> source2) {
        return OperatorMinMax.min(source2);
    }

    public static final Observable<Double> sumDouble(Observable<Double> source2) {
        return OperatorSum.sumDoubles(source2);
    }

    public static final Observable<Float> sumFloat(Observable<Float> source2) {
        return OperatorSum.sumFloats(source2);
    }

    public static final Observable<Integer> sumInteger(Observable<Integer> source2) {
        return OperatorSum.sumIntegers(source2);
    }

    public static final Observable<Long> sumLong(Observable<Long> source2) {
        return OperatorSum.sumLongs(source2);
    }

    public final Observable<Double> averageDouble(Func1<? super T, Double> valueExtractor) {
        return this.o.lift(new OperatorAverageDouble<T>(valueExtractor));
    }

    public final Observable<Float> averageFloat(Func1<? super T, Float> valueExtractor) {
        return this.o.lift(new OperatorAverageFloat<T>(valueExtractor));
    }

    public final Observable<Integer> averageInteger(Func1<? super T, Integer> valueExtractor) {
        return this.o.lift(new OperatorAverageInteger<T>(valueExtractor));
    }

    public final Observable<Long> averageLong(Func1<? super T, Long> valueExtractor) {
        return this.o.lift(new OperatorAverageLong<T>(valueExtractor));
    }

    public final Observable<T> max(Comparator<? super T> comparator2) {
        return OperatorMinMax.max(this.o, comparator2);
    }

    public final Observable<T> min(Comparator<? super T> comparator2) {
        return OperatorMinMax.min(this.o, comparator2);
    }

    public final Observable<Double> sumDouble(Func1<? super T, Double> valueExtractor) {
        return OperatorSum.sumAtLeastOneDoubles(this.o.map(valueExtractor));
    }

    public final Observable<Float> sumFloat(Func1<? super T, Float> valueExtractor) {
        return OperatorSum.sumAtLeastOneFloats(this.o.map(valueExtractor));
    }

    public final Observable<Integer> sumInteger(Func1<? super T, Integer> valueExtractor) {
        return OperatorSum.sumAtLeastOneIntegers(this.o.map(valueExtractor));
    }

    public final Observable<Long> sumLong(Func1<? super T, Long> valueExtractor) {
        return OperatorSum.sumAtLeastOneLongs(this.o.map(valueExtractor));
    }
}

