/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import java.lang.reflect.Field;
import java.util.Iterator;
import org.jctools.queues.BaseSpscLinkedArrayQueueConsumerField;
import org.jctools.queues.BaseSpscLinkedArrayQueueProducerFields;
import org.jctools.queues.CircularArrayOffsetCalculator;
import org.jctools.queues.QueueProgressIndicators;
import org.jctools.util.UnsafeAccess;
import org.jctools.util.UnsafeRefArrayAccess;

abstract class BaseSpscLinkedArrayQueue<E>
extends BaseSpscLinkedArrayQueueConsumerField<E>
implements QueueProgressIndicators {
    protected static final Object JUMP;
    private static final long P_INDEX_OFFSET;
    private static final long C_INDEX_OFFSET;

    BaseSpscLinkedArrayQueue() {
    }

    @Override
    public int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    protected void soProducerIndex(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_INDEX_OFFSET, v);
    }

    protected void soConsumerIndex(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, C_INDEX_OFFSET, v);
    }

    protected long lvProducerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, P_INDEX_OFFSET);
    }

    protected long lvConsumerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, C_INDEX_OFFSET);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    protected final void soNext(E[] curr, E[] next2) {
        UnsafeRefArrayAccess.soElement(curr, this.nextArrayOffset(curr), next2);
    }

    protected final E[] lvNext(E[] curr) {
        long nextArrayOffset = this.nextArrayOffset(curr);
        Object[] nextBuffer = (Object[])UnsafeRefArrayAccess.lvElement(curr, nextArrayOffset);
        UnsafeRefArrayAccess.soElement(curr, nextArrayOffset, null);
        return nextBuffer;
    }

    private long nextArrayOffset(E[] curr) {
        return UnsafeRefArrayAccess.REF_ARRAY_BASE + ((long)(curr.length - 1) << UnsafeRefArrayAccess.REF_ELEMENT_SHIFT);
    }

    @Override
    public boolean offer(E e2) {
        if (null == e2) {
            throw new NullPointerException();
        }
        Object[] buffer = this.producerBuffer;
        long index2 = this.producerIndex;
        long mask = this.producerMask;
        long offset = CircularArrayOffsetCalculator.calcElementOffset(index2, mask);
        if (index2 < this.producerLimit) {
            this.writeToQueue(buffer, e2, index2, offset);
            return true;
        }
        return this.offerColdPath(buffer, mask, e2, index2, offset);
    }

    protected abstract boolean offerColdPath(E[] var1, long var2, E var4, long var5, long var7);

    protected final void writeToQueue(E[] buffer, E e2, long index2, long offset) {
        UnsafeRefArrayAccess.soElement(buffer, offset, e2);
        this.soProducerIndex(index2 + 1L);
    }

    @Override
    public E poll() {
        boolean isNextBuffer;
        Object[] buffer = this.consumerBuffer;
        long index2 = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = CircularArrayOffsetCalculator.calcElementOffset(index2, mask);
        Object e2 = UnsafeRefArrayAccess.lvElement(buffer, offset);
        boolean bl = isNextBuffer = e2 == JUMP;
        if (null != e2 && !isNextBuffer) {
            this.soConsumerIndex(index2 + 1L);
            UnsafeRefArrayAccess.soElement(buffer, offset, null);
            return (E)e2;
        }
        if (isNextBuffer) {
            return (E)this.newBufferPoll(buffer, index2);
        }
        return null;
    }

    @Override
    public E peek() {
        Object[] buffer = this.consumerBuffer;
        long index2 = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = CircularArrayOffsetCalculator.calcElementOffset(index2, mask);
        Object e2 = UnsafeRefArrayAccess.lvElement(buffer, offset);
        if (e2 == JUMP) {
            return (E)this.newBufferPeek(buffer, index2);
        }
        return (E)e2;
    }

    private E newBufferPeek(E[] buffer, long index2) {
        long newMask;
        E[] nextBuffer = this.lvNext(buffer);
        this.consumerBuffer = nextBuffer;
        this.consumerMask = newMask = (long)(nextBuffer.length - 2);
        long offsetInNew = CircularArrayOffsetCalculator.calcElementOffset(index2, newMask);
        return UnsafeRefArrayAccess.lvElement(nextBuffer, offsetInNew);
    }

    private E newBufferPoll(E[] buffer, long index2) {
        long newMask;
        E[] nextBuffer = this.lvNext(buffer);
        this.consumerBuffer = nextBuffer;
        this.consumerMask = newMask = (long)(nextBuffer.length - 2);
        long offsetInNew = CircularArrayOffsetCalculator.calcElementOffset(index2, newMask);
        E n = UnsafeRefArrayAccess.lvElement(nextBuffer, offsetInNew);
        if (null == n) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        this.soConsumerIndex(index2 + 1L);
        UnsafeRefArrayAccess.soElement(nextBuffer, offsetInNew, null);
        return n;
    }

    static {
        Field iField;
        JUMP = new Object();
        try {
            iField = BaseSpscLinkedArrayQueueProducerFields.class.getDeclaredField("producerIndex");
            P_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(iField);
        }
        catch (NoSuchFieldException e2) {
            throw new RuntimeException(e2);
        }
        try {
            iField = BaseSpscLinkedArrayQueueConsumerField.class.getDeclaredField("consumerIndex");
            C_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(iField);
        }
        catch (NoSuchFieldException e3) {
            throw new RuntimeException(e3);
        }
    }
}

