/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.helpers.LogLog;

public class ZeroConfSupport {
    private static Object jmDNS = ZeroConfSupport.initializeJMDNS();
    Object serviceInfo;
    private static Class jmDNSClass;
    private static Class serviceInfoClass;

    public ZeroConfSupport(String zone, int port, String name2, Map properties2) {
        boolean isVersion3 = false;
        try {
            jmDNSClass.getMethod("create", null);
            isVersion3 = true;
        }
        catch (NoSuchMethodException e2) {
            // empty catch block
        }
        if (isVersion3) {
            LogLog.debug("using JmDNS version 3 to construct serviceInfo instance");
            this.serviceInfo = this.buildServiceInfoVersion3(zone, port, name2, properties2);
        } else {
            LogLog.debug("using JmDNS version 1.0 to construct serviceInfo instance");
            this.serviceInfo = this.buildServiceInfoVersion1(zone, port, name2, properties2);
        }
    }

    public ZeroConfSupport(String zone, int port, String name2) {
        this(zone, port, name2, new HashMap());
    }

    private static Object createJmDNSVersion1() {
        try {
            return jmDNSClass.newInstance();
        }
        catch (InstantiationException e2) {
            LogLog.warn("Unable to instantiate JMDNS", e2);
        }
        catch (IllegalAccessException e3) {
            LogLog.warn("Unable to instantiate JMDNS", e3);
        }
        return null;
    }

    private static Object createJmDNSVersion3() {
        try {
            Method jmDNSCreateMethod = jmDNSClass.getMethod("create", null);
            return jmDNSCreateMethod.invoke(null, null);
        }
        catch (IllegalAccessException e2) {
            LogLog.warn("Unable to instantiate jmdns class", e2);
        }
        catch (NoSuchMethodException e3) {
            LogLog.warn("Unable to access constructor", e3);
        }
        catch (InvocationTargetException e4) {
            LogLog.warn("Unable to call constructor", e4);
        }
        return null;
    }

    private Object buildServiceInfoVersion1(String zone, int port, String name2, Map properties2) {
        Hashtable hashtableProperties = new Hashtable(properties2);
        try {
            Class[] args = new Class[]{String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Hashtable.class};
            Constructor constructor = serviceInfoClass.getConstructor(args);
            Object[] values = new Object[]{zone, name2, new Integer(port), new Integer(0), new Integer(0), hashtableProperties};
            Object result = constructor.newInstance(values);
            LogLog.debug("created serviceinfo: " + result);
            return result;
        }
        catch (IllegalAccessException e2) {
            LogLog.warn("Unable to construct ServiceInfo instance", e2);
        }
        catch (NoSuchMethodException e3) {
            LogLog.warn("Unable to get ServiceInfo constructor", e3);
        }
        catch (InstantiationException e4) {
            LogLog.warn("Unable to construct ServiceInfo instance", e4);
        }
        catch (InvocationTargetException e5) {
            LogLog.warn("Unable to construct ServiceInfo instance", e5);
        }
        return null;
    }

    private Object buildServiceInfoVersion3(String zone, int port, String name2, Map properties2) {
        try {
            Class[] args = new Class[]{String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Map.class};
            Method serviceInfoCreateMethod = serviceInfoClass.getMethod("create", args);
            Object[] values = new Object[]{zone, name2, new Integer(port), new Integer(0), new Integer(0), properties2};
            Object result = serviceInfoCreateMethod.invoke(null, values);
            LogLog.debug("created serviceinfo: " + result);
            return result;
        }
        catch (IllegalAccessException e2) {
            LogLog.warn("Unable to invoke create method", e2);
        }
        catch (NoSuchMethodException e3) {
            LogLog.warn("Unable to find create method", e3);
        }
        catch (InvocationTargetException e4) {
            LogLog.warn("Unable to invoke create method", e4);
        }
        return null;
    }

    public void advertise() {
        try {
            Method method = jmDNSClass.getMethod("registerService", serviceInfoClass);
            method.invoke(jmDNS, this.serviceInfo);
            LogLog.debug("registered serviceInfo: " + this.serviceInfo);
        }
        catch (IllegalAccessException e2) {
            LogLog.warn("Unable to invoke registerService method", e2);
        }
        catch (NoSuchMethodException e3) {
            LogLog.warn("No registerService method", e3);
        }
        catch (InvocationTargetException e4) {
            LogLog.warn("Unable to invoke registerService method", e4);
        }
    }

    public void unadvertise() {
        try {
            Method method = jmDNSClass.getMethod("unregisterService", serviceInfoClass);
            method.invoke(jmDNS, this.serviceInfo);
            LogLog.debug("unregistered serviceInfo: " + this.serviceInfo);
        }
        catch (IllegalAccessException e2) {
            LogLog.warn("Unable to invoke unregisterService method", e2);
        }
        catch (NoSuchMethodException e3) {
            LogLog.warn("No unregisterService method", e3);
        }
        catch (InvocationTargetException e4) {
            LogLog.warn("Unable to invoke unregisterService method", e4);
        }
    }

    private static Object initializeJMDNS() {
        try {
            jmDNSClass = Class.forName("javax.jmdns.JmDNS");
            serviceInfoClass = Class.forName("javax.jmdns.ServiceInfo");
        }
        catch (ClassNotFoundException e2) {
            LogLog.warn("JmDNS or serviceInfo class not found", e2);
        }
        boolean isVersion3 = false;
        try {
            jmDNSClass.getMethod("create", null);
            isVersion3 = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (isVersion3) {
            return ZeroConfSupport.createJmDNSVersion3();
        }
        return ZeroConfSupport.createJmDNSVersion1();
    }

    public static Object getJMDNSInstance() {
        return jmDNS;
    }
}

