/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.cache;

import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.annotations.Beta;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.cache.AbstractCache;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.cache.LoadingCache;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableMap;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.Maps;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutionException;

@Beta
public abstract class AbstractLoadingCache<K, V>
extends AbstractCache<K, V>
implements LoadingCache<K, V> {
    protected AbstractLoadingCache() {
    }

    @Override
    public V getUnchecked(K key2) {
        try {
            return this.get(key2);
        }
        catch (ExecutionException e2) {
            throw new UncheckedExecutionException(e2.getCause());
        }
    }

    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys2) throws ExecutionException {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (K key2 : keys2) {
            if (result.containsKey(key2)) continue;
            result.put(key2, this.get(key2));
        }
        return ImmutableMap.copyOf(result);
    }

    @Override
    public final V apply(K key2) {
        return this.getUnchecked(key2);
    }

    @Override
    public void refresh(K key2) {
        throw new UnsupportedOperationException();
    }
}

