/*
 * Decompiled with CFR 0.152.
 */
package rx.math.operators;

import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public final class OperatorAverageInteger<T>
implements Observable.Operator<Integer, T> {
    final Func1<? super T, Integer> valueExtractor;

    public OperatorAverageInteger(Func1<? super T, Integer> valueExtractor) {
        this.valueExtractor = valueExtractor;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super Integer> t1) {
        return new AverageObserver(t1);
    }

    private final class AverageObserver
    extends Subscriber<T> {
        final Subscriber<? super Integer> child;
        int sum;
        int count;

        public AverageObserver(Subscriber<? super Integer> subscriber2) {
            super(subscriber2);
            this.child = subscriber2;
        }

        @Override
        public void onNext(T args) {
            this.sum += OperatorAverageInteger.this.valueExtractor.call(args).intValue();
            ++this.count;
        }

        @Override
        public void onError(Throwable e2) {
            this.child.onError(e2);
        }

        @Override
        public void onCompleted() {
            if (this.count > 0) {
                try {
                    this.child.onNext((Integer)(this.sum / this.count));
                }
                catch (Throwable t) {
                    this.child.onError(t);
                    return;
                }
                this.child.onCompleted();
            } else {
                this.child.onError(new IllegalArgumentException("Sequence contains no elements"));
            }
        }
    }
}

