/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer.categoryexplorer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryAbstractCellEditor;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryExplorerModel;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNode;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNodeEditorRenderer;

public class CategoryNodeEditor
extends CategoryAbstractCellEditor {
    protected CategoryNodeEditorRenderer _renderer = new CategoryNodeEditorRenderer();
    protected CategoryNode _lastEditedNode;
    protected JCheckBox _checkBox = this._renderer.getCheckBox();
    protected CategoryExplorerModel _categoryModel;
    protected JTree _tree;

    public CategoryNodeEditor(CategoryExplorerModel model) {
        this._categoryModel = model;
        this._checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                CategoryNodeEditor.this._categoryModel.update(CategoryNodeEditor.this._lastEditedNode, CategoryNodeEditor.this._checkBox.isSelected());
                CategoryNodeEditor.this.stopCellEditing();
            }
        });
        this._renderer.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e2) {
                if ((e2.getModifiers() & 4) != 0) {
                    CategoryNodeEditor.this.showPopup(CategoryNodeEditor.this._lastEditedNode, e2.getX(), e2.getY());
                }
                CategoryNodeEditor.this.stopCellEditing();
            }
        });
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        this._lastEditedNode = (CategoryNode)value;
        this._tree = tree;
        return this._renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, true);
    }

    public Object getCellEditorValue() {
        return this._lastEditedNode.getUserObject();
    }

    protected JMenuItem createPropertiesMenuItem(final CategoryNode node2) {
        JMenuItem result = new JMenuItem("Properties");
        result.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                CategoryNodeEditor.this.showPropertiesDialog(node2);
            }
        });
        return result;
    }

    protected void showPropertiesDialog(CategoryNode node2) {
        JOptionPane.showMessageDialog(this._tree, this.getDisplayedProperties(node2), "Category Properties: " + node2.getTitle(), -1);
    }

    protected Object getDisplayedProperties(CategoryNode node2) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Category: " + node2.getTitle());
        if (node2.hasFatalRecords()) {
            result.add("Contains at least one fatal LogRecord.");
        }
        if (node2.hasFatalChildren()) {
            result.add("Contains descendants with a fatal LogRecord.");
        }
        result.add("LogRecords in this category alone: " + node2.getNumberOfContainedRecords());
        result.add("LogRecords in descendant categories: " + node2.getNumberOfRecordsFromChildren());
        result.add("LogRecords in this category including descendants: " + node2.getTotalNumberOfRecords());
        return result.toArray();
    }

    protected void showPopup(CategoryNode node2, int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        popup.setSize(150, 400);
        if (node2.getParent() == null) {
            popup.add(this.createRemoveMenuItem());
            popup.addSeparator();
        }
        popup.add(this.createSelectDescendantsMenuItem(node2));
        popup.add(this.createUnselectDescendantsMenuItem(node2));
        popup.addSeparator();
        popup.add(this.createExpandMenuItem(node2));
        popup.add(this.createCollapseMenuItem(node2));
        popup.addSeparator();
        popup.add(this.createPropertiesMenuItem(node2));
        popup.show(this._renderer, x, y);
    }

    protected JMenuItem createSelectDescendantsMenuItem(final CategoryNode node2) {
        JMenuItem selectDescendants = new JMenuItem("Select All Descendant Categories");
        selectDescendants.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                CategoryNodeEditor.this._categoryModel.setDescendantSelection(node2, true);
            }
        });
        return selectDescendants;
    }

    protected JMenuItem createUnselectDescendantsMenuItem(final CategoryNode node2) {
        JMenuItem unselectDescendants = new JMenuItem("Deselect All Descendant Categories");
        unselectDescendants.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                CategoryNodeEditor.this._categoryModel.setDescendantSelection(node2, false);
            }
        });
        return unselectDescendants;
    }

    protected JMenuItem createExpandMenuItem(final CategoryNode node2) {
        JMenuItem result = new JMenuItem("Expand All Descendant Categories");
        result.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                CategoryNodeEditor.this.expandDescendants(node2);
            }
        });
        return result;
    }

    protected JMenuItem createCollapseMenuItem(final CategoryNode node2) {
        JMenuItem result = new JMenuItem("Collapse All Descendant Categories");
        result.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                CategoryNodeEditor.this.collapseDescendants(node2);
            }
        });
        return result;
    }

    protected JMenuItem createRemoveMenuItem() {
        JMenuItem result = new JMenuItem("Remove All Empty Categories");
        result.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                while (CategoryNodeEditor.this.removeUnusedNodes() > 0) {
                }
            }
        });
        return result;
    }

    protected void expandDescendants(CategoryNode node2) {
        Enumeration<TreeNode> descendants2 = node2.depthFirstEnumeration();
        while (descendants2.hasMoreElements()) {
            CategoryNode current = (CategoryNode)descendants2.nextElement();
            this.expand(current);
        }
    }

    protected void collapseDescendants(CategoryNode node2) {
        Enumeration<TreeNode> descendants2 = node2.depthFirstEnumeration();
        while (descendants2.hasMoreElements()) {
            CategoryNode current = (CategoryNode)descendants2.nextElement();
            this.collapse(current);
        }
    }

    protected int removeUnusedNodes() {
        int count2 = 0;
        CategoryNode root2 = this._categoryModel.getRootCategoryNode();
        Enumeration<TreeNode> enumeration = root2.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            CategoryNode node2 = (CategoryNode)enumeration.nextElement();
            if (!node2.isLeaf() || node2.getNumberOfContainedRecords() != 0 || node2.getParent() == null) continue;
            this._categoryModel.removeNodeFromParent(node2);
            ++count2;
        }
        return count2;
    }

    protected void expand(CategoryNode node2) {
        this._tree.expandPath(this.getTreePath(node2));
    }

    protected TreePath getTreePath(CategoryNode node2) {
        return new TreePath(node2.getPath());
    }

    protected void collapse(CategoryNode node2) {
        this._tree.collapsePath(this.getTreePath(node2));
    }
}

