/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import org.apache.commons.io.file.PathVisitor;
import org.apache.commons.io.filefilter.IOFileFilter;

public abstract class AbstractFileFilter
implements IOFileFilter,
PathVisitor {
    static FileVisitResult toFileVisitResult(boolean accept, Path path2) {
        return accept ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
    }

    @Override
    public boolean accept(File file2) {
        Objects.requireNonNull(file2, "file");
        return this.accept(file2.getParentFile(), file2.getName());
    }

    @Override
    public boolean accept(File dir2, String name2) {
        Objects.requireNonNull(name2, "name");
        return this.accept(new File(dir2, name2));
    }

    protected FileVisitResult handle(Throwable t) {
        return FileVisitResult.TERMINATE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir2, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir2, BasicFileAttributes attributes) throws IOException {
        return this.accept(dir2, attributes);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public FileVisitResult visitFile(Path file2, BasicFileAttributes attributes) throws IOException {
        return this.accept(file2, attributes);
    }

    @Override
    public FileVisitResult visitFileFailed(Path file2, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }
}

