/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.protocol.udp.server;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.nio.NioDatagramChannel;
import mantis.io.reactivex.netty.channel.ConnectionHandler;
import mantis.io.reactivex.netty.metrics.MetricEventsListener;
import mantis.io.reactivex.netty.metrics.MetricEventsListenerFactory;
import mantis.io.reactivex.netty.pipeline.ssl.SSLEngineFactory;
import mantis.io.reactivex.netty.protocol.udp.server.UdpServer;
import mantis.io.reactivex.netty.server.AbstractServerBuilder;
import mantis.io.reactivex.netty.server.ServerMetricsEvent;

public class UdpServerBuilder<I, O>
extends AbstractServerBuilder<I, O, Bootstrap, Channel, UdpServerBuilder<I, O>, UdpServer<I, O>> {
    public UdpServerBuilder(int port, ConnectionHandler<I, O> connectionHandler) {
        this(port, connectionHandler, new Bootstrap());
    }

    public UdpServerBuilder(int port, ConnectionHandler<I, O> connectionHandler, Bootstrap bootstrap) {
        super(port, bootstrap, connectionHandler);
    }

    @Override
    protected Class<? extends Channel> defaultServerChannelClass() {
        return NioDatagramChannel.class;
    }

    @Override
    public UdpServerBuilder<I, O> defaultChannelOptions() {
        this.channelOption(ChannelOption.SO_BROADCAST, true);
        return (UdpServerBuilder)super.defaultChannelOptions();
    }

    @Override
    public UdpServerBuilder<I, O> withSslEngineFactory(SSLEngineFactory sslEngineFactory) {
        throw new IllegalArgumentException("SSL protocol is not applicable to UDP ");
    }

    @Override
    protected UdpServer<I, O> createServer() {
        if (null != this.pipelineConfigurator) {
            return new UdpServer((Bootstrap)this.serverBootstrap, this.port, this.pipelineConfigurator, this.connectionHandler, this.eventExecutorGroup);
        }
        return new UdpServer((Bootstrap)this.serverBootstrap, this.port, this.connectionHandler, this.eventExecutorGroup);
    }

    @Override
    protected MetricEventsListener<ServerMetricsEvent<?>> newMetricsListener(MetricEventsListenerFactory factory, UdpServer<I, O> server2) {
        return factory.forUdpServer(server2);
    }
}

