/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.protocol.http.server.file;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import mantis.io.reactivex.netty.protocol.http.server.file.FileRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathFileRequestHandler
extends FileRequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(ClassPathFileRequestHandler.class);
    private final String prefix;

    public ClassPathFileRequestHandler(String prefix) {
        this.prefix = prefix;
        while (prefix.endsWith(File.separator)) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
    }

    @Override
    protected URI resolveUri(String path2) {
        String resourcePath = this.prefix + path2;
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource(resourcePath);
            if (url == null) {
                logger.debug("Resource '{}' not found ", (Object)resourcePath);
                return null;
            }
            return url.toURI();
        }
        catch (URISyntaxException e2) {
            logger.debug("Error resolving uri for '{}'", (Object)resourcePath);
            return null;
        }
    }
}

